package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.StringPool;
import com.ejianc.business.panhuo.bean.ImgdetailEntity;
import com.ejianc.business.panhuo.bean.ShelfBatchDetailEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.business.panhuo.vo.ShelfBatchDetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.ShelfBatchEntity;
import com.ejianc.business.panhuo.service.IShelfBatchService;
import com.ejianc.business.panhuo.vo.ShelfBatchVO;

import static java.util.stream.Collectors.joining;

/**
 * 批量上架主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("shelfBatch")
public class ShelfBatchController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi fileApi;

    private static final String BILL_CODE = "PLSJ_CODE";//此处需要根据实际修改

    @Autowired
    private IShelfBatchService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IGoodsService goodsService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ShelfBatchVO> saveOrUpdate(@RequestBody ShelfBatchVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ShelfBatchEntity data = saveOrUpdateVO.getId() == null ? null : service.selectById(saveOrUpdateVO.getId());
        BigDecimal shelfMny = BigDecimal.ZERO;
        BigDecimal nums = BigDecimal.ZERO;
        for (ShelfBatchDetailVO shelfBatchDetailVO : saveOrUpdateVO.getShelfBatchDetailList()){
            if (shelfBatchDetailVO.getRowState()==null || shelfBatchDetailVO.getRowState().equals("add") || shelfBatchDetailVO.getRowState().equals("edit")){
                if (shelfBatchDetailVO.getShelfMny() != null){
                    shelfMny = shelfBatchDetailVO.getShelfMny().add(shelfMny);
                }
                if (shelfBatchDetailVO.getRotatableNums() != null){
                    nums = shelfBatchDetailVO.getRotatableNums().add(nums);
                }
                shelfBatchDetailVO.setIsBatch("0");
                if (shelfBatchDetailVO.getLabelName() !=null && shelfBatchDetailVO.getLabelName().length()>3){
                    return CommonResponse.error("最多选择两个标签!");
                }
            }
        }
        saveOrUpdateVO.setShelfMny(shelfMny);
        saveOrUpdateVO.setNums(nums);
    	ShelfBatchEntity entity = BeanMapper.map(saveOrUpdateVO, ShelfBatchEntity.class);
        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity,false);
        // 处理图片
        List<ShelfBatchDetailEntity> detailList = entity.getShelfBatchDetailList();
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)){
            List<String> fileIds = new ArrayList<>();
            for(ShelfBatchDetailEntity detail : detailList){
                if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty(detail.getFileIds())){
                    fileIds.addAll(Arrays.asList(detail.getFileIds().split(",")));
                }
            }
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fileIds)) {                     // 用于关联文件
                fileApi.updateAttachRef(entity.getId(), fileIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
            }
            if(data != null) {
                List<ShelfBatchDetailEntity> dataList = data.getShelfBatchDetailList();
                List<String> delIds = new ArrayList<>();
                for(ShelfBatchDetailEntity detail : dataList){
                    if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty(detail.getFileIds())){
                        delIds.addAll(Arrays.asList(detail.getFileIds().split(",")));
                    }
                }
                delIds.removeAll(fileIds);
                if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(delIds)){                     // 用于删除文件
                    fileApi.delete(delIds.stream().collect(joining(StringPool.COMMA)));
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	ShelfBatchVO vo = BeanMapper.map(entity, ShelfBatchVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShelfBatchVO> queryDetail(Long id) {
    	ShelfBatchEntity entity = service.selectById(id);
    	ShelfBatchVO vo = BeanMapper.map(entity, ShelfBatchVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShelfBatchVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ShelfBatchVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ShelfBatchVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ShelfBatchVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("addressName");
        fuzzyFields.add("nums");
        fuzzyFields.add("shelfMny");
        fuzzyFields.add("name");
        fuzzyFields.add("phone");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }

        IPage<ShelfBatchEntity> page = service.queryPage(param,false);
        IPage<ShelfBatchVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShelfBatchVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ShelfBatchEntity> list = service.queryList(param);
        List<ShelfBatchVO> vos = new ArrayList<>();
        for(ShelfBatchEntity entity : list){
            ShelfBatchVO vo = BeanMapper.map(entity, ShelfBatchVO.class);
            //变更状态 0未变更 1 已变更
            if(vo.getBillState()!=null){
                if(vo.getBillState()==0){
                    vo.setBillStateName("自由态");
                }
                if(vo.getBillState()==1){
                    vo.setBillStateName("已提交");
                }
                if(vo.getBillState()==2){
                    vo.setBillStateName("审批中");
                }
                if(vo.getBillState()==3){
                    vo.setBillStateName("已通过");
                }
                if(vo.getBillState()==4){
                    vo.setBillStateName("已驳回");
                }
                if(vo.getBillState()==5){
                    vo.setBillStateName("审批中");
                }
            }
            vos.add(vo);
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("ShelfBatch-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refShelfBatchData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShelfBatchVO>> refShelfBatchData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ShelfBatchEntity> page = service.queryPage(param,false);
        IPage<ShelfBatchVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShelfBatchVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    //  获取当前登录人手机号
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }
}
