package com.ejianc.business.panhuo.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.panhuo.bean.ShoppingCartEntity;
import com.ejianc.business.panhuo.service.IShoppingCartService;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;

/**
 * 购物车
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("shoppingCart")
public class ShoppingCartController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());



    @Autowired
    private IShoppingCartService service;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ShoppingCartVO> saveOrUpdate(@RequestBody ShoppingCartVO saveOrUpdateVO) {
        return CommonResponse.success("操作成功！", service.saveShoppingCart(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ShoppingCartVO> queryDetail(Long id) {
    	ShoppingCartEntity entity = service.selectById(id);
    	ShoppingCartVO vo = BeanMapper.map(entity, ShoppingCartVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShoppingCartVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ShoppingCartVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ShoppingCartVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description 清空购物车
     * @Param [ids]
     */
    @RequestMapping(value = "/clearDelete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> clearDelete() {
        LambdaQueryWrapper<ShoppingCartEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ShoppingCartEntity::getUserId, InvocationInfoProxy.getUserid());
        service.remove(queryWrapper);
        return CommonResponse.success("购物车已清空！");
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<List<ShoppingCartVO>>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        List<ShoppingCartEntity> shoppingCartEntityList = service.queryList(param,false);
        if(CollectionUtils.isNotEmpty(shoppingCartEntityList)){
            List<ShoppingCartVO> shoppingCartVOList =  new ArrayList<>();
            for(ShoppingCartEntity shoppingCartEntity : shoppingCartEntityList){
                ShoppingCartVO shoppingCartVO = BeanMapper.map(shoppingCartEntity, ShoppingCartVO.class);
                shoppingCartVOList.add(shoppingCartVO);
            }
            //根据SellOrg出售方组织进行分组
            List<List<ShoppingCartVO>> lists = new ArrayList<>();
            Map<Long, List<ShoppingCartVO>> map = new HashMap<>();
            for (ShoppingCartVO shoppingCartVO : shoppingCartVOList) {
                List<ShoppingCartVO> list = null;
                if (map.containsKey(shoppingCartVO.getBuyOrg())) {
                    list = map.get(shoppingCartVO.getBuyOrg());
                } else {
                    list = new ArrayList<>();
                }
                list.add(shoppingCartVO);
                map.put(shoppingCartVO.getBuyOrg(), list);
            }
            for (Map.Entry<Long, List<ShoppingCartVO>> entry : map.entrySet()) {
                lists.add(entry.getValue());
            }
            return CommonResponse.success("查询列表数据成功！",lists);
        }else{
            return CommonResponse.success("查询列表数据成功！",null);
        }

    }
    /**
     * @Description queryShoppingCart 查询购物车数量
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryShoppingCart", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Integer> queryShoppingCart(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("userId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        List<ShoppingCartEntity> shoppingCartEntityList = service.queryList(param, false);
        return CommonResponse.success("查询成功！",shoppingCartEntityList.size());
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ShoppingCartEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ShoppingCart-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refShoppingCartData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ShoppingCartVO>> refShoppingCartData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ShoppingCartEntity> page = service.queryPage(param,false);
        IPage<ShoppingCartVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ShoppingCartVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
