package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.bean.CategoryEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.*;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@Controller
@RequestMapping("warn")
public class WarnController  implements Serializable  {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IWbuyService wbuyService;
    @Autowired
    private ICategoryService categoryService;
    @Autowired
    private IAddressService addressService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    /**
     * @Description shelfGoods 供需关系预警：根据我的求购发布的求购物资的末级分类查找对应集市中上架同一分类下的物资信息。根据项设置的范围或调拨组织。
     */
    @RequestMapping(value = "/supplyDemand", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse supplyDemand(HttpServletRequest request) {
        LambdaQueryWrapper<WbuyEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WbuyEntity::getStatus, 0);
        List<WbuyEntity> wbuyEntities = wbuyService.list(queryWrapper);
        Map<Long, List<WbuyEntity>> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(wbuyEntities)){
            List<WbuyEntity> list = null;
            for (WbuyEntity wb : wbuyEntities) {
                if(map.containsKey(wb.getBuyer())){
                    list = map.get(wb.getBuyer());
                }else{
                    list = new ArrayList<>();
                }
                list.add(wb);
                map.put(wb.getBuyer(), list);
            }
        }
        if(!map.isEmpty()){
            Set<String> sender = new HashSet<>();
            for(Long buyer : map.keySet()){
                if(sender.contains(buyer)){
                    continue;
                }
                List<WbuyEntity> wbList = map.get(buyer);
                for(WbuyEntity wbuyEntity : wbList){
                    String configOrgId = configService.queryConfigOrgByOrgId(wbuyEntity.getOrgId());
                    if(StringUtils.isBlank(configOrgId)){
                        continue;
                    }else {
                        LambdaQueryWrapper<CategoryEntity> ctyQuery = new LambdaQueryWrapper<>();
                        ctyQuery.eq(CategoryEntity::getWbuyId, wbuyEntity.getId());
                        List<CategoryEntity> categoryEntities = categoryService.list(ctyQuery);
                        List<Long> categoryList = categoryEntities.stream().map(CategoryEntity::getMaterialTypeId).collect(Collectors.toList());

                        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(Long.valueOf(configOrgId));
                        if(!childOrgResp.isSuccess()) {
                            throw new BusinessException("查询组织信息失败！");
                        }
                        if(CollectionUtils.isNotEmpty(childOrgResp.getData())){
                            List<Long> childIds = new ArrayList<>();
                            childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
                            LambdaQueryWrapper<GoodsEntity> goodQuery = new LambdaQueryWrapper<>();
                            goodQuery.in(GoodsEntity::getMaterialTypeId, categoryList);
                            goodQuery.in(GoodsEntity::getOrgId, childIds);
                            List<GoodsEntity> goodsEntities = goodsService.list(goodQuery);
                            if(CollectionUtils.isNotEmpty(goodsEntities)){
                                sender.add(String.valueOf(buyer));
                            }
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(sender)) {
                List<String> messageType = new ArrayList<>();
                messageType.add("sys");
                messageType.add("wjy");
                logger.info("发送信息给发布人:>----------" + sender+baseHost);
                String formurl = baseHost + "cscec5b-panhuo-frontend/#/assetMarket?isSupplyDemand=1";
                String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/marketIndex?isSupplyDemand=1";
                String subject = "【资产盘活】您发布的求购信息在集市中有对应的物资，请点击查看！";
                String content = "【资产盘活】您发布的求购信息在集市中有对应的物资，请点击查看！<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                this.sendMsg(messageType, new  ArrayList<>(sender), "notice", subject, content, mobileUrl);
            }
        }
        return  CommonResponse.success("供需关系预警成功！");
    }

    /**
     * @Description sellMatch 出售相关预警：根据我在集市中发布的上架物资的末级分类查找对应求购信息中发布的同一分类下的求购信息。根据项设置的范围或调拨组织。
     */
    @RequestMapping(value = "/sellMatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse sellMatch(HttpServletRequest request) {
        LambdaQueryWrapper<GoodsEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(GoodsEntity::getStatus, 0);
        queryWrapper.in(GoodsEntity::getBillState, 1, 3);
        List<GoodsEntity> goodsEntities = goodsService.list(queryWrapper);
        Set<String> sender = new HashSet<>();
        for(GoodsEntity goodsEntity : goodsEntities) {
            if (sender.contains(goodsEntity.getSeller())) {
                continue;
            }
            String configOrgId = configService.queryConfigOrgByOrgId(goodsEntity.getOrgId());
            if (StringUtils.isBlank(configOrgId)) {
                continue;
            } else {
                CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(Long.valueOf(configOrgId));
                if (!childOrgResp.isSuccess()) {
                    throw new BusinessException("查询组织信息失败！");
                }
                List<Long> childIds = new ArrayList<>();
                childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
                LambdaQueryWrapper<WbuyEntity> wbQuery = new LambdaQueryWrapper<>();
                wbQuery.eq(WbuyEntity::getStatus, 0);
                wbQuery.in(WbuyEntity::getOrgId, childIds);
                List<WbuyEntity> wbuyEntities = wbuyService.list(wbQuery);
                if (CollectionUtils.isNotEmpty(wbuyEntities)) {
                    List<Long> wbIdList = wbuyEntities.stream().map(WbuyEntity::getId).collect(Collectors.toList());
                    LambdaQueryWrapper<CategoryEntity> ctyQuery = new LambdaQueryWrapper<>();
                    ctyQuery.eq(CategoryEntity::getMaterialTypeId, goodsEntity.getMaterialTypeId());
                    ctyQuery.in(CategoryEntity::getWbuyId, wbIdList);
                    List<CategoryEntity> categoryEntities = categoryService.list(ctyQuery);
                    if (CollectionUtils.isNotEmpty(categoryEntities)) {
                        sender.add(String.valueOf(goodsEntity.getSeller()));
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(sender)) {
            List<String> messageType = new ArrayList<>();
            messageType.add("sys");
            messageType.add("wjy");
            logger.info("发送信息给发布人:>----------" + sender+baseHost);
            String formurl = baseHost + "cscec5b-panhuo-frontend/#/buyingInfo?isSellMatch=1";
            String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/marketPurchaseIndex?userid={userid}";
            String subject = "【资产盘活】您已上架的物资有其他项目在求购，点击查看！";
            String content = "【资产盘活】您已上架的物资有其他项目在求购，点击查看！<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            this.sendMsg(messageType, new  ArrayList<>(sender), "notice", subject, content, mobileUrl);
        }
        return  CommonResponse.success("供需关系预警成功！");
    }

    /**
     * @Description newGoods 上新提醒，根据项设置的范围或调拨组织，自动推送一定范围（100公里内）内项目上架的最新周转材信息（24小时内新上架物资个数），点击后展示上新物资。
     */
    @RequestMapping(value = "/newGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse newGoods(HttpServletRequest request) {
        List<AddressEntity> addrlist = addressService.list();
        Set<Long> userSet = new HashSet<>();
        for(AddressEntity addressEntity : addrlist){
            String configOrgId = configService.queryConfigOrgByOrgId(addressEntity.getOrgId());
            if (StringUtils.isNotBlank(configOrgId)) {
                CommonResponse<List<OrgVO>> childOrgResp = orgApi.findChildrenByParentId(Long.valueOf(configOrgId));
                if(childOrgResp.isSuccess() && CollectionUtils.isNotEmpty(childOrgResp.getData())){
                    QueryParam param = new QueryParam();
                    /** 租户隔离 */
                    param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
                    param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
                    param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
                    param.getParams().put("distance", new Parameter(QueryParam.LE, 100000));

                    Calendar calendar = Calendar.getInstance();
                    /* HOUR_OF_DAY 指示一天中小时 */
                    calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - 1);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    param.getParams().put("shelf_time", new Parameter(QueryParam.GE, df.format(calendar.getTime())));

                    List<Long> childIds = new ArrayList<>();
                    childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
                    param.getParams().put("org_id", new Parameter(QueryParam.IN, childIds));

                    QueryWrapper wrapper = changeToQueryWrapper(param);
                    List<GoodsEntity> list = goodsService.queryGoods(new Page(), wrapper, Double.toString(addressEntity.getLon()), Double.toString(addressEntity.getLat()));
                    if (CollectionUtils.isNotEmpty(list)) {
                        userSet.add(addressEntity.getUserId());
                    }
                }
            }
        }

        for(Long key : userSet){
            List<String> messageType = new ArrayList<>();
            messageType.add("sys");
            messageType.add("wjy");
            List<String> sender = new ArrayList<>();
            sender.add(key + "");
            logger.info("发送信息给发布人:>----------" + sender + baseHost);
            String formurl = baseHost + "cscec5b-panhuo-frontend/#/assetMarket";
            String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/marketIndex";
            String subject = "【资产盘活】您附近的项目昨日有新物资上架，有需要请及时查看！";
            String content = "【资产盘活】您附近的项目昨日有新物资上架，有需要请及时查看！<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        }
        return  CommonResponse.success("上新提醒预警成功！");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "五局轻量化平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", mobileUrl);
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
