package com.ejianc.business.panhuo.controller.api;

import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.QueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/goods/")
public class GoodsApi {

	@Autowired
	private IGoodsService goodsService;

	@RequestMapping(value = "queryGoodsByOrgMat", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<GoodsVO>> queryGoodsByOrgMat(@RequestBody QueryVO queryVO){
		return CommonResponse.success("查询同一调拨管理组织下数据成功", goodsService.queryGoodsByOrgMat(queryVO));
	}

}
