package com.ejianc.business.panhuo.mapper;

import com.ejianc.business.panhuo.bean.InstoreEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Update;

/**
 * <p>
 * 公司表 Mapper 接口
 * </p>
 *
 * @author weixha
 * @since 2019-06-12
 */
@Mapper
public interface SyncInstoreMapper extends BaseCrudMapper<InstoreEntity> {

    /**
     * 清空入库汇总表
     */
    @Update("truncate table ejc_nc_instore_hz")
    void truncateInstoreHZ();

    /**
     * 生成汇总表数据
     */
    @Insert("INSERT INTO ejc_nc_instore_hz (pk_material,ninnum,nprice,pk_project,pk_org)"
            + "select  n.pk_material as pkMaterial,sum(n.ninnum) AS ninnum,sum(n.nmny)/sum(n.ninnum) as nprice,n.pk_project as pkProject,n.pk_org as pkOrg"
            +"  from ejc_nc_instore n"
//            +" inner join bd_material m on n.pk_material = m.pk_material"
//            +" inner join bd_project bp on bp.pk_project = n.pk_project"
            +" group by n.pk_project,n.pk_material,n.pk_org")
    void insertInstoreHZ();

}
