package com.ejianc.business.panhuo.service;

import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.panhuo.bean.OrderEntity;

import java.util.Date;
import java.util.List;

/**
 * 订单实体
 *
 * @author generator
 *
 */
public interface IOrderService extends IBaseService<OrderEntity> {
    OrderVO saveOrder(OrderVO vo);

    OrderVO saveBatchOrder(OrderVO vo);

    String confirmerOrder(OrderVO vo);

    void  sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url);

    /**
     * 分组查询调拨单
     * @return
     */
    List<OrderVO> getAllots(String orgId,String beginDate,String endDate);

    /**
     * 查询调拨单最新生成日期
     * @param orgId
     * @return
     */
    String getAllotMaxDate(String orgId);

    /**
     * 同步NC入库单
     * @return
     */
    boolean syncInstore(String lastUpdateTime);

    /**
     * 更新同步NC入库单数据
     * @return
     */
    boolean updateSyncInstore();
    /**
     * 获取倒计时时间
     * buyTime 购买时间
     * @return
     */
    Integer closeOrderDate();


    ApplyVO pushOpApply(List<Long> ids);
}
