package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.panhuo.bean.AllotDetailEntity;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.bean.ConfigEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.AllotMapper;
import com.ejianc.business.panhuo.service.IAllotDetailService;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 调拨单
 *
 * @author generator
 *
 */
@Service("allotService")
public class AllotServiceImpl extends BaseServiceImpl<AllotMapper, AllotEntity> implements IAllotService{

    private static final String CSCEC5B_PANHUO_DBD = "CSCEC5B_PANHUO_DBD";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IConfigService configService;

    @Autowired
    private IAllotDetailService allotDetailService;

    @Autowired
    private IAllotService service;

    @Autowired
    private IProjectApi projectApi;

    @Override
    public AllotVO saveAllot(AllotVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AllotEntity entity = BeanMapper.map(vo, AllotEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        AllotVO resvo = BeanMapper.map(entity, AllotVO.class);
        return resvo;
    }

    @Override
    public void generation(String allotDateStr) {
        //定时任务每天都执行
        //租户id
        Long tenantId = InvocationInfoProxy.getTenantid();
        // 查询所有配置的组织
        // 如果是调拨管理组织，但是没有设置日期，就默认为21号
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgAllotStatus",new Parameter(QueryParam.EQ, 1));
        List<ConfigEntity> configEntityList= configService.queryList(queryParam);
        Map<Long, String> configMap = new HashMap();
        for(ConfigEntity configEntity : configEntityList){
            configMap.put(configEntity.getOrgId(), StringUtils.isBlank(configEntity.getOrgCreateDate()) ? "21" : configEntity.getOrgCreateDate());
        }

        //查询所有调拨管理组织(集团、分公司、机关部门等)
        List<Integer> typeList = new ArrayList<>();
        //集团
        typeList.add(1);
        //分公司
        typeList.add(2);
        //租户id查询根节点
        CommonResponse<List<OrgVO>> listCommonResponse = orgApi.findOrgByType(tenantId,typeList,"");
        if(!listCommonResponse.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        //所有调拨管理组织
        List<Map<String,Object>> orgList = ResultAsTree.createTreeData(BeanMapper.mapList(listCommonResponse.getData(),Map.class));
//        JSONArray orgArray = (JSONArray) JSONArray.toJSON(orgList);
//        System.out.println(orgArray);
        //获取所有调拨管理组织的配置信息
        configEntityList = getConfigTree(orgList,configMap);
//        JSONArray jsonArray = (JSONArray) JSONArray.toJSON(configEntityList);
//        System.out.println(jsonArray);

        //本月最大日期数
        String maxMonthDay = null;
        if(allotDateStr != null){
            Date date = null;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(allotDateStr);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            maxMonthDay = DateFormatUtils.format(DateUtils.setDays(date,calendar.getActualMaximum(Calendar.DAY_OF_MONTH)),"dd");
        }else{
            maxMonthDay = DateFormatUtils.format(DateUtils.setDays(new Date(),Calendar.getInstance().getActualMaximum(Calendar.DAY_OF_MONTH)),"dd");
        }

        //调拨日期,无值默认执行当前日期
        Date allotDate = null;
        try {
            allotDate = StringUtils.isEmpty(allotDateStr)?new Date(): DateUtils.parseDate(allotDateStr,"yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //开始结束时间默认值
        //开始日期:调拨日期减一个月
        String beginDate = DateFormatUtils.format(DateUtils.addMonths(allotDate, -1), "yyyy-MM-dd");
        //结束日期:调拨日期减一天
        String endDate = DateFormatUtils.format(DateUtils.addDays(allotDate, -1), "yyyy-MM-dd");

        //遍历项目组织直属调拨管理组织
        for(ConfigEntity configEntity:configEntityList) {
            //调拨日期为空,不生成调拨单
            if (StringUtils.isEmpty(configEntity.getOrgCreateDate())) {
                continue;
            }
            //调拨日期配置为-1则默认为当前月份最大日期
            if (configEntity.getOrgCreateDate().equals("最后一天")) {
                configEntity.setOrgCreateDate(maxMonthDay);
            }
            //调拨日期不匹配配置日期,不生成调拨单，调拨日期可能是多时间的，要按逗号分割后对比是否包含今天的日期
            List<String> createDateList = Arrays.asList(configEntity.getOrgCreateDate().split(","));
            if (!createDateList.contains(DateFormatUtils.format(allotDate, "dd"))) {
                continue;
            }
//            if (!configEntity.getOrgCreateDate().equals(DateFormatUtils.format(allotDate, "dd"))) {
//                continue;
//            }
            //配置日期匹配调拨日期的调拨管理组织主键
            String orgId = String.valueOf(configEntity.getOrgId());
            //查询当前组织调拨单最近生成日期,存在则替换开始日期
            String maxDate = orderService.getAllotMaxDate(orgId);
            logger.info("------orgId:"+orgId);
            logger.info("------maxDate:"+maxDate);
            logger.info("------allotDateStr:"+allotDateStr);
            //手动执行传参不更改开始日期,只生成传入调拨单日期前推一个月的调拨单
            if (StringUtils.isEmpty(allotDateStr)&&StringUtils.isNotEmpty(maxDate)) {
                beginDate = maxDate;
            }
            //查询当前调拨管理调拨单、生成调拨单及明细
            List<OrderVO> orderVOList = orderService.getAllots(orgId,beginDate,endDate);

            //生成调拨单
            for(OrderVO orderVO : orderVOList){
                AllotEntity allotEntity = new AllotEntity();
                allotEntity.setBillState(1);
                //调拨单号生成规则
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD,tenantId);
                if(billCode.isSuccess()) {
                    allotEntity.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                //调拨区间(月份)
                allotEntity.setAllotMonth(DateFormatUtils.format(allotDate,"yyyy-MM"));
                //调拨日期
                allotEntity.setDealrTime(allotDate);
                //调出负责人
                allotEntity.setConfirmer(orderVO.getSeller());
                //调出负责人名称
                allotEntity.setConfirmerName(orderVO.getSellerName());
                //调出组织
                allotEntity.setSellOrg(orderVO.getSellOrg());
                allotEntity.setParentSellOrg(orderVO.getParentSellOrg());
                //调出组织名称
                allotEntity.setSellOrgName(orderVO.getSellOrgName());
                //调出项目
                allotEntity.setSellProject(orderVO.getSellProject());
                //调出项目名称
                allotEntity.setSellProjectName(orderVO.getSellProjectName());

                // 查询出售项目部NC 实际所属组织的的来源id
                List<Long> sellIds = new ArrayList<>();
                sellIds.add(Long.valueOf(orderVO.getSellProject()));
                CommonResponse<List<ProjectRegisterVO>> sellRes =  projectApi.queryProjectByIds(sellIds);
                if(sellRes.isSuccess()&& CollectionUtils.isNotEmpty(sellRes.getData())){
                    ProjectRegisterVO project = sellRes.getData().get(0);
                    allotEntity.setParentSellRealCorpId(project.getId());
                    allotEntity.setParentSellRealNcCorp(project.getSourceId());
                    allotEntity.setParentSellRealCorpName(project.getName());
                }else{
                    logger.error(JSONObject.toJSONString(orderVO));
                    logger.error("查询出售项目信息详情失败！");
                    continue;
                }

                // 查询采购项目部NC 实际所属组织的的来源id
                List<Long> buyIds = new ArrayList<>();
                buyIds.add(Long.valueOf(orderVO.getBuyProject()));
                CommonResponse<List<ProjectRegisterVO>> buyRes =  projectApi.queryProjectByIds(buyIds);
                if(buyRes.isSuccess()&& CollectionUtils.isNotEmpty(buyRes.getData())){
                    ProjectRegisterVO project = buyRes.getData().get(0);
                    allotEntity.setParentBuyRealCorpId(project.getId());
                    allotEntity.setParentBuyRealNcCorp(project.getSourceId());
                    allotEntity.setParentBuyRealCorpName(project.getName());
                }else{
                    logger.error(JSONObject.toJSONString(orderVO));
                    logger.error("查询采购项目信息详情失败！");
                    continue;
                }

                //调入负责人
                allotEntity.setOrderUserId(orderVO.getOrderUserId());
                //调入负责人名称
                allotEntity.setOrderUserName(orderVO.getOrderUserName());
                //调入组织
                allotEntity.setBuyOrg(orderVO.getBuyOrg());
                allotEntity.setParentBuyOrg(orderVO.getParentBuyOrg());
                //调入组织名称
                allotEntity.setBuyOrgName(orderVO.getBuyOrgName());
                //调入项目
                allotEntity.setBuyProject(orderVO.getBuyProject());
                //调入项目名称
                allotEntity.setBuyProjectName(orderVO.getBuyProjectName());
                //总金额
                allotEntity.setAmount(orderVO.getTotalMny());

                //条件查询调拨单明细，生成调拨单明细
                queryParam = new QueryParam();
                if(allotEntity.getConfirmer()!=null){
                    queryParam.getParams().put("seller", new Parameter(QueryParam.EQ, allotEntity.getConfirmer()));
                }
                if(StringUtils.isNotEmpty(allotEntity.getConfirmerName())){
                    queryParam.getParams().put("seller_name", new Parameter(QueryParam.EQ, allotEntity.getConfirmerName()));
                }
                queryParam.getParams().put("on_shelf_type", new Parameter(QueryParam.EQ, 0));
                queryParam.getParams().put("sell_org", new Parameter(QueryParam.EQ, allotEntity.getSellOrg()));
                queryParam.getParams().put("sell_project", new Parameter(QueryParam.EQ, allotEntity.getSellProject()));
                if(allotEntity.getOrderUserId()!=null){
                    queryParam.getParams().put("order_user_id", new Parameter(QueryParam.EQ, allotEntity.getOrderUserId()));
                }
                if(StringUtils.isNotEmpty(allotEntity.getOrderUserName())){
                    queryParam.getParams().put("order_user_name", new Parameter(QueryParam.EQ, allotEntity.getOrderUserName()));
                }
                queryParam.getParams().put("buy_org", new Parameter(QueryParam.EQ, allotEntity.getBuyOrg()));
                queryParam.getParams().put("buy_project", new Parameter(QueryParam.EQ, allotEntity.getBuyProject()));
                //调拨单日期
                queryParam.getParams().put("dealr_time", new Parameter(QueryParam.BETWEEN, beginDate+","+DateFormatUtils.format(allotDate, "yyyy-MM-dd")));
                List<OrderEntity> orderEntityList = orderService.queryList(queryParam);    // 问题出在这里，从订单中查询出调拨明细，，将过多参数加入
                List<AllotDetailEntity> allotDetailEntityList = new ArrayList<>();
                for(OrderEntity orderEntity : orderEntityList){
                    //调拨单明细表生成创建
                    AllotDetailEntity allotDetailEntity = new AllotDetailEntity();
                    allotDetailEntity.setGoodsId(orderEntity.getGoodsId());
                    allotDetailEntity.setOrderId(orderEntity.getId());
                    allotDetailEntity.setMaterialId(orderEntity.getMaterialId());
                    allotDetailEntity.setMaterialCode(orderEntity.getMaterialCode());
                    allotDetailEntity.setMaterialName(orderEntity.getMaterialName());
                    allotDetailEntity.setMaterialTypeId(orderEntity.getMaterialTypeId());
                    allotDetailEntity.setMaterialTypeName(orderEntity.getMaterialTypeName());
                    allotDetailEntity.setSourceId(orderEntity.getSourceId());
                    allotDetailEntity.setSystemId(orderEntity.getSystemId());
                    allotDetailEntity.setSpec(orderEntity.getSpec());
                    allotDetailEntity.setMainimgPath(orderEntity.getMainimgPath());
                    allotDetailEntity.setUnit(orderEntity.getUnit());
                    allotDetailEntity.setDiscount(orderEntity.getDiscount());
                    allotDetailEntity.setPrice(orderEntity.getPrice());
                    allotDetailEntity.setNums(orderEntity.getNums());
                    //成交金额
                    allotDetailEntity.setAmount(orderEntity.getMny());

                    // 增值税指标
                    allotDetailEntity.setTax(orderEntity.getTax() == null ? BigDecimal.ZERO:orderEntity.getTax());
                    allotDetailEntity.setTaxMny(orderEntity.getTaxMny() == null ? BigDecimal.ZERO:orderEntity.getTaxMny());
                    allotDetailEntity.setTaxOrderMny(orderEntity.getTaxOrderMny() == null ? orderEntity.getMny() : orderEntity.getTaxOrderMny());

                    //调拨日期
                    allotDetailEntity.setDealrTime(orderEntity.getDealrTime());
                    allotDetailEntity.setMemo(orderEntity.getMemo());
                    allotDetailEntityList.add(allotDetailEntity);
                }
                allotEntity.setAllotDetail(allotDetailEntityList);

                super.saveOrUpdate(allotEntity, false);
            }
        }
    }

    // 遍历组织树并生成配置
    public static List<ConfigEntity> getConfigTree(List<Map<String, Object>> list,Map<Long, String> configMap){
        //节点配置
        List<ConfigEntity> result = new ArrayList<>();
        //遍历树并生成配置
        for(Map<String, Object> stringObjectMap : list){
            //遍历配置
            ConfigEntity config = new ConfigEntity();
            config.setOrgId(Long.valueOf(String.valueOf(stringObjectMap.get("id"))));
            config.setOrgName(String.valueOf(stringObjectMap.get("name")));
            if(stringObjectMap.get("parentId")!=null){
                config.setOrgParentId(Long.valueOf(String.valueOf(stringObjectMap.get("parentId"))));
            }
            //innerCode获取最近上级节点调拨日期(如果都没有配置则为空)
            String[] innerCode = String.valueOf(stringObjectMap.get("innerCode")).split("\\|");
            for(int i=innerCode.length-1;i>=0;i--){
                if(configMap.get(Long.valueOf(innerCode[i]))!=null){
                    config.setOrgCreateDate(configMap.get(Long.valueOf(innerCode[i])));
                    break;
                }
            }
            result.add(config);
            //查看是否存在子节点
            List<Map<String, Object>> child =(List<Map<String, Object>>)stringObjectMap.get("children");
            if(child!=null){
                result.addAll(getConfigTree(child,configMap));
            }
        }
        return result;
    }

    @Override
    public void customerGeneration(String beginDate,String endDate,String orgId) {
        //定时任务每天都执行
        //租户id
        Long tenantId = InvocationInfoProxy.getTenantid();
        // 查询所有配置的组织
        // 如果是调拨管理组织，但是没有设置日期，就默认为21号
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgAllotStatus",new Parameter(QueryParam.EQ, 1));
        List<ConfigEntity> configEntityList= configService.queryList(queryParam);
        Map<Long, String> configMap = new HashMap();
        for(ConfigEntity configEntity : configEntityList){
            configMap.put(configEntity.getOrgId(), StringUtils.isBlank(configEntity.getOrgCreateDate()) ? "21" : configEntity.getOrgCreateDate());
        }
        //查询所有调拨管理组织(集团、分公司、机关部门等)
        List<Integer> typeList = new ArrayList<>();
        //集团
        typeList.add(1);
        //分公司
        typeList.add(2);
        //租户id查询根节点
        CommonResponse<List<OrgVO>> listCommonResponse = orgApi.findOrgByType(tenantId,typeList,"");
        if(!listCommonResponse.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        //所有调拨管理组织
        List<Map<String,Object>> orgList = ResultAsTree.createTreeData(BeanMapper.mapList(listCommonResponse.getData(),Map.class));
        //获取所有调拨管理组织的配置信息
        configEntityList = getConfigTree(orgList,configMap);

        //本月最大日期数
        String maxMonthDay = DateFormatUtils.format(DateUtils.setDays(new Date(),Calendar.getInstance().getActualMaximum(Calendar.DAY_OF_MONTH)),"dd");
        //调拨日期,无值默认执行当前日期
        Date allotDate = null;
        try {
            allotDate = StringUtils.isEmpty(endDate)?new Date(): DateUtils.parseDate(endDate,"yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //遍历项目组织直属调拨管理组织
        for(ConfigEntity configEntity:configEntityList) {
            logger.info("当前组织ID开始："+configEntity.getOrgId());
            logger.info("当前组织调拨日期开始："+configEntity.getOrgCreateDate());
            logger.info("当前allotDate开始："+allotDate);
            //调拨日期为空,不生成调拨单
            if (StringUtils.isEmpty(configEntity.getOrgCreateDate())) {
                continue;
            }
            //调拨日期配置为-1则默认为当前月份最大日期
            if (configEntity.getOrgCreateDate().equals("最后一天")) {
                configEntity.setOrgCreateDate(maxMonthDay);
            }
            //调拨日期不匹配配置日期,不生成调拨单
            if (!configEntity.getOrgCreateDate().equals(DateFormatUtils.format(allotDate, "dd"))) {
                continue;
            }
            if(!configEntity.getOrgId().toString().equals(orgId)){
                continue;
            }
            logger.info("当前组织ID结束："+configEntity.getOrgId());
            logger.info("当前beginDate结束："+beginDate);
            logger.info("当前endDate结束："+endDate);
            //查询当前调拨管理调拨单、生成调拨单及明细
            List<OrderVO> orderVOList = orderService.getAllots(orgId,beginDate,endDate);

            //生成调拨单
            for(OrderVO orderVO : orderVOList){
                AllotEntity allotEntity = new AllotEntity();
                allotEntity.setBillState(1);
                //调拨单号生成规则
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD,tenantId);
                if(billCode.isSuccess()) {
                    allotEntity.setBillCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                //调拨区间(月份)
                allotEntity.setAllotMonth(DateFormatUtils.format(allotDate,"yyyy-MM"));
                //调拨日期
                allotEntity.setDealrTime(allotDate);
                //调出负责人
                allotEntity.setConfirmer(orderVO.getSeller());
                //调出负责人名称
                allotEntity.setConfirmerName(orderVO.getSellerName());
                //调出组织
                allotEntity.setSellOrg(orderVO.getSellOrg());
                allotEntity.setParentSellOrg(orderVO.getParentSellOrg());
                //调出组织名称
                allotEntity.setSellOrgName(orderVO.getSellOrgName());
                //调出项目
                allotEntity.setSellProject(orderVO.getSellProject());
                //调出项目名称
                allotEntity.setSellProjectName(orderVO.getSellProjectName());
                //调入负责人
                allotEntity.setOrderUserId(orderVO.getOrderUserId());
                //调入负责人名称
                allotEntity.setOrderUserName(orderVO.getOrderUserName());
                //调入组织
                allotEntity.setBuyOrg(orderVO.getBuyOrg());
                allotEntity.setParentBuyOrg(orderVO.getParentBuyOrg());
                //调入组织名称
                allotEntity.setBuyOrgName(orderVO.getBuyOrgName());
                //调入项目
                allotEntity.setBuyProject(orderVO.getBuyProject());
                //调入项目名称
                allotEntity.setBuyProjectName(orderVO.getBuyProjectName());
                //总金额
                allotEntity.setAmount(orderVO.getTotalMny());

                //条件查询调拨单明细，生成调拨单明细
                queryParam = new QueryParam();
                if(allotEntity.getConfirmer()!=null){
                    queryParam.getParams().put("seller", new Parameter(QueryParam.EQ, allotEntity.getConfirmer()));
                }
                if(StringUtils.isNotEmpty(allotEntity.getConfirmerName())){
                    queryParam.getParams().put("seller_name", new Parameter(QueryParam.EQ, allotEntity.getConfirmerName()));
                }
                queryParam.getParams().put("on_shelf_type", new Parameter(QueryParam.EQ, 0));
                queryParam.getParams().put("sell_org", new Parameter(QueryParam.EQ, allotEntity.getSellOrg()));
                queryParam.getParams().put("sell_project", new Parameter(QueryParam.EQ, allotEntity.getSellProject()));
                if(allotEntity.getOrderUserId()!=null){
                    queryParam.getParams().put("order_user_id", new Parameter(QueryParam.EQ, allotEntity.getOrderUserId()));
                }
                if(StringUtils.isNotEmpty(allotEntity.getOrderUserName())){
                    queryParam.getParams().put("order_user_name", new Parameter(QueryParam.EQ, allotEntity.getOrderUserName()));
                }
                queryParam.getParams().put("buy_org", new Parameter(QueryParam.EQ, allotEntity.getBuyOrg()));
                queryParam.getParams().put("buy_project", new Parameter(QueryParam.EQ, allotEntity.getBuyProject()));
                //调拨单日期
                queryParam.getParams().put("dealr_time", new Parameter(QueryParam.BETWEEN, beginDate+","+DateFormatUtils.format(allotDate, "yyyy-MM-dd")));
                List<OrderEntity> orderEntityList = orderService.queryList(queryParam);    // 问题出在这里，从订单中查询出调拨明细，，将过多参数加入
                List<AllotDetailEntity> allotDetailEntityList = new ArrayList<>();
                for(OrderEntity orderEntity : orderEntityList){
                    //调拨单明细表生成创建
                    AllotDetailEntity allotDetailEntity = new AllotDetailEntity();
                    allotDetailEntity.setGoodsId(orderEntity.getGoodsId());
                    allotDetailEntity.setOrderId(orderEntity.getId());
                    allotDetailEntity.setMaterialId(orderEntity.getMaterialId());
                    allotDetailEntity.setMaterialCode(orderEntity.getMaterialCode());
                    allotDetailEntity.setMaterialName(orderEntity.getMaterialName());
                    allotDetailEntity.setMaterialTypeId(orderEntity.getMaterialTypeId());
                    allotDetailEntity.setMaterialTypeName(orderEntity.getMaterialTypeName());
                    allotDetailEntity.setSourceId(orderEntity.getSourceId());
                    allotDetailEntity.setSystemId(orderEntity.getSystemId());
                    allotDetailEntity.setSpec(orderEntity.getSpec());
                    allotDetailEntity.setMainimgPath(orderEntity.getMainimgPath());
                    allotDetailEntity.setUnit(orderEntity.getUnit());
                    allotDetailEntity.setPrice(orderEntity.getPrice());
                    allotDetailEntity.setNums(orderEntity.getNums());
                    //成交金额
                    allotDetailEntity.setAmount(orderEntity.getMny());
                    //调拨日期
                    allotDetailEntity.setDealrTime(orderEntity.getDealrTime());
                    allotDetailEntity.setMemo(orderEntity.getMemo());
                    allotDetailEntityList.add(allotDetailEntity);
                }
                allotEntity.setAllotDetail(allotDetailEntityList);

                super.saveOrUpdate(allotEntity, false);
            }
        }
    }

   /* @Override
    public void allotIsflag(String beginDate,String endDate,String orgId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        //查询当前调拨管理调拨单、生成调拨单及明细
        List<OrderVO> orderVOList = orderService.getAllots(orgId,beginDate,endDate);
        Date allotDate = null;
        try {
            allotDate = StringUtils.isEmpty(endDate)?new Date(): DateUtils.parseDate(endDate,"yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        //生成调拨单
        for(OrderVO orderVO : orderVOList){
            AllotEntity allotEntity = new AllotEntity();
            allotEntity.setBillState(1);
            //调拨单号生成规则
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD,tenantId);
            if(billCode.isSuccess()) {
                allotEntity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //调拨区间(月份)
            allotEntity.setAllotMonth(DateFormatUtils.format(allotDate,"yyyy-MM"));
            //调拨日期
            allotEntity.setDealrTime(allotDate);
            //调出负责人
            allotEntity.setConfirmer(orderVO.getSeller());
            //调出负责人名称
            allotEntity.setConfirmerName(orderVO.getSellerName());
            //调出组织
            allotEntity.setSellOrg(orderVO.getSellOrg());
            allotEntity.setParentSellOrg(orderVO.getParentSellOrg());
            //调出组织名称
            allotEntity.setSellOrgName(orderVO.getSellOrgName());
            //调出项目
            allotEntity.setSellProject(orderVO.getSellProject());
            //调出项目名称
            allotEntity.setSellProjectName(orderVO.getSellProjectName());
            //调入负责人
            allotEntity.setOrderUserId(orderVO.getOrderUserId());
            //调入负责人名称
            allotEntity.setOrderUserName(orderVO.getOrderUserName());
            //调入组织
            allotEntity.setBuyOrg(orderVO.getBuyOrg());
            allotEntity.setParentBuyOrg(orderVO.getParentBuyOrg());
            //调入组织名称
            allotEntity.setBuyOrgName(orderVO.getBuyOrgName());
            //调入项目
            allotEntity.setBuyProject(orderVO.getBuyProject());
            //调入项目名称
            allotEntity.setBuyProjectName(orderVO.getBuyProjectName());
            //总金额
            allotEntity.setAmount(orderVO.getTotalMny());

            //条件查询调拨单明细，生成调拨单明细
            QueryParam queryParam = new QueryParam();
            if(allotEntity.getConfirmer()!=null){
                queryParam.getParams().put("seller", new Parameter(QueryParam.EQ, allotEntity.getConfirmer()));
            }
            if(StringUtils.isNotEmpty(allotEntity.getConfirmerName())){
                queryParam.getParams().put("seller_name", new Parameter(QueryParam.EQ, allotEntity.getConfirmerName()));
            }
            queryParam.getParams().put("sell_org", new Parameter(QueryParam.EQ, allotEntity.getSellOrg()));
            queryParam.getParams().put("sell_project", new Parameter(QueryParam.EQ, allotEntity.getSellProject()));
            if(allotEntity.getOrderUserId()!=null){
                queryParam.getParams().put("order_user_id", new Parameter(QueryParam.EQ, allotEntity.getOrderUserId()));
            }
            if(StringUtils.isNotEmpty(allotEntity.getOrderUserName())){
                queryParam.getParams().put("order_user_name", new Parameter(QueryParam.EQ, allotEntity.getOrderUserName()));
            }
            queryParam.getParams().put("buy_org", new Parameter(QueryParam.EQ, allotEntity.getBuyOrg()));
            queryParam.getParams().put("buy_project", new Parameter(QueryParam.EQ, allotEntity.getBuyProject()));
            //调拨单日期
            queryParam.getParams().put("dealr_time", new Parameter(QueryParam.BETWEEN, beginDate+","+DateFormatUtils.format(allotDate, "yyyy-MM-dd")));
            List<OrderEntity> orderEntityList = orderService.queryList(queryParam);    // 问题出在这里，从订单中查询出调拨明细，，将过多参数加入
            List<AllotDetailEntity> allotDetailEntityList = new ArrayList<>();
            for(OrderEntity orderEntity : orderEntityList){
                //调拨单明细表生成创建
                AllotDetailEntity allotDetailEntity = new AllotDetailEntity();
                allotDetailEntity.setGoodsId(orderEntity.getGoodsId());
                allotDetailEntity.setOrderId(orderEntity.getId());
                allotDetailEntity.setMaterialId(orderEntity.getMaterialId());
                allotDetailEntity.setMaterialCode(orderEntity.getMaterialCode());
                allotDetailEntity.setMaterialName(orderEntity.getMaterialName());
                allotDetailEntity.setMaterialTypeId(orderEntity.getMaterialTypeId());
                allotDetailEntity.setMaterialTypeName(orderEntity.getMaterialTypeName());
                allotDetailEntity.setSourceId(orderEntity.getSourceId());
                allotDetailEntity.setSystemId(orderEntity.getSystemId());
                allotDetailEntity.setSpec(orderEntity.getSpec());
                allotDetailEntity.setMainimgPath(orderEntity.getMainimgPath());
                allotDetailEntity.setUnit(orderEntity.getUnit());
                allotDetailEntity.setPrice(orderEntity.getPrice());
                allotDetailEntity.setNums(orderEntity.getNums());
                //成交金额
                allotDetailEntity.setAmount(orderEntity.getMny());
                //调拨日期
                allotDetailEntity.setDealrTime(orderEntity.getDealrTime());
                allotDetailEntity.setMemo(orderEntity.getMemo());
                allotDetailEntityList.add(allotDetailEntity);
            }
            allotEntity.setAllotDetail(allotDetailEntityList);

            super.saveOrUpdate(allotEntity, false);
        }
    }*/


}
