package com.ejianc.business.panhuo.service.impl;

import com.ejianc.business.panhuo.bean.ConfigEntity;
import com.ejianc.business.panhuo.mapper.ConfigMapper;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 调拨管理组织实体
 *
 * @author generator
 *
 */
@Service("configService")
public class ConfigServiceImpl extends BaseServiceImpl<ConfigMapper, ConfigEntity> implements IConfigService{

    @Autowired
    private IOrgApi orgApi;

    @Override
    public String queryConfigOrgByOrgId(Long orgId) {
        CommonResponse<OrgVO> sellOrg = orgApi.getOneById(orgId);
        if(!sellOrg.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        QueryParam queryParam = new QueryParam();
        //查询所有配置为调拨管理组织的集团、分公司信息
        queryParam.getParams().put("orgAllotStatus",new Parameter(QueryParam.EQ,"1"));
        List<ConfigEntity> configEntityList = queryList(queryParam);
        Set<String> configSet = new HashSet<>();
        for(ConfigEntity configEntity:configEntityList){
            configSet.add(String.valueOf(configEntity.getOrgId()));
        }

        String innerCode = sellOrg.getData().getInnerCode();//调出组织内码
        String[] sellParentIdList = innerCode.contains("|")?innerCode.split("\\|"): new String[]{innerCode};
        String sellConfigOrgId = "";
        for(int i=sellParentIdList.length-1;i>=0;i--){
            String sellParentId = sellParentIdList[i];
            if(configSet.contains(sellParentId)){
                sellConfigOrgId = sellParentId;
                break;
            }
        }
        return sellConfigOrgId;
    }
}
