package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.panhuo.bean.*;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderBatchService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderBatchDetailVO;
import com.ejianc.business.panhuo.vo.OrderBatchVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Service("orderBatch") 
public class OrderBatchBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOrderService orderService;

	@Autowired
	private IOrderBatchService orderBatchService;

	@Autowired
	private IGoodsService goodsService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================提交前回调====================================== state:"+state);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("======================================有审批流的撤回后回调====================================== state:"+state);
			OrderBatchEntity orderBatchEntity = orderBatchService.selectById(billId);
			OrderBatchVO vo = BeanMapper.map(orderBatchEntity, OrderBatchVO.class);
			List<OrderBatchDetailVO> orderBatchDetailVOList = vo.getOrderBatchDetailList();
			if (CollectionUtils.isNotEmpty(orderBatchDetailVOList)) {
				for (OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList) {
					/*//撤回后释放数量
					GoodsEntity goodsEntity = goodsService.selectById(orderBatchDetailVO.getGoodsId());
					BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
					BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
					//减去预定中数量
					goodsEntity.setPreNums(preNums.subtract(orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums()));
					//加上可周转数量
					goodsEntity.setRotatableNums(rotatableNums.add(orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums()));
					logger.info("======================================可周转数量======================================:"+rotatableNums.add(orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums()));
					goodsService.saveOrUpdate(goodsEntity, false);*/
					//删除订单
					LambdaQueryWrapper<OrderEntity> queryWrapper = new LambdaQueryWrapper<>();
					queryWrapper.eq(OrderEntity::getBillCode, orderBatchDetailVO.getBillCode());
					orderService.remove(queryWrapper);
				}
			}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================终审审核前回调====================================== state:"+state);
		if(state == 0 || state == 2) {
			OrderBatchEntity orderBatchEntity = orderBatchService.selectById(billId);
			OrderBatchVO vo = BeanMapper.map(orderBatchEntity, OrderBatchVO.class);
			List<OrderBatchDetailVO> orderBatchDetailVOList = vo.getOrderBatchDetailList();
			//生成批量订单占用订单数量
			if (CollectionUtils.isNotEmpty(orderBatchDetailVOList)) {
				for (OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList) {
					GoodsEntity goodsEntity = goodsService.selectById(orderBatchDetailVO.getGoodsId());
					BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
					BigDecimal ordernums = orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums();
					if (ordernums.compareTo(rotatableNums) > 0) {
						throw new BusinessException("购物车编号：" + orderBatchDetailVO.getBillCode() + ",下单数量不能超过资产可周转数量!");
					}
					goodsEntity.setPreNums(ComputeUtil.safeAdd(goodsEntity.getPreNums(), orderBatchDetailVO.getOrdernums()));
					goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getRotatableNums(), orderBatchDetailVO.getOrdernums()));
					goodsService.saveOrUpdate(goodsEntity, false);
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//终审审核完生成单个订单
		OrderBatchEntity orderBatchEntity = orderBatchService.selectById(billId);
		List<OrderBatchDetailEntity> orderBatchDetailEntityList = orderBatchEntity.getOrderBatchDetailList();
		if (CollectionUtils.isNotEmpty(orderBatchDetailEntityList)){
			for(OrderBatchDetailEntity orderBatchDetailEntity : orderBatchDetailEntityList){
				logger.info(orderBatchDetailEntity.getBillState().toString()+"============================================================================");
				orderBatchDetailEntity.setBillState(1);
				OrderEntity orderEntity = BeanMapper.map(orderBatchDetailEntity, OrderEntity.class);
				orderEntity.setId(null);
				OrderVO orderVO = BeanMapper.map(orderEntity, OrderVO.class);
				orderService.saveBatchOrder(orderVO);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		throw new BusinessException("弃审失败！审批通过后无法弃审，请在订单中取消订单");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================弃审后事件回调====================================== state:"+state);
		OrderBatchEntity orderBatchEntity = orderBatchService.selectById(billId);
		OrderBatchVO vo = BeanMapper.map(orderBatchEntity, OrderBatchVO.class);
		List<OrderBatchDetailVO> orderBatchDetailVOList = vo.getOrderBatchDetailList();
		if(CollectionUtils.isNotEmpty(orderBatchDetailVOList)){
			for(OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList){
				//撤回后释放数量
				GoodsEntity goodsEntity = goodsService.selectById(orderBatchDetailVO.getGoodsId());
				BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
				BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
				//减去预定中数量
				goodsEntity.setPreNums(preNums.subtract(orderBatchDetailVO.getOrdernums()==null?BigDecimal.ZERO:orderBatchDetailVO.getOrdernums()));
				//加上可周转数量

				goodsEntity.setRotatableNums(rotatableNums.add(orderBatchDetailVO.getOrdernums()==null?BigDecimal.ZERO:orderBatchDetailVO.getOrdernums()));
				goodsService.saveOrUpdate(goodsEntity,false);
				//删除订单
				LambdaQueryWrapper<OrderEntity> queryWrapper = new LambdaQueryWrapper<>();
				queryWrapper.eq(OrderEntity::getBillCode,orderBatchDetailVO.getBillCode());
				orderService.remove(queryWrapper);
			}
		}
		return CommonResponse.success();
	}

}
