package com.ejianc.business.panhuo.service.impl;

import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderBatchEntity;
import com.ejianc.business.panhuo.bean.ShoppingCartEntity;
import com.ejianc.business.panhuo.mapper.OrderBatchMapper;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderBatchService;
import com.ejianc.business.panhuo.service.IShoppingCartService;
import com.ejianc.business.panhuo.vo.OrderBatchDetailVO;
import com.ejianc.business.panhuo.vo.OrderBatchVO;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 批量订单主实体
 *
 * @author generator
 *
 */
@Service("orderBatchService")
public class OrderBatchServiceImpl extends BaseServiceImpl<OrderBatchMapper, OrderBatchEntity> implements IOrderBatchService{

    private static final String BILL_CODE = "CSCEC5B_PANHUO_BO";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IShoppingCartService shoppingCartService;

    @Override
    public OrderBatchVO saveOrderBatch(OrderBatchVO vo) {
        OrderBatchEntity entity = BeanMapper.map(vo, OrderBatchEntity.class);
        this.saveOrUpdate(entity, false);
        OrderBatchVO orderBatchVO = BeanMapper.map(entity, OrderBatchVO.class);
        return orderBatchVO;
    }

    @Override
    public OrderBatchVO saveFromCart(List<ShoppingCartVO> vos) {
        OrderBatchVO orderBatchVO = new OrderBatchVO();
        List<OrderBatchDetailVO> orderBatchDetailVOLists = new ArrayList<>();
        BigDecimal totalMny = BigDecimal.ZERO;
        Boolean isFirst = Boolean.TRUE;
        for(ShoppingCartVO vo : vos){
            ShoppingCartEntity cartEntity = shoppingCartService.selectById(vo.getId());
            totalMny = ComputeUtil.safeAdd(totalMny, cartEntity.getOrdermny());
            if (isFirst) {
                orderBatchVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                orderBatchVO.setOrgId(cartEntity.getBuyOrg());
                orderBatchVO.setProjectId(cartEntity.getBuyProject());
                orderBatchVO.setProjectName(cartEntity.getBuyProjectName());
                orderBatchVO.setUserName(cartEntity.getOrderUserName());
                orderBatchVO.setUserPhone(cartEntity.getBuyPhone());
                isFirst = false;
            }
            OrderBatchDetailVO detailVO = BeanMapper.map(cartEntity, OrderBatchDetailVO.class);
            orderBatchDetailVOLists.add(detailVO);
        }
        orderBatchVO.setSumMny(totalMny);
        orderBatchVO.setOrderBatchDetailList(orderBatchDetailVOLists);
        CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid());
        if(billCode.isSuccess()) {
            orderBatchVO.setBillCode(billCode.getData());
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
     /*   //生成批量订单占用订单数量
        List<OrderBatchDetailVO> orderBatchDetailVOList = orderBatchVO.getOrderBatchDetailList();
        if(CollectionUtils.isNotEmpty(orderBatchDetailVOList)){
            for(OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList){
                GoodsEntity goodsEntity = goodsService.selectById(orderBatchDetailVO.getGoodsId());
                BigDecimal rotatableNums = goodsEntity.getRotatableNums()==null?BigDecimal.ZERO:goodsEntity.getRotatableNums();
                BigDecimal ordernums = orderBatchDetailVO.getOrdernums()==null?BigDecimal.ZERO:orderBatchDetailVO.getOrdernums();
                if(ordernums.compareTo(rotatableNums)>0){
                    throw new BusinessException("购物车编号：" + orderBatchDetailVO.getBillCode() + ",下单数量不能超过资产可周转数量!");
                }
                //如果正常就占用数量
                BigDecimal preNums = goodsEntity.getPreNums()==null?BigDecimal.ZERO:goodsEntity.getPreNums();
                goodsEntity.setPreNums(preNums.add(orderBatchDetailVO.getOrdernums()==null?BigDecimal.ZERO:orderBatchDetailVO.getOrdernums()));
                goodsEntity.setRotatableNums(rotatableNums.subtract(orderBatchDetailVO.getOrdernums()==null?BigDecimal.ZERO:orderBatchDetailVO.getOrdernums()));
                goodsService.saveOrUpdate(goodsEntity,false);
            }
        }*/
        OrderBatchEntity entity = BeanMapper.map(orderBatchVO, OrderBatchEntity.class);
        this.saveOrUpdate(entity, false);

        shoppingCartService.removeByIds(vos.stream().map(ShoppingCartVO::getId).collect(Collectors.toList()),true);

        return BeanMapper.map(selectById(entity.getId()), OrderBatchVO.class);
    }
}
