package com.ejianc.business.panhuo.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.api.IApplyApi;
import com.ejianc.business.op.vo.ApplyDetailVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.InstoreEntity;
import com.ejianc.business.panhuo.bean.InstoreHzEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.OrderMapper;
import com.ejianc.business.panhuo.mapper.SyncInstoreMapper;
import com.ejianc.business.panhuo.service.*;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.business.warn.vo.WarningParameterVO;
import com.ejianc.business.warn.vo.WarningVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 订单实体
 *
 * @author generator
 *
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String CSCEC5B_PANHUO_DD = "CSCEC5B_PANHUO_DD";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IGoodsService goodsService;

    @Autowired
    private IAllotService allotService;

    @Autowired
    private IConfigService configService;

    @Autowired
    private ISyncInstoreService syncInstoreService;

    @Autowired
    private SyncInstoreMapper syncInstoreMapper;

    @Autowired
    private IInstoreHzService instoreHzService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IMaterialApi materialApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IWarningApi warningApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${wjy.path}")
    private String wjyPath;

    @Value("${wjy.appid}")
    private String appid;

    @Value("${sync.address}")
    private String syncAddr;

    @Autowired
    private IApplyApi applyApi;

    @Override
    public OrderVO saveOrder(OrderVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        if(goodsEntity.getVersion()!=vo.getVersion()){
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }

        if(ComputeUtil.isGreaterThan(vo.getOrdernums(), goodsEntity.getRotatableNums())){
            throw new BusinessException("下单数量不能超过资产可周转数量!");
        }

        OrderEntity orderEntity = BeanMapper.map(vo,OrderEntity.class);
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setShelfType(goodsEntity.getShelfType());
        orderEntity.setShelfTime(goodsEntity.getShelfTime());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialCode(goodsEntity.getMaterialCode());
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);//待确认
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        orderEntity.setMny(vo.getOrdermny() == null ? BigDecimal.ZERO : vo.getOrdermny());
        orderEntity.setPrice(vo.getOrderprice() == null ? BigDecimal.ZERO : vo.getOrderprice());
        orderEntity.setNums(vo.getOrdernums() == null ? BigDecimal.ZERO : vo.getOrdernums());
        orderEntity.setOriginalprice(goodsEntity.getOriginalprice());
        orderEntity.setDiscount(goodsEntity.getDiscount());
        orderEntity.setPreSaleDate(goodsEntity.getPreSaleDate());
        orderEntity.setPreSaleFlag(goodsEntity.getPreSaleFlag());
        orderEntity.setOnShelfType(goodsEntity.getOnShelfType() == null ? 0 : goodsEntity.getOnShelfType());

        if(null != orderEntity.getSellOrg() && orderEntity.getSellOrg() > 0){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(orderEntity.getSellOrg());
            if(commonResponse.isSuccess()){
                OrgVO orgVO = commonResponse.getData();
                orderEntity.setParentSellOrg(orgVO.getParentId());
            }
        }

        if(null != orderEntity.getBuyOrg() && orderEntity.getBuyOrg() > 0){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(orderEntity.getBuyOrg());
            if(commonResponse.isSuccess()){
                OrgVO orgVO = commonResponse.getData();
                orderEntity.setParentBuyOrg(orgVO.getParentId());
            }else{
                throw new BusinessException("获取购买组织上级组织异常!");
            }
        }

        String sellConfigOrgId = configService.queryConfigOrgByOrgId(orderEntity.getSellOrg());//调出项目组织信息
        if(StringUtils.isEmpty(sellConfigOrgId)){
            throw new BusinessException("出售方未设置调拨管理组织!");
        }

        //查询调入项目管理组织上级列表
        String buyConfigOrgId = configService.queryConfigOrgByOrgId(orderEntity.getBuyOrg());//调入项目组织信息
        if(StringUtils.isEmpty(buyConfigOrgId)){
            throw new BusinessException("购买方未设置调拨管理组织!");
        }
        if(!sellConfigOrgId.equals(buyConfigOrgId)){
            throw new BusinessException("调拨管理组织不匹配!");
        }

        if(null!=vo&& StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DD,tenantId);
            if(billCode.isSuccess()) {
                orderEntity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        goodsEntity.setPreNums(ComputeUtil.safeAdd(goodsEntity.getPreNums(), vo.getOrdernums()));
        goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getRotatableNums(), vo.getOrdernums()));
        goodsService.saveOrUpdate(goodsEntity,false);
        super.saveOrUpdate(orderEntity, false);
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(goodsEntity.getSeller()+"");
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=1";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/sellerManage/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "【资产盘活】您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理";
        String content = "【资产盘活】您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

        OrderVO resvo = BeanMapper.map(orderEntity, OrderVO.class);
        return resvo;
    }

    @Override
    public OrderVO saveBatchOrder(OrderVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        OrderEntity orderEntity = BeanMapper.map(vo,OrderEntity.class);
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setShelfType(goodsEntity.getShelfType());
        orderEntity.setShelfTime(goodsEntity.getShelfTime());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialCode(goodsEntity.getMaterialCode());
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);//待确认
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        orderEntity.setMny(vo.getOrdermny() == null ? BigDecimal.ZERO : vo.getOrdermny());
        orderEntity.setPrice(vo.getOrderprice() == null ? BigDecimal.ZERO : vo.getOrderprice());
        orderEntity.setNums(vo.getOrdernums() == null ? BigDecimal.ZERO : vo.getOrdernums());
        orderEntity.setOriginalprice(goodsEntity.getOriginalprice());
        orderEntity.setDiscount(goodsEntity.getDiscount());
        orderEntity.setPreSaleDate(goodsEntity.getPreSaleDate());
        orderEntity.setPreSaleFlag(goodsEntity.getPreSaleFlag());
        orderEntity.setOnShelfType(goodsEntity.getOnShelfType() == null ? 0 : goodsEntity.getOnShelfType());

        if(null != orderEntity.getSellOrg() && orderEntity.getSellOrg() > 0){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(orderEntity.getSellOrg());
            if(commonResponse.isSuccess()){
                OrgVO orgVO = commonResponse.getData();
                orderEntity.setParentSellOrg(orgVO.getParentId());
            }
        }

        if(null != orderEntity.getBuyOrg() && orderEntity.getBuyOrg() > 0){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(orderEntity.getBuyOrg());
            if(commonResponse.isSuccess()){
                OrgVO orgVO = commonResponse.getData();
                orderEntity.setParentBuyOrg(orgVO.getParentId());
            }
        }
        goodsService.saveOrUpdate(goodsEntity,false);
        super.saveOrUpdate(orderEntity, false);
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(goodsEntity.getSeller()+"");
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=1";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/sellerManage/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "【资产盘活】您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理";
        String content = "【资产盘活】您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);
        OrderVO resvo = BeanMapper.map(orderEntity, OrderVO.class);
        return resvo;
    }

    @Override
    public String confirmerOrder(OrderVO vo) {
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        OrderEntity orderEntity = super.getById(vo.getId());
        if (orderEntity.getVersion() != vo.getVersion()) {
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }

        if(ComputeUtil.isGreaterThan(ComputeUtil.safeSub(vo.getNums(), orderEntity.getOrdernums()), goodsEntity.getRotatableNums())){
            throw new BusinessException("下单数量不能超过资产可周转数量!");
        }

        goodsEntity.setSellNums(ComputeUtil.safeAdd(goodsEntity.getSellNums(), vo.getNums()));//已成交
        goodsEntity.setPreNums(ComputeUtil.safeSub(goodsEntity.getPreNums(), orderEntity.getOrdernums()));//预定中
        goodsEntity.setRotatableNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums(), goodsEntity.getPreNums()));//可周转   数量-已成交数量 - 预定中数量
        goodsEntity.setRemainingNums(ComputeUtil.safeSub(goodsEntity.getNums(), goodsEntity.getSellNums()));//剩余数量
        //没有剩余数量，则商品下架
        if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
            LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
            lambdachange.eq(OrderEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId, vo.getGoodsId());
            lambdachange.eq(OrderEntity::getType, 0);
            lambdachange.ne(OrderEntity::getId, vo.getId());
            int num = super.count(lambdachange);
            if (num <= 0) {
                List<String> messageType = new ArrayList<>();
                messageType.add("sys");
                messageType.add("wjy");
                List<String> sender = new ArrayList<>();
                sender.add(goodsEntity.getSeller() + "");
                logger.info("发送信息给提交人:>----------" + sender);
                String formurl = baseHost + "cscec5b-panhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=1&lowerTime=" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT);
                String mobileUrl = wjyPath + "cscec5b-panhuo-mobile/#/goodsManage/card?id=" + goodsEntity.getId() + "&userid={userid}";
                String subject = "【资产盘活】您上架的物资【" + goodsEntity.getMaterialName() + "】已经售罄并下架";
                String content = "【资产盘活】您上架的物资【" + goodsEntity.getMaterialName() + "】已经售罄并下架。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);

                //需下架
                goodsEntity.setStatus(1);//下架
                goodsEntity.setLowerType(1);//下架类型0-手动下架，1-售罄下架，2-到期下架
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }
        }

        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(orderEntity.getOrderUserId()+"");//订购人
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=2";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/buyOrder/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "【资产盘活】您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成";
        String content = "【资产盘活】您的订单【"+orderEntity.getBillCode()+"】卖家已确认，交易完成。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);

        goodsService.saveOrUpdate(goodsEntity,false);
        orderEntity.setConfirmer(vo.getConfirmer());
        orderEntity.setConfirmName(vo.getConfirmName());
        orderEntity.setPrice(vo.getPrice());
        orderEntity.setNums(vo.getNums());
        orderEntity.setMny(vo.getMny());
        orderEntity.setTaxMny(vo.getTaxMny());
        orderEntity.setTaxOrderMny(vo.getTaxOrderMny());
        orderEntity.setMemo(vo.getMemo());

        orderEntity.setDealrTime(DateFormater.getCurrentDate());
        orderEntity.setType(1);//订单完成

        super.saveOrUpdate(orderEntity, false);
        return "success";
    }

    @Override
    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String url) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("wjy")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WJY);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", appid);
            wjyMsgParams.put("from", "五局轻量化平台");
            wjyMsgParams.put("msg", subject);
            wjyMsgParams.put("url", url);
            parameter.setWjyMsgParams(wjyMsgParams);
        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    @Override
    public List<OrderVO> getAllots(String orgId,String beginDate,String endDate) {
        return baseMapper.getAllots(orgId,beginDate,endDate);
    }

    @Override
    public String getAllotMaxDate(String orgId) {
        return baseMapper.getAllotMaxDate(orgId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean syncInstore(String lastUpdateTime) {
        logger.info("同步NC入库单开始=====");
        //同步开始时间
        if(StringUtils.isEmpty(lastUpdateTime)){
            //当前日期减一天作为同步时间
            lastUpdateTime = DateUtil.format(DateUtils.addDays(new Date(),-1),"yyyy-MM-dd");
        }
        //组织信息查询
        Long tenantId = InvocationInfoProxy.getTenantid();//租户id
        List<Integer> typeList = new ArrayList<>();
        typeList.add(1);//集团
        typeList.add(2);//分公司
        CommonResponse<List<OrgVO>> listCommonResponse = orgApi.findOrgByType(tenantId,typeList,"");//租户id查询根节点
        if(!listCommonResponse.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<OrgVO> orgVOList = listCommonResponse.getData();
        if(orgVOList!=null&&orgVOList.size()>0){
            for(OrgVO orgVO:orgVOList){
                String url1 = syncAddr + "/grn/list?ts=" + lastUpdateTime+"&pk_corp="+orgVO.getSourceId();
                String strResult = HttpClientUtils.getInstance().getSync(url1);
                logger.info(strResult);
                if(StringUtils.isEmpty(strResult)){
                    return false;
                }
                //测试数据
                /*String strResult = "{'body':[" +
                        "{'cgeneralbid':'1234123','pkOrg':'1234123','cgeneralhid':'1234123','vbillcode':'12341','pkMaterial':'12341','ninnum':'1','nprice':'1','ntaxprice':'1','nmny':'1','ntaxmny':'1','pkProject':'1234123','cwhsmanagerid':'1234123','dbizdate':'1234','pkSupplier':'12234'}," +
                        "{'cgeneralbid':'1234123','pkOrg':'1234123','cgeneralhid':'1234123','vbillcode':'12341','pkMaterial':'12341','ninnum':'1','nprice':'1','ntaxprice':'1','nmny':'1','ntaxmny':'1','pkProject':'1234123','cwhsmanagerid':'1234123','dbizdate':'1234','pkSupplier':'12234'}," +
                        "{'cgeneralbid':'1234123','pkOrg':'1234123','cgeneralhid':'1234123','vbillcode':'12341','pkMaterial':'12341','ninnum':'1','nprice':'1','ntaxprice':'1','nmny':'1','ntaxmny':'1','pkProject':'1234123','cwhsmanagerid':'1234123','dbizdate':'1234','pkSupplier':'12234'}" +
                        "]}";*/
                JSONArray jsonArray = (JSONArray) JSONObject.parseObject(strResult).get("body");
                List<InstoreEntity> syncList = null;
                if(jsonArray != null && jsonArray.size() > 0){
                    syncList = jsonArray.toJavaList(InstoreEntity.class);
                }
                if (syncList == null || syncList.size() <= 0) {
//                    updateLastTs(SyncTypeEnum.Instore.getValue());
                    logger.info(orgVO.getId()+orgVO.getName()+"本次同步入库单个数为0，同步结束");
//                    return true;
                }else {
                    //遍历数据替换组织信息
                    for(InstoreEntity instoreEntity :syncList){
                        instoreEntity.setPkOrg(String.valueOf(orgVO.getId()));
                    }
                    //插入或者更新
                    boolean flag = syncInstoreService.saveOrUpdateBatch(syncList);
                    logger.info(orgVO.getId() + orgVO.getName() + "本次同步入库单个数为" + syncList.size() + "，数据同步结束，数据同步结果：" + (flag ? "成功" : "失败"));
                }
            }
        }
//        清空汇总表
        syncInstoreMapper.truncateInstoreHZ();
//        生成汇总表数据
        syncInstoreMapper.insertInstoreHZ();
        logger.info("同步NC入库单结束=====");
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateSyncInstore() {
        logger.info("更新同步NC入库单开始=====");
        //入库单插入成功后调用项目接口、材料接口、组织接口更新汇总信息
        //查询汇总数据
        QueryParam queryParam = new QueryParam();
        List<InstoreHzEntity> instoreHzEntityList = instoreHzService.queryList(queryParam);
        for(InstoreHzEntity instoreHzEntity : instoreHzEntityList){
            instoreHzEntity.setTenantId(999999L);
            instoreHzEntity.setCreateTime(new Date());
            String orgId = instoreHzEntity.getPkOrg();
            String projectId = instoreHzEntity.getPkProject();
            String materialId = instoreHzEntity.getPkMaterial();
            //查询物料信息  根据sourceId查询物料id
            CommonResponse<MaterialVO> matRes = materialApi.queryMaterialBySourceId(materialId);
            if(matRes.isSuccess()) {
                MaterialVO materialVO = matRes.getData();
                instoreHzEntity.setCode(materialVO.getCode());
                instoreHzEntity.setName(materialVO.getName());
                instoreHzEntity.setTypeId(String.valueOf(materialVO.getCategoryId()));
                instoreHzEntity.setType(materialVO.getCategoryName());
                instoreHzEntity.setUnitName(materialVO.getUnitName());
                instoreHzEntity.setSpec(materialVO.getSpec());
                instoreHzEntity.setMeasname(materialVO.getCategoryName());
                instoreHzEntity.setPkMaterial(String.valueOf(materialVO.getId()));//更新物料主键
            }
            //查询组织信息
            CommonResponse<OrgVO> orgVOCommonResponse = orgApi.getOneById(Long.valueOf(orgId));
            if(orgVOCommonResponse.isSuccess()) {
                OrgVO orgVO = orgVOCommonResponse.getData();
                instoreHzEntity.setOrgName(orgVO.getName());
            }
            //查询项目信息
            if(!StringUtils.isEmpty(projectId)){
                CommonResponse<ProjectRegisterVO> res =  projectApi.queryProjectBySourceId(projectId);
                if(res.isSuccess()){
                    instoreHzEntity.setPkProject(String.valueOf(res.getData().getId()));
                    instoreHzEntity.setVprojectname(res.getData().getName());
                }
            }
        }
        if(CollectionUtils.isNotEmpty(instoreHzEntityList)){
            //更新汇总表数据
            instoreHzService.saveOrUpdateBatch(instoreHzEntityList);
        }
        logger.info("更新同步NC入库单结束=====");
        return true;
    }

    @Override
    public Integer closeOrderDate() {
        int hour = 0;
        //查询设置到期天数
        //在轻量化支撑中心的调度参数配置里面，搜索WARNING000044编码，发现设置的值是168小时
        //点击进入getWarningByCode方法，发现来自于ejc-task-web，于是查询数据库ejc-task的ejc-warning-setting表和ejc-warning-setting-parameter表，也可发现parameters值是168
        CommonResponse<WarningVO> warningVOCommonResponse = warningApi.getWarningByCode("WARNING000044");
        if(warningVOCommonResponse.getCode() == 0 && null != warningVOCommonResponse.getData() && org.apache.commons.collections.CollectionUtils.isNotEmpty( warningVOCommonResponse.getData().getWarningParameterList())){
            Map<String, WarningParameterVO> warningParameterVOMap = warningVOCommonResponse.getData().getWarningParameterList().stream().collect(Collectors.toMap(x->x.getParameterName(), Function.identity(),(k1, k2) ->k2));
            if(warningParameterVOMap.containsKey("parameters")){
                WarningParameterVO warningParameterVO = warningParameterVOMap.get("parameters");
                hour = Integer.parseInt(warningParameterVO.getParameterValue() == null ? "0" : warningParameterVO.getParameterValue());
            }
        }
        return hour;
    }

    @Override
    public ApplyVO pushOpApply(List<Long> ids) {
        List<OrderEntity> entities = (List<OrderEntity>) listByIds(ids);
        OrderEntity orderEntity = entities.get(0);
        Long projectId = orderEntity.getSellProject();

        ApplyVO applyVO = new ApplyVO();
        applyVO.setProjectId(projectId);
        applyVO.setOrgId(orderEntity.getSellOrg());
        applyVO.setOrgName(orderEntity.getSellOrgName());
        applyVO.setParentOrgId(orderEntity.getParentSellOrg());
        applyVO.setProjectName(orderEntity.getSellProjectName());
        applyVO.setOutDate(new Date());
        applyVO.setTel(orderEntity.getSellPhone());
        applyVO.setLinkUrlPc("http://wei.cscec5b.com.cn:9080/cscec5b-panhuo-frontend/#/sellOrder");
        applyVO.setLinkUrlMobile("https://wjqlh.17elian.com/cscec5b-panhuo-mobile/#/sellerManage");
        List<ApplyDetailVO> detailList = new ArrayList<>();
        List<String> result = new ArrayList<>();
        for(OrderEntity order : entities){
            if (!projectId.equals(order.getSellProject())) {
                throw new BusinessException("不同项目不允许同时生成出门证");
            }
            ApplyDetailVO detailVO = new ApplyDetailVO();
            detailVO.setCode(order.getMaterialCode());
            detailVO.setName(order.getMaterialName());
            detailVO.setSpec(order.getSpec());
            detailVO.setUnit(order.getUnit());
            detailVO.setNum(order.getNums());
            detailVO.setReason("资产盘活订单");
            detailList.add(detailVO);
            result.add(String.valueOf(order.getId()));
        }
        applyVO.setSourceId(StringUtils.join(result, "@"));
        applyVO.setSourceType("BT211111000000003");
        applyVO.setSourceTypeName("资产盘活订单");
        applyVO.setDetailList(detailList);
        CommonResponse<ApplyVO> response = applyApi.push(applyVO);
        if (response.isSuccess() && null != response.getData()) {
            return response.getData();
        }else {
            logger.error(JSONObject.toJSONString(response));
            throw new BusinessException(response.getMsg());
        }
    }
}
