package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.GoodsMapper;
import com.ejianc.business.panhuo.mapper.RecommendAnaMapper;
import com.ejianc.business.panhuo.service.*;
import com.ejianc.business.panhuo.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 资产表
 *
 * @author generator
 *
 */
@Service("recommendAnaService")
public class RecommendAnaServiceImpl extends BaseServiceImpl<RecommendAnaMapper, GoodsEntity> implements IRecommendAnaService{
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ILabeldetailService labeldetailService;

    @Autowired
    private ICollectService collectService;

    @Autowired
    private IProjectApi projectApi;

    @Override
    public ReportVO recommendAnaIndex(Long orgId, String startTime, String endTime) {
        List<Long> commonOrgIds = new ArrayList<>();
        if(null==orgId||orgId<=0){
            orgId = InvocationInfoProxy.getOrgId();
        }

        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        ReportVO resVO = new ReportVO();

        ReportVO pronumsVo = baseMapper.getPronums(InvocationInfoProxy.getTenantid(),commonOrgIds, startTime, endTime);
        if(null!=pronumsVo){
            resVO.setProNums(pronumsVo.getProNums()==null?BigDecimal.ZERO:pronumsVo.getProNums());
        }else{
            resVO.setProNums(BigDecimal.ZERO);
        }

        return goodsIndex(resVO, commonOrgIds, startTime, endTime);
    }

    public ReportVO goodsIndex(ReportVO resVO, List<Long> commonOrgIds, String startTime, String endTime) {
        ReportVO goodsNumsVo = baseMapper.getGoodsnums(InvocationInfoProxy.getTenantid(),commonOrgIds, startTime, endTime);
        if(null!=goodsNumsVo){
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount()==null?BigDecimal.ZERO:goodsNumsVo.getGoodsAmount());
            if(null!=goodsNumsVo.getShelfTime()){
                int days = (int) ((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / (1000*3600*24));
                resVO.setDays(days);
            }
        }else{
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }

        ReportVO goodsNumsIngVo = baseMapper.getGoodsnumsIng(InvocationInfoProxy.getTenantid(),commonOrgIds, startTime, endTime);
        if(null!=goodsNumsIngVo){
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums()==null?BigDecimal.ZERO:goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount()==null?BigDecimal.ZERO:goodsNumsIngVo.getShelfAmount());
        }else{
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }

        ReportVO OrdernumsVo = baseMapper.getOrdernums(InvocationInfoProxy.getTenantid(),commonOrgIds, startTime, endTime);
        if(null!=OrdernumsVo){
            resVO.setOrderNums(OrdernumsVo.getOrderNums()==null?BigDecimal.ZERO:OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount()==null?BigDecimal.ZERO:OrdernumsVo.getOrderAmount());
        }else{
            resVO.setOrderNums(OrdernumsVo.getOrderNums()==null?BigDecimal.ZERO:OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount()==null?BigDecimal.ZERO:OrdernumsVo.getOrderAmount());
        }
        return resVO;
    }

    @Override
    public List<ReportVO> recommendAnaProj(Page<ReportVO> page, QueryWrapper queryWrapper, String startTime, String endTime) {

        List<ReportVO> res = new ArrayList<>();
        List<ReportVO> projIndexs = baseMapper.getProjProdNums(page, queryWrapper, startTime, endTime);
        if(CollectionUtils.isNotEmpty(projIndexs)){
            projIndexs.forEach(e -> {
                List<Long> commonOrgIds = new ArrayList<>();
                commonOrgIds.add(e.getBuyOrg());
                ReportVO vo = goodsIndex(e, commonOrgIds, startTime, endTime);
                res.add(vo);
            });
        }
        return res;
    }

}
