package com.ejianc.business.panhuo.service.impl;

import com.ejianc.business.panhuo.bean.ImgdetailEntity;
import com.ejianc.business.panhuo.bean.ShelfBatchDetailEntity;
import com.ejianc.business.panhuo.bean.ShelfBatchEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IImgdetailService;
import com.ejianc.business.panhuo.service.IShelfBatchService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ImgdetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("shelfBatch")
public class ShelfBatchBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IGoodsService goodsService;

	@Autowired
	private IShelfBatchService shelfBatchService;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private IImgdetailService imgdetailService;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${common.env.base-host}")
	private String baseHost;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ShelfBatchEntity shelfBatchEntity = shelfBatchService.selectById(billId);
		for (ShelfBatchDetailEntity shelfBatchDetailEntity : shelfBatchEntity.getShelfBatchDetailList()){
			GoodsVO vo = new GoodsVO();
			vo.setParentOrgId(shelfBatchEntity.getParentOrgId());
			vo.setParentOrgSourceId(shelfBatchEntity.getParentOrgSourceId());
			vo.setOrgId(shelfBatchEntity.getOrgId());
			vo.setOrgName(shelfBatchEntity.getOrgName());
			vo.setProjectId(shelfBatchEntity.getProjectId());
			vo.setProjectName(shelfBatchEntity.getProjectName());
			vo.setName(shelfBatchEntity.getName());
			vo.setPhone(shelfBatchEntity.getPhone());
			vo.setAddressName(shelfBatchEntity.getAddressName());
			vo.setAddress(shelfBatchEntity.getAddress());
			vo.setProjectAddress(shelfBatchEntity.getProjectAddress());
			vo.setSpec(shelfBatchDetailEntity.getSpec());
			vo.setOriginalprice(shelfBatchDetailEntity.getPrice());
			vo.setDiscount(shelfBatchDetailEntity.getDiscount());
			vo.setPrice(shelfBatchDetailEntity.getShelfPrice());
			vo.setRotatableNums(shelfBatchDetailEntity.getRotatableNums());
			vo.setTax(shelfBatchDetailEntity.getTax());
			vo.setTaxMny(shelfBatchDetailEntity.getTaxMny());
			vo.setShelfMny(shelfBatchDetailEntity.getShelfMny());
			vo.setDetails(shelfBatchDetailEntity.getDetails());
			vo.setShelfType(shelfBatchDetailEntity.getShelfType());
			vo.setIsPack(shelfBatchDetailEntity.getIsPack());
			vo.setPreSaleFlag(shelfBatchDetailEntity.getPreSaleFlag());
			vo.setPreSaleDate(shelfBatchDetailEntity.getPreSaleDate());
			vo.setUnit(shelfBatchDetailEntity.getUnit());
			vo.setAddressId(shelfBatchEntity.getAddressId());
			vo.setSeller(shelfBatchEntity.getSeller());
			vo.setSellerName(shelfBatchEntity.getSellerName());
			if (shelfBatchDetailEntity.getLabelName() != null){
				String[] labelName = null;
				List<String> list=new ArrayList<String>();
				labelName = shelfBatchDetailEntity.getLabelName().split(",");
				for (int i=0; i< labelName.length; i++){
					if (labelName[i].equals("0")){
						list.add("{\"uitype\":\"EJCTagItem\",\"uititle\":\"急售\",\"text\":\"急售\",\"value\":\"1\",\"colour\":\"#EC6C6C\",\"labelId\":\"1\",\"name\":\"急售\",\"type\":0}");
					}else if (labelName[i].equals("1")){
						list.add("{\"uitype\":\"EJCTagItem\",\"uititle\":\"全新\",\"text\":\"全新\",\"value\":\"2\",\"colour\":\"#9752E8\",\"labelId\":\"2\",\"name\":\"全新\",\"type\":0}");
					}else if (labelName[i].equals("2")){
						list.add("{\"uitype\":\"EJCTagItem\",\"uititle\":\"量大\",\"text\":\"量大\",\"value\":\"3\",\"colour\":\"#2D4EF5\",\"labelId\":\"3\",\"name\":\"量大\",\"type\":0}");
					}else if (labelName[i].equals("3")){
						list.add("{\"uitype\":\"EJCTagItem\",\"uititle\":\"八成新\",\"text\":\"八成新\",\"value\":\"4\",\"colour\":\"#69BD8F\",\"labelId\":\"4\",\"name\":\"八成新\",\"type\":0}");
					}else if (labelName[i].equals("4")){
						list.add("{\"uitype\":\"EJCTagItem\",\"uititle\":\"包送货\",\"text\":\"包送货\",\"value\":\"5\",\"colour\":\"#F2AF45\",\"labelId\":\"5\",\"name\":\"包送货\",\"type\":0}");
					}
				}
				vo.setLabelName(String.valueOf(list));
			}
			vo.setMaterialId(shelfBatchDetailEntity.getMaterialId());
			vo.setMaterialName(shelfBatchDetailEntity.getMaterialName());
			vo.setMaterialTypeId(shelfBatchDetailEntity.getMaterialTypeId());
			vo.setMaterialTypeName(shelfBatchDetailEntity.getMaterialTypeName());
			vo.setMaterialCode(shelfBatchDetailEntity.getMaterialCode());
			vo.setIsBatch(shelfBatchDetailEntity.getIsBatch());
			vo.setOnShelfType(BooleanUtils.isTrue(shelfBatchDetailEntity.getPreSaleFlag()) ? 1 : 0);
			vo.setSourceType(0);
			vo.setStatus(0);
			vo.setBillState(1);
			vo.setBillCode(null);
			vo.setId(null);
			GoodsVO goodsVO =  goodsService.saveGoods(vo);
			List imgsPath = new ArrayList();
			String[] imgsPathArray = null;
			if (shelfBatchDetailEntity.getFileIds() != null){
				imgsPathArray = shelfBatchDetailEntity.getFileIds().split(",");
				CommonResponse<AttachmentVO> attachmentVOCommonResponse1 = attachmentApi.queryDetail(imgsPathArray[0]);
				if (baseHost.contains("9080")){ // 正式
					goodsVO.setMainimgPath("http://wei.cscec5b.com.cn:9080/"+attachmentVOCommonResponse1.getData().getFilePath());
				}else if (baseHost.contains("9082")){ // 测试
					goodsVO.setMainimgPath("http://wei.cscec5b.com.cn:9082/"+attachmentVOCommonResponse1.getData().getFilePath());
				}else { // dev
					goodsVO.setMainimgPath("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/"+attachmentVOCommonResponse1.getData().getFilePath()+"?x-oss-process=image/resize,m_fixed,h_120,w_120");
				}
				for (int i=0; i< imgsPathArray.length; i++){
					CommonResponse<AttachmentVO> attachmentVOCommonResponse = attachmentApi.queryDetail(imgsPathArray[i]);
					ImgdetailVO imgdetailVO = new ImgdetailVO();
					imgdetailVO.setSourceId(goodsVO.getId());
					imgdetailVO.setType(0);
					if (baseHost.contains("9080")){ // 正式
						String[] filePath = attachmentVOCommonResponse.getData().getFilePath().split("\\.");
						String filePathString = filePath[0]+"_120x120."+filePath[1];
						imgdetailVO.setPath("http://wei.cscec5b.com.cn:9080/"+attachmentVOCommonResponse.getData().getFilePath());
						imgdetailVO.setThumpath("http://wei.cscec5b.com.cn:9080/"+filePathString);
					}else if (baseHost.contains("9082")){  // 测试
						String[] filePath = attachmentVOCommonResponse.getData().getFilePath().split("\\.");
						String filePathString = filePath[0]+"_120x120."+filePath[1];
						imgdetailVO.setPath("http://wei.cscec5b.com.cn:9082/"+attachmentVOCommonResponse.getData().getFilePath());
						imgdetailVO.setThumpath("http://wei.cscec5b.com.cn:9082/"+filePathString);
					}else {  // dev
						imgdetailVO.setPath("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/"+attachmentVOCommonResponse.getData().getFilePath());
						imgdetailVO.setThumpath("https://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/"+attachmentVOCommonResponse.getData().getFilePath()+"?x-oss-process=image/resize,m_fixed,h_120,w_120");
					}
					ImgdetailEntity imgdetailEntity = BeanMapper.map(imgdetailVO, ImgdetailEntity.class);
					imgdetailService.saveOrUpdate(imgdetailEntity);
					AttachmentVO attachmentVO = new AttachmentVO();
					attachmentVO.setSourceId(goodsVO.getId());
					attachmentVO.setSourceType("imgUpload");
					attachmentVO.setBillType("BT211111000000004");
					attachmentVO.setFileName(attachmentVOCommonResponse.getData().getFileName());
					attachmentVO.setFilePath(attachmentVOCommonResponse.getData().getFilePath());
					attachmentVO.setFileSize(attachmentVOCommonResponse.getData().getFileSize());
					List<AttachmentVO> attachmentVOS = new ArrayList<>();
					attachmentVOS.add(attachmentVO);
					attachmentApi.insertBatch(attachmentVOS);
				}
			}
			goodsService.saveGoods(goodsVO);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
