package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.ShoppingCartEntity;
import com.ejianc.business.panhuo.mapper.ShoppingCartMapper;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IShoppingCartService;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 购物车
 *
 * @author generator
 *
 */
@Service("shoppingCartService")
public class ShoppingCartServiceImpl extends BaseServiceImpl<ShoppingCartMapper, ShoppingCartEntity> implements IShoppingCartService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "CSCEC5B_PANHUO_DD";

    @Autowired
    private IConfigService configService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoodsService goodsService;

    @Override
    public ShoppingCartVO saveShoppingCart(ShoppingCartVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = goodsService.selectById(vo.getGoodsId());
        if (!goodsEntity.getVersion().equals(vo.getVersion())) {
            throw new BusinessException("您操作的页面已被其他同事修改,请刷新页面后重试!");
        }

        LambdaQueryWrapper<ShoppingCartEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ShoppingCartEntity::getUserId, InvocationInfoProxy.getUserid());
        queryWrapper.eq(ShoppingCartEntity::getBuyOrg, vo.getBuyOrg());
        queryWrapper.eq(ShoppingCartEntity::getGoodsId, vo.getGoodsId());
        List<ShoppingCartEntity> list = list(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该商品已添加过购物车，不能重复添加!");
        }

        ShoppingCartEntity cartEntity = BeanMapper.map(vo,ShoppingCartEntity.class);
        cartEntity.setToolId(goodsEntity.getToolId());
        cartEntity.setShelfType(goodsEntity.getShelfType());
        cartEntity.setShelfTime(goodsEntity.getShelfTime());
        cartEntity.setTenantId(tenantId);
        cartEntity.setMaterialCode(goodsEntity.getMaterialCode());
        cartEntity.setMaterialId(goodsEntity.getMaterialId());
        cartEntity.setMaterialName(goodsEntity.getMaterialName());
        cartEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        cartEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        cartEntity.setSystemId(goodsEntity.getSystemId());
        cartEntity.setSourceId(goodsEntity.getSourceId());
        cartEntity.setSpec(goodsEntity.getSpec());
        cartEntity.setMainimgPath(goodsEntity.getMainimgPath());
        cartEntity.setUnit(goodsEntity.getUnit());
        cartEntity.setType(0);//待确认
        cartEntity.setIsPack(goodsEntity.getIsPack());
        cartEntity.setSeller(goodsEntity.getSeller());
        cartEntity.setSellerName(goodsEntity.getSellerName());
        cartEntity.setSellAddress(goodsEntity.getAddress());
        cartEntity.setSellAddressId(goodsEntity.getAddressId());
        cartEntity.setSellOrg(goodsEntity.getOrgId());
        cartEntity.setSellOrgName(goodsEntity.getOrgName());
        cartEntity.setSellProject(goodsEntity.getProjectId());
        cartEntity.setSellProjectName(goodsEntity.getProjectName());
        cartEntity.setSellPhone(goodsEntity.getPhone());
        cartEntity.setSellUserName(goodsEntity.getName());
        cartEntity.setBuyTime(DateFormater.getCurrentDate());
        cartEntity.setMny(vo.getOrdermny()==null?BigDecimal.ZERO:vo.getOrdermny());
        cartEntity.setPrice(vo.getOrderprice()==null?BigDecimal.ZERO:vo.getOrderprice());
        cartEntity.setNums(vo.getOrdernums()==null?BigDecimal.ZERO:vo.getOrdernums());
        cartEntity.setOriginalprice(goodsEntity.getOriginalprice());
        cartEntity.setDiscount(goodsEntity.getDiscount());
        cartEntity.setUserId(InvocationInfoProxy.getUserid());

        if(null != cartEntity.getSellOrg() && cartEntity.getSellOrg() > 0){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(cartEntity.getSellOrg());
            if(commonResponse.isSuccess()){
                OrgVO orgVO = commonResponse.getData();
                cartEntity.setParentSellOrg(orgVO.getParentId());
            }
        }

        if(null != cartEntity.getBuyOrg() && cartEntity.getBuyOrg() > 0){
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(cartEntity.getBuyOrg());
            if(commonResponse.isSuccess()){
                OrgVO orgVO = commonResponse.getData();
                cartEntity.setParentBuyOrg(orgVO.getParentId());
            }
        }

        String sellConfigOrgId = configService.queryConfigOrgByOrgId(cartEntity.getSellOrg());//调出项目组织信息
        if(StringUtils.isEmpty(sellConfigOrgId)){
            throw new BusinessException("出售方未设置调拨管理组织!");
        }

        //查询调入项目管理组织上级列表
        String buyConfigOrgId = configService.queryConfigOrgByOrgId(cartEntity.getBuyOrg());//调入项目组织信息
        if(StringUtils.isEmpty(buyConfigOrgId)){
            throw new BusinessException("购买方未设置调拨管理组织!");
        }
        if(!sellConfigOrgId.equals(buyConfigOrgId)){
            throw new BusinessException("调拨管理组织不匹配!");
        }

        if(null!=vo&&StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                cartEntity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(cartEntity, false);
        //TODO 加入购物车发消息
       /* List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        messageType.add("wjy");
        List<String> sender = new ArrayList<>();
        sender.add(goodsEntity.getSeller()+"");
        logger.info("发送信息给提交人:>----------" + sender);
        String formurl = baseHost+"cscec5b-panhuo-frontend/#/sellOrder/details?id="+orderEntity.getId()+"&type=1";
        String mobileUrl = wjyPath+"cscec5b-panhuo-mobile/#/sellerManage/card?id="+orderEntity.getId()+"&userid={userid}";
        String subject = "您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理";
        String content = "您上架的物资有一个新订单【"+orderEntity.getBillCode()+"】需要处理。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,mobileUrl);*/

        return BeanMapper.map(cartEntity, ShoppingCartVO.class);
    }
}
