package com.ejianc.business.panhuo.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 批量订单子实体
 *
 * @author generator
 *
 */
public class OrderBatchDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long batchId; // 批量订单id
    private Long goodsId; // 资产主键
    private String billCode; // 订单编号
    private Integer billState; // 单据状态（审批必须字段）
    private Long toolId; // 机具主键
    private Long materialId; // 物资主键
    private String materialName; // 物资名称
    private Long materialTypeId; // 物资类别末级
    private String materialTypeName; // 物资类别末级名称
    private String sourceId; // 物资来源ID
    private Long systemId; // 所属系统ID
    private String spec; // 规格型号
    private String mainimgPath; // 资产主图URL
    private Integer type; // 0-待确认，1-已完成，2-订单取消
    private Integer recommend; // 0-未推荐，1-智能推荐
    private String unit; // 单位
    private BigDecimal orderprice; // 单价
    private BigDecimal ordernums; // 数量
    private BigDecimal ordermny; // 下单金额
    private BigDecimal price; // 成交单价
    private BigDecimal originalprice; // 原价
    private BigDecimal discount; // 折扣
    private BigDecimal nums; // 成交数量
    private BigDecimal mny; // 成交金额
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date buyTime; // 购买时间
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date dealrTime; // 成交时间
    private Long orderUserId; // 订购人
    private String orderUserName; // 订购人名称
    private Long confirmer; // 确认人
    private String confirmerName; // 确认人名称
    private Long seller; // 资产发布人
    private String sellerName; // 资产发布人名称
    private Long sellOrg; // 出售方组织主键
    private String sellOrgName; // 出售方组织名称
    private Long sellProject; // 出售方项目
    private String sellProjectName; // 出售方项目名称
    private Long sellAddressId; // 出售方地址主键
    private String sellAddress; // 出售方详细地址
    private String sellUserName; // 出售方联系人
    private String sellPhone; // 出售方联系电话
    private String buyer; // 购买方联系人
    private Long buyOrg; // 购买方组织主键
    private String buyOrgName; // 购买方组织名称
    private Long buyProject; // 购买方项目主键
    private String buyProjectName; // 购买方项目名称
    private Long buyAddressId; // 购买方地址主键
    private String buyAddress; // 购买方详细地址
    private String buyPhone; // 购买方电话
    private String isPack; // 0-是  1-否
    private String cancel; // 取消人
    private String cancelName; //
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date cancelTime; // 取消时间
    private Integer cancelType; // 取消类型，0=买家，1=卖家，2-超时
    private String confirmName; // 确认人名称
    private String materialCode; // 物资名称
    private String shelfType; // 资产类型
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date shelfTime; // 上架时间
    private String memo; // 备注
    private Long parentSellOrg; // 出售组织上级组织id
    private String parentSellOrgSource; // 出售组织上级组织来源id
    private Long parentBuyOrg; // 购买组织上级组织id
    private String parentBuyOrgSource; // 购买组织上级组织来源id
    private String orderSourceId; //
    private Integer flag; // 未生成调拨单标识

    private Boolean preSaleFlag;//是否预售
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private java.util.Date preSaleDate; // 预售日期
    private Integer onShelfType;//上架类型：0-正常上架 1-预售上架


    public Long getBatchId() {
        return batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }
    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getToolId() {
        return toolId;
    }

    public void setToolId(Long toolId) {
        this.toolId = toolId;
    }
    @ReferSerialTransfer(referCode="Material001")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSystemId() {
        return systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getMainimgPath() {
        return mainimgPath;
    }

    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 0-未推荐，1-智能推荐
     */
    public Integer getRecommend() {
        return recommend;
    }

    public void setRecommend(Integer recommend) {
        this.recommend = recommend;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getOrderprice() {
        return orderprice;
    }

    public void setOrderprice(BigDecimal orderprice) {
        this.orderprice = orderprice;
    }
    public BigDecimal getOrdernums() {
        return ordernums;
    }

    public void setOrdernums(BigDecimal ordernums) {
        this.ordernums = ordernums;
    }
    public BigDecimal getOrdermny() {
        return ordermny;
    }

    public void setOrdermny(BigDecimal ordermny) {
        this.ordermny = ordermny;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getOriginalprice() {
        return originalprice;
    }

    public void setOriginalprice(BigDecimal originalprice) {
        this.originalprice = originalprice;
    }
    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }
    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Date getBuyTime() {
        return buyTime;
    }

    public void setBuyTime(Date buyTime) {
        this.buyTime = buyTime;
    }
    public Date getDealrTime() {
        return dealrTime;
    }

    public void setDealrTime(Date dealrTime) {
        this.dealrTime = dealrTime;
    }
    public Long getOrderUserId() {
        return orderUserId;
    }

    public void setOrderUserId(Long orderUserId) {
        this.orderUserId = orderUserId;
    }
    public String getOrderUserName() {
        return orderUserName;
    }

    public void setOrderUserName(String orderUserName) {
        this.orderUserName = orderUserName;
    }
    public Long getConfirmer() {
        return confirmer;
    }

    public void setConfirmer(Long confirmer) {
        this.confirmer = confirmer;
    }
    public String getConfirmerName() {
        return confirmerName;
    }

    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }
    public Long getSeller() {
        return seller;
    }

    public void setSeller(Long seller) {
        this.seller = seller;
    }
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    public Long getSellOrg() {
        return sellOrg;
    }

    public void setSellOrg(Long sellOrg) {
        this.sellOrg = sellOrg;
    }
    public String getSellOrgName() {
        return sellOrgName;
    }

    public void setSellOrgName(String sellOrgName) {
        this.sellOrgName = sellOrgName;
    }
    public Long getSellProject() {
        return sellProject;
    }

    public void setSellProject(Long sellProject) {
        this.sellProject = sellProject;
    }
    public String getSellProjectName() {
        return sellProjectName;
    }

    public void setSellProjectName(String sellProjectName) {
        this.sellProjectName = sellProjectName;
    }
    @ReferSerialTransfer(referCode="cscec5b-panhuo-addressRef")
    public Long getSellAddressId() {
        return sellAddressId;
    }
    @ReferDeserialTransfer
    public void setSellAddressId(Long sellAddressId) {
        this.sellAddressId = sellAddressId;
    }
    public String getSellAddress() {
        return sellAddress;
    }

    public void setSellAddress(String sellAddress) {
        this.sellAddress = sellAddress;
    }
    public String getSellUserName() {
        return sellUserName;
    }

    public void setSellUserName(String sellUserName) {
        this.sellUserName = sellUserName;
    }
    public String getSellPhone() {
        return sellPhone;
    }

    public void setSellPhone(String sellPhone) {
        this.sellPhone = sellPhone;
    }
    public String getBuyer() {
        return buyer;
    }

    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }
    public Long getBuyOrg() {
        return buyOrg;
    }

    public void setBuyOrg(Long buyOrg) {
        this.buyOrg = buyOrg;
    }
    public String getBuyOrgName() {
        return buyOrgName;
    }

    public void setBuyOrgName(String buyOrgName) {
        this.buyOrgName = buyOrgName;
    }
    public Long getBuyProject() {
        return buyProject;
    }

    public void setBuyProject(Long buyProject) {
        this.buyProject = buyProject;
    }
    public String getBuyProjectName() {
        return buyProjectName;
    }

    public void setBuyProjectName(String buyProjectName) {
        this.buyProjectName = buyProjectName;
    }
    @ReferSerialTransfer(referCode="cscec5b-panhuo-addressRef")
    public Long getBuyAddressId() {
        return buyAddressId;
    }
    @ReferDeserialTransfer
    public void setBuyAddressId(Long buyAddressId) {
        this.buyAddressId = buyAddressId;
    }
    public String getBuyAddress() {
        return buyAddress;
    }

    public void setBuyAddress(String buyAddress) {
        this.buyAddress = buyAddress;
    }
    public String getBuyPhone() {
        return buyPhone;
    }

    public void setBuyPhone(String buyPhone) {
        this.buyPhone = buyPhone;
    }
    public String getIsPack() {
        return isPack;
    }

    public void setIsPack(String isPack) {
        this.isPack = isPack;
    }
    public String getCancel() {
        return cancel;
    }

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }
    public String getCancelName() {
        return cancelName;
    }

    public void setCancelName(String cancelName) {
        this.cancelName = cancelName;
    }
    public Date getCancelTime() {
        return cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }
    public Integer getCancelType() {
        return cancelType;
    }

    public void setCancelType(Integer cancelType) {
        this.cancelType = cancelType;
    }
    public String getConfirmName() {
        return confirmName;
    }

    public void setConfirmName(String confirmName) {
        this.confirmName = confirmName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getShelfType() {
        return shelfType;
    }

    public void setShelfType(String shelfType) {
        this.shelfType = shelfType;
    }
    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentSellOrg() {
        return parentSellOrg;
    }

    public void setParentSellOrg(Long parentSellOrg) {
        this.parentSellOrg = parentSellOrg;
    }
    public String getParentSellOrgSource() {
        return parentSellOrgSource;
    }

    public void setParentSellOrgSource(String parentSellOrgSource) {
        this.parentSellOrgSource = parentSellOrgSource;
    }
    public Long getParentBuyOrg() {
        return parentBuyOrg;
    }

    public void setParentBuyOrg(Long parentBuyOrg) {
        this.parentBuyOrg = parentBuyOrg;
    }
    public String getParentBuyOrgSource() {
        return parentBuyOrgSource;
    }

    public void setParentBuyOrgSource(String parentBuyOrgSource) {
        this.parentBuyOrgSource = parentBuyOrgSource;
    }
    public String getOrderSourceId() {
        return orderSourceId;
    }

    public void setOrderSourceId(String orderSourceId) {
        this.orderSourceId = orderSourceId;
    }
    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public Boolean getPreSaleFlag() {
        return preSaleFlag;
    }

    public void setPreSaleFlag(Boolean preSaleFlag) {
        this.preSaleFlag = preSaleFlag;
    }

    public Date getPreSaleDate() {
        return preSaleDate;
    }

    public void setPreSaleDate(Date preSaleDate) {
        this.preSaleDate = preSaleDate;
    }

    public Integer getOnShelfType() {
        return onShelfType;
    }

    public void setOnShelfType(Integer onShelfType) {
        this.onShelfType = onShelfType;
    }
}
