package com.ejianc.business.panhuo.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 批量上架子实体
 *
 * @author generator
 *
 */
public class ShelfBatchDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long shelfId; // 主表主键
    private String createUserName; // 创建人名称
    private String billCode; // 资产编号
    private String billName; // 资产名称
    private String spec; // 规格型号
    private String unit; // 单位
    private BigDecimal price; // 采购单价
    private BigDecimal discount; // 折扣
    private BigDecimal shelfPrice; // 上架单价
    private BigDecimal rotatableNums; // 可周转数量(上架-已成交-预定中)
    private BigDecimal shelfMny; // 上架总金额
    private String isPack; // 是否打包出售 0-是  1-否
    private String mainimgPath; // 资产主图URL
    private String labelName; // 标签名称
    private String details; // 资产详情
    private Boolean preSaleFlag;//是否预售
    @TableField(value="tax")
    private java.math.BigDecimal tax; // 增值税税率
    @TableField(value="tax_mny")
    private java.math.BigDecimal taxMny; // 增值税税额
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date preSaleDate; // 预售日期
    private Integer onShelfType; // 上架类型：0-正常上架 1-预售上架
    private String shelfType; // 资产类型
    private java.lang.Long materialId; // 物资主键
    private java.lang.String materialCode; // 物资编号
    private java.lang.String materialName; // 物资名称
    private java.lang.Long materialTypeId; // 物资类别
    private java.lang.String materialTypeName; // 物资类别名称
    private String isBatch; // 是否批量上架 0-是  1-否
    private String fileIds; //图片主键集合

    // 标签子表
    private List<LabeldetailVO> labels = new ArrayList<>();

    // 图片子表
    private List<ImgdetailVO> imgsPath = new ArrayList<>();

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }
    public BigDecimal getShelfPrice() {
        return shelfPrice;
    }

    public void setShelfPrice(BigDecimal shelfPrice) {
        this.shelfPrice = shelfPrice;
    }
    public BigDecimal getRotatableNums() {
        return rotatableNums;
    }


    /**
     * 增值税税率
     */
    public void setTax(BigDecimal tax) {this.tax = tax;}
    public BigDecimal getTax() {return tax;}

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setRotatableNums(BigDecimal rotatableNums) {
        this.rotatableNums = rotatableNums;
    }
    public BigDecimal getShelfMny() {
        return shelfMny;
    }

    public void setShelfMny(BigDecimal shelfMny) {
        this.shelfMny = shelfMny;
    }

    public String getIsPack() {
        return isPack;
    }

    public void setIsPack(String isPack) {
        this.isPack = isPack;
    }

    public String getMainimgPath() {
        return mainimgPath;
    }

    public void setMainimgPath(String mainimgPath) {
        this.mainimgPath = mainimgPath;
    }
    public String getLabelName() {
        return labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }
    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public Boolean getPreSaleFlag() {
        return preSaleFlag;
    }

    public void setPreSaleFlag(Boolean preSaleFlag) {
        this.preSaleFlag = preSaleFlag;
    }

    public Date getPreSaleDate() {
        return preSaleDate;
    }

    public void setPreSaleDate(Date preSaleDate) {
        this.preSaleDate = preSaleDate;
    }
    public Integer getOnShelfType() {
        return onShelfType;
    }

    public void setOnShelfType(Integer onShelfType) {
        this.onShelfType = onShelfType;
    }

    public Long getShelfId() {
        return shelfId;
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public String getShelfType() {
        return shelfType;
    }

    public void setShelfType(String shelfType) {
        this.shelfType = shelfType;
    }

    public List<LabeldetailVO> getLabels() {
        return labels;
    }

    public void setLabels(List<LabeldetailVO> labels) {
        this.labels = labels;
    }

    public List<ImgdetailVO> getImgsPath() {
        return imgsPath;
    }

    public void setImgsPath(List<ImgdetailVO> imgsPath) {
        this.imgsPath = imgsPath;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getIsBatch() {
        return isBatch;
    }

    public void setIsBatch(String isBatch) {
        this.isBatch = isBatch;
    }

    public String getFileIds() {
        return fileIds;
    }

    public void setFileIds(String fileIds) {
        this.fileIds = fileIds;
    }
}
