/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AllotDetailEntity;
import com.ejianc.business.panhuo.service.IAllotDetailService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.AllotDetailVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"allotDetail"})
public class AllotDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAllotDetailService service;
    @Autowired
    private IOrderService orderService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllotDetailVO> saveOrUpdate(@RequestBody AllotDetailVO saveorUpdateVO) {
        AllotDetailEntity entity = (AllotDetailEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, AllotDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        AllotDetailVO vo = (AllotDetailVO)BeanMapper.map((Object)((Object)entity), AllotDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AllotDetailVO> queryDetail(Long id) {
        AllotDetailEntity entity = (AllotDetailEntity)((Object)this.service.selectById(id));
        AllotDetailVO vo = (AllotDetailVO)BeanMapper.map((Object)((Object)entity), AllotDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List<OrderVO> result;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        this.setOrgParam(param);
        IPage page = this.orderService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        List orderIdList = null;
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            orderIdList = pageData.getRecords().stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(result = this.service.getAllotInfo(orderIdList))) {
            Map map = result.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity(), (key1, key2) -> key1));
            for (OrderVO orderVO : pageData.getRecords()) {
                if (!map.containsKey(orderVO.getId())) continue;
                OrderVO order = (OrderVO)map.get(orderVO.getId());
                orderVO.setAllotCode(order.getBillCode());
                orderVO.setAllotTime(order.getDealrTime());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void setOrgParam(QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                ComplexParam c1 = new ComplexParam();
                c1.setLogic("and");
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("sellOrg", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c2);
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("buyOrg", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);
            } else {
                param.getComplexParams().add(this.getPageQueryParamPC());
            }
        } else {
            param.getComplexParams().add(this.getPageQueryParamMobile());
        }
    }

    public ComplexParam getPageQueryParamPC() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("parentSellOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("parentBuyOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c3);
        return c1;
    }

    public ComplexParam getPageQueryParamMobile() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sellOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("buyOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<OrderVO>> iPageCommonResponse = this.queryList(param);
        List list = new ArrayList();
        if (iPageCommonResponse.getData() != null) {
            list = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("AllotDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAllotDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AllotDetailVO>> refAllotDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllotDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

