/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.OrderBatchEntity;
import com.ejianc.business.panhuo.service.IOrderBatchService;
import com.ejianc.business.panhuo.vo.OrderBatchVO;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"orderBatch"})
public class OrderBatchController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOrderBatchService orderBatchService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderBatchVO> saveOrUpdate(@RequestBody OrderBatchVO vo) {
        OrderBatchVO orderBatchVO = this.orderBatchService.saveOrderBatch(vo);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)orderBatchVO));
    }

    @RequestMapping(value={"/saveFromCart"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderBatchVO> saveFromCart(@RequestBody List<ShoppingCartVO> vos) {
        OrderBatchVO orderBatchVO = this.orderBatchService.saveFromCart(vos);
        return CommonResponse.success((String)"\u8d2d\u7269\u8f66\u63d0\u4ea4\u6210\u529f\uff01", (Object)((Object)orderBatchVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderBatchVO> queryDetail(Long id) {
        OrderBatchEntity entity = (OrderBatchEntity)((Object)this.orderBatchService.selectById(id));
        OrderBatchVO vo = (OrderBatchVO)((Object)BeanMapper.map((Object)((Object)entity), OrderBatchVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderBatchVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrderBatchVO orderBatchVO : vos) {
            }
        }
        this.orderBatchService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderBatchVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.orderBatchService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderBatchVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.orderBatchService.queryList(param);
        ArrayList<OrderBatchVO> vos = new ArrayList<OrderBatchVO>();
        for (OrderBatchEntity orderBatchEntity : list) {
            OrderBatchVO vo = (OrderBatchVO)((Object)BeanMapper.map((Object)((Object)orderBatchEntity), OrderBatchVO.class));
            switch (vo.getBillState()) {
                case 0: {
                    vo.setBillStateName("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    vo.setBillStateName("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    vo.setBillStateName("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    vo.setBillStateName("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                }
            }
            vos.add(vo);
        }
        HashMap<String, ArrayList<OrderBatchVO>> beans = new HashMap<String, ArrayList<OrderBatchVO>>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("OrderBatch-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOrderBatchData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderBatchVO>> refOrderBatchData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.orderBatchService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderBatchVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

