/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.InstoreHzEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IAddressService;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IInstoreHzService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.InstoreHzVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"order"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrderService service;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private IAllotService allotService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IInstoreHzService iInstoreHzService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IWarningApi warningApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@RequestBody OrderVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.service.saveOrder(saveorUpdateVO));
    }

    @RequestMapping(value={"/confirmerOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> confirmerOrder(@RequestBody OrderVO saveorUpdateVO) {
        this.service.confirmerOrder(saveorUpdateVO);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(Long id) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(id));
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(orderEntity.getGoodsId()));
        OrderVO vo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        vo.setRemainingNums(goodsEntity.getRemainingNums());
        vo.setRotatableNums(goodsEntity.getRotatableNums());
        vo.setOrdermny(OrderController.format(vo.getOrdermny().doubleValue()));
        vo.setMny(OrderController.format(vo.getMny().doubleValue()));
        Integer hour = 672;
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + hour + "----");
        if (null != vo && hour > 0) {
            try {
                String endDate = OrderController.reportGetDate(vo.getBuyTime(), "HOUR", hour);
                vo.setCountDown(endDate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryShelfDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryShelfDetail(Long id) {
        CommonResponse response;
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(id));
        GoodsEntity entity = (GoodsEntity)((Object)this.goodsService.selectById(orderEntity.getGoodsId()));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("status", new Parameter("eq", (Object)0));
        List listGoods = this.goodsService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods) && listGoods.size() > 0) {
            throw new BusinessException("\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u4e0a\u67b6\uff0c\u4e0d\u53ef\u91cd\u590d\u4e0a\u67b6");
        }
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam2.getParams().put("status", new Parameter("eq", (Object)1));
        queryParam2.getParams().put("lowerType", new Parameter("eq", (Object)1));
        List listGoods2 = this.goodsService.queryList(queryParam2, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods2) && listGoods2.size() > 0) {
            throw new BusinessException("\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u5b8c\u6210\uff0c\u4e0d\u53ef\u5468\u8f6c");
        }
        vo.setId(Long.valueOf(IdWorker.getId()));
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setPrice(null);
        vo.setDiscount(null);
        vo.setOriginalprice(orderEntity.getPrice());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRemainingNums(entity.getNums());
        vo.setRotatableNums(entity.getNums());
        vo.setType(1);
        vo.setOrderId(id);
        AddressEntity addressEntity = (AddressEntity)((Object)this.addressService.getById(orderEntity.getBuyAddressId()));
        if (addressEntity != null) {
            vo.setAddressId(addressEntity.getId());
            vo.setAddress(addressEntity.getAddress());
            vo.setAddressName(addressEntity.getProjectName());
            vo.setProjectAddress(addressEntity.getProjectAddress());
            vo.setPhone(addressEntity.getPhone());
            vo.setName(addressEntity.getName());
            vo.setLat(addressEntity.getLat());
            vo.setLon(addressEntity.getLon());
            vo.setFirstLocation(addressEntity.getFirstLocation());
            vo.setSecondLocation(addressEntity.getSecondLocation());
            vo.setThirdLocation(addressEntity.getThirdLocation());
            vo.setFourthLocation(addressEntity.getFourthLocation());
            vo.setLocation(addressEntity.getLocation());
            vo.setProjectId(addressEntity.getProjectId());
            vo.setProjectName(addressEntity.getProjectName());
            vo.setOrgId(addressEntity.getOrgId());
            vo.setOrgName(addressEntity.getOrgName());
        }
        if (!(response = this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211111000000004", "imgUpload", vo.getId().toString(), "BT211111000000004", "imgUpload")).isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkTurnover"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkTurnover(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam.getParams().put("status", new Parameter("eq", (Object)0));
        List listGoods = this.goodsService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods) && listGoods.size() > 0) {
            return CommonResponse.error((int)5001, (String)"\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u4e0a\u67b6\uff0c\u4e0d\u53ef\u91cd\u590d\u4e0a\u67b6\uff01");
        }
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam2.getParams().put("order_id", new Parameter("eq", (Object)id));
        queryParam2.getParams().put("status", new Parameter("eq", (Object)1));
        queryParam2.getParams().put("lowerType", new Parameter("eq", (Object)1));
        List listGoods2 = this.goodsService.queryList(queryParam2, false);
        if (CollectionUtils.isNotEmpty((Collection)listGoods2) && listGoods2.size() > 0) {
            return CommonResponse.error((int)5001, (String)"\u8be5\u673a\u5177\u5df2\u5468\u8f6c\u5b8c\u6210\uff0c\u4e0d\u53ef\u5468\u8f6c\uff01");
        }
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.getById(id));
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.getById(orderEntity.getGoodsId()));
        return CommonResponse.success((String)("\u6821\u9a8c\u6210\u529f\uff01;" + goodsEntity.getSourceType()));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        Parameter onShelfType = (Parameter)param.getParams().get("onShelfType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)0));
        if (onShelfType != null) {
            param.getParams().put("onShelfType", new Parameter("eq", onShelfType.getValue()));
        }
        Parameter isMyBrought = (Parameter)param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if (null != isMyBrought && isMyBrought.getValue().toString().contains("0") && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().remove("orderUserId");
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("0")) {
            param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("buyOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        Integer hour = 672;
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + hour + "----");
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords()) && hour > 0) {
            for (OrderVO orderVO : pageData.getRecords()) {
                try {
                    String endDate = OrderController.reportGetDate(orderVO.getBuyTime(), "HOUR", hour);
                    orderVO.setCountDown(endDate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)2));
        Parameter isMyBrought = (Parameter)param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if (null != isMyBrought && isMyBrought.getValue().toString().contains("0") && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().remove("orderUserId");
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("0")) {
            param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("buyOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyOrderFinish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMyOrderFinish(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        Parameter preSaleFlag = (Parameter)param.getParams().get("preSaleFlag");
        if (preSaleFlag != null) {
            param.getParams().put("preSaleFlag", new Parameter("eq", preSaleFlag.getValue()));
        }
        Parameter isMyBrought = (Parameter)param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if (null != isMyBrought && isMyBrought.getValue().toString().contains("0") && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().remove("orderUserId");
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("0")) {
            param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("buyOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellIng"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellIng(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)0));
        ArrayList<Long> billStateList = new ArrayList<Long>();
        billStateList.add(1L);
        billStateList.add(3L);
        Parameter onShelfType = (Parameter)param.getParams().get("onShelfType");
        if (onShelfType != null) {
            param.getParams().put("onShelfType", new Parameter("eq", onShelfType.getValue()));
        }
        param.getParams().put("billState", new Parameter("in", billStateList));
        Parameter isMySell = (Parameter)param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if (null != isMySell && isMySell.getValue().toString().contains("0") && isMySell.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMySell && isMySell.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMySell && isMySell.getValue().toString().contains("1")) {
            param.getParams().put("seller", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("sellOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        Integer hour = 672;
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + hour + "----");
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords()) && hour > 0) {
            for (OrderVO orderVO : pageData.getRecords()) {
                try {
                    String endDate = OrderController.reportGetDate(orderVO.getBuyTime(), "HOUR", hour);
                    orderVO.setCountDown(endDate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static String reportGetDate(Date d, String type, int number) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (type.equals("YEAR")) {
            calendar.add(1, number);
        }
        if (type.equals("MONTH")) {
            calendar.add(2, number);
        }
        if (type.equals("DAY")) {
            calendar.add(5, number);
        }
        if (type.equals("HOUR")) {
            calendar.add(11, number);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = df.format(calendar.getTime());
        return date;
    }

    @RequestMapping(value={"/queryMySellEnd"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellEnd(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)2));
        Parameter isMySell = (Parameter)param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if (null != isMySell && isMySell.getValue().toString().contains("0") && isMySell.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMySell && isMySell.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMySell && isMySell.getValue().toString().contains("1")) {
            param.getParams().put("seller", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        Parameter onShelfType = (Parameter)param.getParams().get("onShelfType");
        if (onShelfType != null) {
            param.getParams().put("onShelfType", new Parameter("eq", onShelfType.getValue()));
        }
        this.setOrgParam("sellOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMySellFinish"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryMySellFinish(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        Parameter preSaleFlag = (Parameter)param.getParams().get("preSaleFlag");
        if (preSaleFlag != null) {
            param.getParams().put("preSaleFlag", new Parameter("eq", preSaleFlag.getValue()));
        }
        Parameter isMySell = (Parameter)param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if (null != isMySell && isMySell.getValue().toString().contains("0") && isMySell.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMySell && isMySell.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMySell && isMySell.getValue().toString().contains("1")) {
            param.getParams().put("seller", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam("sellOrg", param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryOrderPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryOrderPage(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("type", new Parameter("eq", (Object)1));
        Parameter preSaleFlag = (Parameter)param.getParams().get("preSaleFlag");
        if (preSaleFlag != null) {
            param.getParams().put("preSaleFlag", new Parameter("eq", preSaleFlag.getValue()));
        }
        Parameter isMyBrought = (Parameter)param.getParams().get("isMyBrought");
        param.getParams().remove("isMyBrought");
        if (null != isMyBrought && isMyBrought.getValue().toString().contains("0") && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().remove("orderUserId");
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("0")) {
            param.getParams().put("orderUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMyBrought && isMyBrought.getValue().toString().contains("1")) {
            param.getParams().put("orderUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        Parameter isMySell = (Parameter)param.getParams().get("isMySell");
        param.getParams().remove("isMySell");
        if (null != isMySell && isMySell.getValue().toString().contains("0") && isMySell.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMySell && isMySell.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        } else if (null != isMySell && isMySell.getValue().toString().contains("1")) {
            param.getParams().put("seller", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
        }
        this.setOrgParam1(param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void setOrgParam1(QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                ComplexParam c1 = new ComplexParam();
                c1.setLogic("and");
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("sellOrg", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c2);
                ComplexParam c3 = new ComplexParam();
                c3.setLogic("or");
                c3.getParams().put("buyOrg", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
                c1.getComplexParams().add(c3);
                param.getComplexParams().add(c1);
            } else {
                param.getComplexParams().add(this.getPageQueryParamPC());
            }
        } else {
            param.getComplexParams().add(this.getPageQueryParamMobile());
        }
    }

    public ComplexParam getPageQueryParamPC() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("parentSellOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("parentBuyOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c3);
        return c1;
    }

    public ComplexParam getPageQueryParamMobile() {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("sellOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("buyOrg", new Parameter("in", childIds));
        c1.getComplexParams().add(c3);
        return c1;
    }

    @RequestMapping(value={"/updateBuyStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        if (entity.getType() == 1 && BooleanUtils.isTrue((Boolean)goodsEntity.getPreSaleFlag())) {
            goodsEntity.setSellNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getSellNums(), (BigDecimal)entity.getNums()));
            goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
            goodsEntity.setRemainingNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal)goodsEntity.getSellNums()));
            goodsEntity.setStatus(0);
        } else {
            goodsEntity.setPreNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getPreNums(), (BigDecimal)entity.getOrdernums()));
            goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(entity.getSeller() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + entity.getId() + "&type=3";
        String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/sellerManage/card?id=" + entity.getId() + "&userid={userid}";
        String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u4e70\u5bb6\u53d6\u6d88";
        String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u4e70\u5bb6\u53d6\u6d88\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.service.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(this.sessionManager.getUserContext().getUserName());
        entity.setCancelType(0);
        entity.setCancelTime(DateFormater.getCurrentDate());
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> cancle(@RequestBody OrderVO saveorUpdateVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AllotEntity::getOrderId, (Object)saveorUpdateVO.getId());
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        List list = this.allotService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u8ba2\u5355\u5df2\u751f\u6210\u8c03\u62e8\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\uff01");
        }
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        if (entity.getType() == 1 && BooleanUtils.isTrue((Boolean)goodsEntity.getPreSaleFlag())) {
            goodsEntity.setSellNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getSellNums(), (BigDecimal)entity.getNums()));
            goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
            goodsEntity.setRemainingNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal)goodsEntity.getSellNums()));
            goodsEntity.setStatus(0);
        } else {
            goodsEntity.setPreNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getPreNums(), (BigDecimal)entity.getOrdernums()));
            goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
            goodsEntity.setStatus(0);
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(entity.getOrderUserId() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u9884\u5b9a\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + entity.getId() + "&type=3";
        String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + entity.getId() + "&userid={userid}";
        String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u7ba1\u7406\u5458\u53d6\u6d88";
        String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u7ba1\u7406\u5458\u53d6\u6d88\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.service.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(this.sessionManager.getUserContext().getUserName());
        entity.setCancelType(3);
        entity.setCancelTime(DateFormater.getCurrentDate());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/updateSellStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateSellStatus(@RequestBody OrderVO saveorUpdateVO) {
        OrderEntity entity = (OrderEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        if (entity.getVersion() != saveorUpdateVO.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(entity.getGoodsId()));
        if (entity.getType() == 1 && BooleanUtils.isTrue((Boolean)goodsEntity.getPreSaleFlag())) {
            goodsEntity.setSellNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getSellNums(), (BigDecimal)entity.getNums()));
            goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
            goodsEntity.setRemainingNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal)goodsEntity.getSellNums()));
            goodsEntity.setStatus(0);
        } else {
            goodsEntity.setPreNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getPreNums(), (BigDecimal)entity.getOrdernums()));
            goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(entity.getOrderUserId() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u9884\u5b9a\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + entity.getId() + "&type=3";
        String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + entity.getId() + "&userid={userid}";
        String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u5356\u5bb6\u53d6\u6d88";
        String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5df2\u88ab\u5356\u5bb6\u53d6\u6d88\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.service.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        entity.setType(2);
        entity.setCancel(String.valueOf(InvocationInfoProxy.getUserid()));
        entity.setCancelName(this.sessionManager.getUserContext().getUserName());
        entity.setCancelType(1);
        entity.setCancelTime(DateFormater.getCurrentDate());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/closeOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse closeOrder(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        Integer hour = 360;
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + hour + "----");
        if (hour > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, calendar.get(11) - hour);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.le(OrderEntity::getBuyTime, (Object)df.format(calendar.getTime()));
            lambdachange.eq(OrderEntity::getType, (Object)0);
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.logger.info("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                HashMap map = new HashMap();
                list.forEach(entity -> {
                    entity.setType(2);
                    entity.setCancel("99999");
                    entity.setCancelName("\u5230\u671f\u81ea\u52a8\u53d6\u6d88");
                    entity.setCancelType(2);
                    entity.setCancelTime(DateFormater.getCurrentDate());
                    GoodsEntity goodsEntity = (GoodsEntity)((Object)((Object)this.goodsService.selectById(entity.getGoodsId())));
                    BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                    BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                    goodsEntity.setPreNums(preNums.subtract(entity.getOrdernums()));
                    goodsEntity.setRotatableNums(rotatableNums.add(entity.getOrdernums()));
                    this.goodsService.updateById((Object)goodsEntity);
                    ArrayList<String> messageType = new ArrayList<String>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    ArrayList<String> sender = new ArrayList<String>();
                    sender.add(entity.getSeller() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender);
                    String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + entity.getId() + "&type=3";
                    String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/sellerManage/card?id=" + entity.getId() + "&userid={userid}";
                    String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5230\u671f\u672a\u786e\u8ba4\uff0c\u5df2\u5931\u6548";
                    String content = "\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5230\u671f\u672a\u786e\u8ba4\uff0c\u5df2\u5931\u6548\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                    ArrayList<String> messageType2 = new ArrayList<String>();
                    messageType2.add("sys");
                    messageType.add("wjy");
                    ArrayList<String> sender2 = new ArrayList<String>();
                    sender2.add(entity.getOrderUserId() + "");
                    this.logger.info("\u9884\u8ba2\u4eba:>----------" + sender2);
                    String formurl2 = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + entity.getId();
                    String mobileUrl2 = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + entity.getId() + "&userid={userid}";
                    String subject2 = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5356\u5bb6\u672a\u53ca\u65f6\u786e\u8ba4\u5df2\u53d6\u6d88";
                    String content2 = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + entity.getBillCode() + "\u3011\u5356\u5bb6\u672a\u53ca\u65f6\u786e\u8ba4\u5df2\u53d6\u6d88\u3002<a href=" + '\"' + formurl2 + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType2, sender2, "notice", subject2, content2, mobileUrl2);
                });
                this.service.updateBatchById(list);
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String url) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4e94\u5c40\u8f7b\u91cf\u5316\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)url);
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @RequestMapping(value={"/syncInstore"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> syncInstore(HttpServletRequest request) {
        String lastUpdateTime = request.getParameter("lastUpdateTime");
        return CommonResponse.success((Object)this.service.syncInstore(lastUpdateTime));
    }

    @RequestMapping(value={"/updateSyncInstore"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> updateSyncInstore(HttpServletRequest request) {
        return CommonResponse.success((Object)this.service.updateSyncInstore());
    }

    @RequestMapping(value={"/instoreHzRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreHzVO>> instoreHzRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        CommonResponse res;
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            jsonObject = JSONObject.parseObject((String)condition);
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("code");
        queryParam.getFuzzyFields().add("name");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("create_time", "desc");
        String projectId = String.valueOf(jsonObject.get((Object)"pkProject"));
        String projectName = "";
        String orgName = "";
        if (!StringUtils.isEmpty((CharSequence)projectId)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(projectId));
            res = this.projectApi.queryProjectByIds(ids);
            if (!res.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)res.getData()))) {
                return CommonResponse.success((String)"\u9879\u76ee\u4e0d\u5b58\u5728!", null);
            }
        } else {
            return CommonResponse.success((String)"\u9879\u76ee\u4e0d\u5b58\u5728!", null);
        }
        queryParam.getParams().put("pkProject", new Parameter("eq", (Object)((ProjectRegisterVO)((List)res.getData()).get(0)).getSourceId()));
        projectName = ((ProjectRegisterVO)((List)res.getData()).get(0)).getName();
        orgName = ((ProjectRegisterVO)((List)res.getData()).get(0)).getOrgName();
        IPage pageData = this.iInstoreHzService.queryPage(queryParam, false);
        for (InstoreHzEntity instoreHzEntity : pageData.getRecords()) {
            instoreHzEntity.setPkProject(projectId);
            instoreHzEntity.setVprojectname(projectName);
            instoreHzEntity.setOrgName(orgName);
            CommonResponse matRes = this.materialApi.queryMaterialBySourceId(instoreHzEntity.getPkMaterial());
            if (!matRes.isSuccess()) continue;
            MaterialVO materialVO = (MaterialVO)matRes.getData();
            instoreHzEntity.setCode(materialVO.getCode());
            instoreHzEntity.setName(materialVO.getName());
            instoreHzEntity.setTypeId(String.valueOf(materialVO.getCategoryId()));
            instoreHzEntity.setType(materialVO.getCategoryName());
            instoreHzEntity.setUnitName(materialVO.getUnitName());
            instoreHzEntity.setSpec(materialVO.getSpec());
            instoreHzEntity.setMeasname(materialVO.getCategoryName());
            instoreHzEntity.setPkMaterial(String.valueOf(materialVO.getId()));
        }
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), InstoreHzVO.class));
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/instoreHzList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreHzVO>> instoreHzList(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=true) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        JSONObject jsonObject = new JSONObject();
        jsonObject = JSONObject.parseObject((String)condition);
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("pkMaterial");
        queryParam.getFuzzyFields().add("pkProject");
        queryParam.getFuzzyFields().add("pkOrg");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("pkOrg", new Parameter("eq", jsonObject.get((Object)"orgId")));
        queryParam.getOrderMap().put("create_time", "desc");
        IPage pageData = this.iInstoreHzService.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), InstoreHzVO.class));
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    private void setOrgParam(String key, QueryParam param) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (null != orgId && orgId > 0L) {
            param.getParams().put(key, new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            CommonResponse childOrgResp = this.orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(childIds)) {
                param.getParams().put(key, new Parameter("in", childIds));
            }
        }
    }

    public static BigDecimal format(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd;
    }

    @RequestMapping(value={"/preSellWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse preSellWarn(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570\u662f\uff1a" + day + "----");
        this.logger.debug("\u53c2\u6570----" + day);
        if (day > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(OrderEntity::getOnShelfType, (Object)1);
            lambdachange.eq(OrderEntity::getPreSaleFlag, (Object)true);
            lambdachange.le(OrderEntity::getPreSaleDate, (Object)df.format(calendar.getTime()));
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                String content;
                String subject;
                String mobileUrl;
                String formurl;
                ArrayList<String> sender;
                ArrayList<String> messageType;
                this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                ArrayList listUp = new ArrayList();
                ArrayList sellerList = new ArrayList();
                ArrayList buyerList = new ArrayList();
                list.forEach(entity -> {
                    this.logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u4e0b\u67b6----");
                    entity.setOnShelfType(0);
                    listUp.add(entity);
                    sellerList.add(entity);
                    buyerList.add(entity);
                });
                for (OrderEntity orderEntity : sellerList) {
                    messageType = new ArrayList<String>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    sender = new ArrayList<String>();
                    sender.add(orderEntity.getSeller() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                    formurl = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u552e\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\uff0c\u8bf7\u67e5\u770b";
                    content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u552e\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                for (OrderEntity orderEntity : buyerList) {
                    messageType = new ArrayList();
                    messageType.add("sys");
                    messageType.add("wjy");
                    sender = new ArrayList();
                    sender.add(orderEntity.getOrderUserId() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                    formurl = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u5b9a\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\uff0c\u8bf7\u67e5\u770b";
                    content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u5b9a\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                if (CollectionUtils.isNotEmpty(listUp)) {
                    this.service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/preSellWarnManual"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse preSellWarnManual(HttpServletRequest request) {
        String param = request.getParameter("param");
        int day = Integer.parseInt(param);
        this.logger.debug("\u53c2\u6570----" + day);
        if (day > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.logger.info("\u52a0\u4e0a\u53c2\u6570\u7684\u65f6\u95f4\uff1a" + df.format(calendar.getTime()));
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(OrderEntity::getOnShelfType, (Object)1);
            lambdachange.eq(OrderEntity::getPreSaleFlag, (Object)true);
            lambdachange.le(OrderEntity::getPreSaleDate, (Object)df.format(calendar.getTime()));
            List list = this.service.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                String content;
                String subject;
                String mobileUrl;
                String formurl;
                ArrayList<String> sender;
                ArrayList<String> messageType;
                this.logger.debug("\u5f00\u59cb\u5faa\u73af\u8bbe\u7f6e----" + list.size());
                ArrayList listUp = new ArrayList();
                ArrayList sellerList = new ArrayList();
                ArrayList buyerList = new ArrayList();
                list.forEach(entity -> {
                    this.logger.debug("\u5f00\u59cb\u8bbe\u7f6e\u4e0b\u67b6----");
                    entity.setOnShelfType(0);
                    listUp.add(entity);
                    sellerList.add(entity);
                    buyerList.add(entity);
                });
                for (OrderEntity orderEntity : sellerList) {
                    messageType = new ArrayList<String>();
                    messageType.add("sys");
                    messageType.add("wjy");
                    sender = new ArrayList<String>();
                    sender.add(orderEntity.getSeller() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                    formurl = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u552e\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\uff0c\u8bf7\u67e5\u770b";
                    content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u552e\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                for (OrderEntity orderEntity : buyerList) {
                    messageType = new ArrayList();
                    messageType.add("sys");
                    messageType.add("wjy");
                    sender = new ArrayList();
                    sender.add(orderEntity.getOrderUserId() + "");
                    this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                    formurl = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket/orderMarket?id=" + orderEntity.getId();
                    mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
                    subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u5b9a\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\uff0c\u8bf7\u67e5\u770b";
                    content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9884\u5b9a\u7684\u3010" + orderEntity.getMaterialName() + "\u3011\u8ba2\u5355\u5373\u5c06\u5230\u671f\u5b8c\u6210\u4ea4\u6613\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                }
                if (CollectionUtils.isNotEmpty(listUp)) {
                    this.service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success((String)"\u8fd0\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/pushOpApply"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> pushOpApply(@RequestBody List<Long> ids) {
        return CommonResponse.success((String)"\u751f\u6210\u51fa\u95e8\u8bc1\u6210\u529f,\u8bf7\u53ca\u65f6\u53bb\u51fa\u95e8\u8bc1\u5c0f\u7a0b\u5e8f\u6682\u5b58\u5217\u8868\u67e5\u770b\u63d0\u4ea4!", (Object)this.service.pushOpApply(ids));
    }
}

