/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.service.IRecommendAnaService;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"recommendAna"})
public class RecommendAnaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRecommendAnaService service;

    @RequestMapping(value={"/recommendAnaIndex"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReportVO> recommendAnaIndex(Long orgId, String startTime, String endTime) {
        ReportVO res = this.service.recommendAnaIndex(orgId, startTime, endTime);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/recommendAnaPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReportVO>> recommendAnaPage(Long orgId, String startTime, String endTime) {
        CommonResponse childrenOrg;
        ArrayList res = new ArrayList();
        if (null == orgId || orgId <= 0L) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)(childrenOrg = this.orgApi.getDirectChildrenByPid(orgId, null)).getData()))) {
            ((List)childrenOrg.getData()).forEach(e -> {
                ReportVO vo = this.service.recommendAnaIndex(e.getId(), startTime, endTime);
                vo.setOrgName(e.getName());
                vo.setOrgId(e.getId());
                res.add(vo);
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", res);
    }

    @RequestMapping(value={"/recommendAnaProj"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReportVO>> recommendAnaProj(Long orgId, String startTime, String endTime, String searchText, @RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("buyProjectName");
        param.setSearchText(searchText);
        CommonResponse orgVO = this.orgApi.getOneById(orgId);
        Integer orgType = ((OrgVO)orgVO.getData()).getOrgType();
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(orgType)) {
            param.getParams().put("buyOrg", new Parameter("eq", (Object)orgId));
        } else {
            param.getParams().put("parentBuyOrg", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ReportVO> res = this.service.recommendAnaProj((Page<ReportVO>)page, wrapper, startTime, endTime);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(res);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = null;
        String startTime = null;
        String endTime = null;
        param.setPageIndex(1);
        param.setPageSize(10000);
        if (param.getParams().get("orgId") != null && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
        }
        if (param.getParams().get("startTime") != null && ((Parameter)param.getParams().get("startTime")).getValue() != null) {
            startTime = ((Parameter)param.getParams().get("startTime")).getValue().toString();
        }
        if (param.getParams().get("endTime") != null && ((Parameter)param.getParams().get("endTime")).getValue() != null) {
            endTime = ((Parameter)param.getParams().get("endTime")).getValue().toString();
        }
        List listExport = (List)this.recommendAnaPage(orgId, startTime, endTime).getData();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("recommendCorp-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelProjExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelProjExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = null;
        String startTime = null;
        String endTime = null;
        if (param.getParams().get("orgId") != null && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
        }
        if (param.getParams().get("startTime") != null && ((Parameter)param.getParams().get("startTime")).getValue() != null) {
            startTime = ((Parameter)param.getParams().get("startTime")).getValue().toString();
        }
        if (param.getParams().get("endTime") != null && ((Parameter)param.getParams().get("endTime")).getValue() != null) {
            endTime = ((Parameter)param.getParams().get("endTime")).getValue().toString();
        }
        List listExport = ((IPage)this.recommendAnaProj(orgId, startTime, endTime, param.getSearchText(), 1, 10000).getData()).getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("recommendProj-export.xlsx", beans, response);
    }
}

