/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.ShelfBatchDetailEntity;
import com.ejianc.business.panhuo.bean.ShelfBatchEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IShelfBatchService;
import com.ejianc.business.panhuo.vo.ShelfBatchDetailVO;
import com.ejianc.business.panhuo.vo.ShelfBatchVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"shelfBatch"})
public class ShelfBatchController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi fileApi;
    private static final String BILL_CODE = "PLSJ_CODE";
    @Autowired
    private IShelfBatchService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IGoodsService goodsService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ShelfBatchVO> saveOrUpdate(@RequestBody ShelfBatchVO saveOrUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ShelfBatchEntity data = saveOrUpdateVO.getId() == null ? null : (ShelfBatchEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        BigDecimal shelfMny = BigDecimal.ZERO;
        BigDecimal nums = BigDecimal.ZERO;
        for (ShelfBatchDetailVO shelfBatchDetailVO : saveOrUpdateVO.getShelfBatchDetailList()) {
            if (shelfBatchDetailVO.getRowState() != null && !shelfBatchDetailVO.getRowState().equals("add") && !shelfBatchDetailVO.getRowState().equals("edit")) continue;
            if (shelfBatchDetailVO.getShelfMny() != null) {
                shelfMny = shelfBatchDetailVO.getShelfMny().add(shelfMny);
            }
            if (shelfBatchDetailVO.getRotatableNums() != null) {
                nums = shelfBatchDetailVO.getRotatableNums().add(nums);
            }
            shelfBatchDetailVO.setIsBatch("0");
            if (shelfBatchDetailVO.getLabelName() == null || shelfBatchDetailVO.getLabelName().length() <= 3) continue;
            return CommonResponse.error((String)"\u6700\u591a\u9009\u62e9\u4e24\u4e2a\u6807\u7b7e!");
        }
        saveOrUpdateVO.setShelfMny(shelfMny);
        saveOrUpdateVO.setNums(nums);
        ShelfBatchEntity entity = (ShelfBatchEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ShelfBatchEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<ShelfBatchDetailEntity> detailList = entity.getShelfBatchDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            ArrayList<String> fileIds = new ArrayList<String>();
            for (ShelfBatchDetailEntity detail : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)detail.getFileIds())) continue;
                fileIds.addAll(Arrays.asList(detail.getFileIds().split(",")));
            }
            if (CollectionUtils.isNotEmpty(fileIds)) {
                this.fileApi.updateAttachRef(entity.getId(), fileIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
            }
            if (data != null) {
                List<ShelfBatchDetailEntity> dataList = data.getShelfBatchDetailList();
                ArrayList<String> delIds = new ArrayList<String>();
                for (ShelfBatchDetailEntity detail : dataList) {
                    if (!StringUtils.isNotEmpty((CharSequence)detail.getFileIds())) continue;
                    delIds.addAll(Arrays.asList(detail.getFileIds().split(",")));
                }
                delIds.removeAll(fileIds);
                if (CollectionUtils.isNotEmpty(delIds)) {
                    this.fileApi.delete(delIds.stream().collect(Collectors.joining(",")));
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ShelfBatchVO vo = (ShelfBatchVO)((Object)BeanMapper.map((Object)((Object)entity), ShelfBatchVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ShelfBatchVO> queryDetail(Long id) {
        ShelfBatchEntity entity = (ShelfBatchEntity)((Object)this.service.selectById(id));
        ShelfBatchVO vo = (ShelfBatchVO)((Object)BeanMapper.map((Object)((Object)entity), ShelfBatchVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShelfBatchVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ShelfBatchVO shelfBatchVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ShelfBatchVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("addressName");
        fuzzyFields.add("nums");
        fuzzyFields.add("shelfMny");
        fuzzyFields.add("name");
        fuzzyFields.add("phone");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShelfBatchVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList<ShelfBatchVO> vos = new ArrayList<ShelfBatchVO>();
        for (ShelfBatchEntity entity : list) {
            ShelfBatchVO vo = (ShelfBatchVO)((Object)BeanMapper.map((Object)((Object)entity), ShelfBatchVO.class));
            if (vo.getBillState() != null) {
                if (vo.getBillState() == 0) {
                    vo.setBillStateName("\u81ea\u7531\u6001");
                }
                if (vo.getBillState() == 1) {
                    vo.setBillStateName("\u5df2\u63d0\u4ea4");
                }
                if (vo.getBillState() == 2) {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                }
                if (vo.getBillState() == 3) {
                    vo.setBillStateName("\u5df2\u901a\u8fc7");
                }
                if (vo.getBillState() == 4) {
                    vo.setBillStateName("\u5df2\u9a73\u56de");
                }
                if (vo.getBillState() == 5) {
                    vo.setBillStateName("\u5ba1\u6279\u4e2d");
                }
            }
            vos.add(vo);
        }
        HashMap<String, ArrayList<ShelfBatchVO>> beans = new HashMap<String, ArrayList<ShelfBatchVO>>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("ShelfBatch-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refShelfBatchData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ShelfBatchVO>> refShelfBatchData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShelfBatchVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPhone"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = ((EmployeeVO)this.employeeApi.getById(this.sessionManager.getUserContext().getEmployeeId()).getData()).getMobilePhone();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)mobilePhone);
    }
}

