/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.ShoppingCartEntity;
import com.ejianc.business.panhuo.service.IShoppingCartService;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"shoppingCart"})
public class ShoppingCartController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShoppingCartService service;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ShoppingCartVO> saveOrUpdate(@RequestBody ShoppingCartVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)((Object)this.service.saveShoppingCart(saveOrUpdateVO)));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ShoppingCartVO> queryDetail(Long id) {
        ShoppingCartEntity entity = (ShoppingCartEntity)((Object)this.service.selectById(id));
        ShoppingCartVO vo = (ShoppingCartVO)((Object)BeanMapper.map((Object)((Object)entity), ShoppingCartVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ShoppingCartVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ShoppingCartVO shoppingCartVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/clearDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> clearDelete() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ShoppingCartEntity::getUserId, (Object)InvocationInfoProxy.getUserid());
        this.service.remove((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u8d2d\u7269\u8f66\u5df2\u6e05\u7a7a\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<List<ShoppingCartVO>>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("userId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        List shoppingCartEntityList = this.service.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)shoppingCartEntityList)) {
            ArrayList<ShoppingCartVO> shoppingCartVOList = new ArrayList<ShoppingCartVO>();
            for (ShoppingCartEntity shoppingCartEntity : shoppingCartEntityList) {
                ShoppingCartVO shoppingCartVO = (ShoppingCartVO)((Object)BeanMapper.map((Object)((Object)shoppingCartEntity), ShoppingCartVO.class));
                shoppingCartVOList.add(shoppingCartVO);
            }
            ArrayList lists = new ArrayList();
            HashMap map = new HashMap();
            for (ShoppingCartVO shoppingCartVO : shoppingCartVOList) {
                List<ShoppingCartVO> list = null;
                list = map.containsKey(shoppingCartVO.getBuyOrg()) ? (List)map.get(shoppingCartVO.getBuyOrg()) : new ArrayList<ShoppingCartVO>();
                list.add(shoppingCartVO);
                map.put(shoppingCartVO.getBuyOrg(), list);
            }
            for (Map.Entry entry : map.entrySet()) {
                lists.add(entry.getValue());
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", lists);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/queryShoppingCart"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Integer> queryShoppingCart(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("sellProjectName");
        fuzzyFields.add("sellAddress");
        fuzzyFields.add("buyProjectName");
        fuzzyFields.add("buyAddress");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("userId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        List shoppingCartEntityList = this.service.queryList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)shoppingCartEntityList.size());
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ShoppingCart-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refShoppingCartData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ShoppingCartVO>> refShoppingCartData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ShoppingCartVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

