/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.AddressEntity;
import com.ejianc.business.panhuo.bean.CategoryEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.service.IAddressService;
import com.ejianc.business.panhuo.service.ICategoryService;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"warn"})
public class WarnController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IWbuyService wbuyService;
    @Autowired
    private ICategoryService categoryService;
    @Autowired
    private IAddressService addressService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;

    @RequestMapping(value={"/supplyDemand"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse supplyDemand(HttpServletRequest request) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WbuyEntity::getStatus, (Object)0);
        List wbuyEntities = this.wbuyService.list((Wrapper)queryWrapper);
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)wbuyEntities)) {
            List<WbuyEntity> list = null;
            for (WbuyEntity wb : wbuyEntities) {
                list = map.containsKey(wb.getBuyer()) ? (List)map.get(wb.getBuyer()) : new ArrayList<WbuyEntity>();
                list.add(wb);
                map.put(wb.getBuyer(), list);
            }
        }
        if (!map.isEmpty()) {
            HashSet<String> sender = new HashSet<String>();
            for (Long buyer : map.keySet()) {
                if (sender.contains(buyer)) continue;
                List wbList = (List)map.get(buyer);
                for (WbuyEntity wbuyEntity : wbList) {
                    String configOrgId = this.configService.queryConfigOrgByOrgId(wbuyEntity.getOrgId());
                    if (StringUtils.isBlank((CharSequence)configOrgId)) continue;
                    LambdaQueryWrapper ctyQuery = new LambdaQueryWrapper();
                    ctyQuery.eq(CategoryEntity::getWbuyId, (Object)wbuyEntity.getId());
                    List categoryEntities = this.categoryService.list((Wrapper)ctyQuery);
                    List categoryList = categoryEntities.stream().map(CategoryEntity::getMaterialTypeId).collect(Collectors.toList());
                    CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(Long.valueOf(configOrgId));
                    if (!childOrgResp.isSuccess()) {
                        throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)((Collection)childOrgResp.getData()))) continue;
                    ArrayList childIds = new ArrayList();
                    childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
                    LambdaQueryWrapper goodQuery = new LambdaQueryWrapper();
                    goodQuery.in(GoodsEntity::getMaterialTypeId, categoryList);
                    goodQuery.in(GoodsEntity::getOrgId, childIds);
                    List goodsEntities = this.goodsService.list((Wrapper)goodQuery);
                    if (!CollectionUtils.isNotEmpty((Collection)goodsEntities)) continue;
                    sender.add(String.valueOf(buyer));
                }
            }
            if (CollectionUtils.isNotEmpty(sender)) {
                ArrayList<String> messageType = new ArrayList<String>();
                messageType.add("sys");
                messageType.add("wjy");
                this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
                String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket?isSupplyDemand=1";
                String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/marketIndex?isSupplyDemand=1";
                String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u53d1\u5e03\u7684\u6c42\u8d2d\u4fe1\u606f\u5728\u96c6\u5e02\u4e2d\u6709\u5bf9\u5e94\u7684\u7269\u8d44\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\uff01";
                String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u53d1\u5e03\u7684\u6c42\u8d2d\u4fe1\u606f\u5728\u96c6\u5e02\u4e2d\u6709\u5bf9\u5e94\u7684\u7269\u8d44\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\uff01<a href=\"" + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.sendMsg(messageType, new ArrayList<String>(sender), "notice", subject, content, mobileUrl);
            }
        }
        return CommonResponse.success((String)"\u4f9b\u9700\u5173\u7cfb\u9884\u8b66\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/sellMatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse sellMatch(HttpServletRequest request) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(GoodsEntity::getStatus, (Object)0);
        queryWrapper.in(GoodsEntity::getBillState, new Object[]{1, 3});
        List goodsEntities = this.goodsService.list((Wrapper)queryWrapper);
        HashSet<String> sender = new HashSet<String>();
        for (GoodsEntity goodsEntity : goodsEntities) {
            String configOrgId;
            if (sender.contains(goodsEntity.getSeller()) || StringUtils.isBlank((CharSequence)(configOrgId = this.configService.queryConfigOrgByOrgId(goodsEntity.getOrgId())))) continue;
            CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(Long.valueOf(configOrgId));
            if (!childOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            LambdaQueryWrapper wbQuery = new LambdaQueryWrapper();
            wbQuery.eq(WbuyEntity::getStatus, (Object)0);
            wbQuery.in(WbuyEntity::getOrgId, childIds);
            List wbuyEntities = this.wbuyService.list((Wrapper)wbQuery);
            if (!CollectionUtils.isNotEmpty((Collection)wbuyEntities)) continue;
            List wbIdList = wbuyEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper ctyQuery = new LambdaQueryWrapper();
            ctyQuery.eq(CategoryEntity::getMaterialTypeId, (Object)goodsEntity.getMaterialTypeId());
            ctyQuery.in(CategoryEntity::getWbuyId, wbIdList);
            List categoryEntities = this.categoryService.list((Wrapper)ctyQuery);
            if (!CollectionUtils.isNotEmpty((Collection)categoryEntities)) continue;
            sender.add(String.valueOf(goodsEntity.getSeller()));
        }
        if (CollectionUtils.isNotEmpty(sender)) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            messageType.add("wjy");
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
            String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/buyingInfo?isSellMatch=1";
            String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/marketPurchaseIndex?userid={userid}";
            String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u5df2\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u5176\u4ed6\u9879\u76ee\u5728\u6c42\u8d2d\uff0c\u70b9\u51fb\u67e5\u770b\uff01";
            String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u5df2\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u5176\u4ed6\u9879\u76ee\u5728\u6c42\u8d2d\uff0c\u70b9\u51fb\u67e5\u770b\uff01<a href=\"" + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.sendMsg(messageType, new ArrayList<String>(sender), "notice", subject, content, mobileUrl);
        }
        return CommonResponse.success((String)"\u4f9b\u9700\u5173\u7cfb\u9884\u8b66\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/newGoods"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse newGoods(HttpServletRequest request) {
        List addrlist = this.addressService.list();
        HashSet<Long> userSet = new HashSet<Long>();
        for (AddressEntity addressEntity : addrlist) {
            CommonResponse childOrgResp;
            String configOrgId = this.configService.queryConfigOrgByOrgId(addressEntity.getOrgId());
            if (!StringUtils.isNotBlank((CharSequence)configOrgId) || !(childOrgResp = this.orgApi.findChildrenByParentId(Long.valueOf(configOrgId))).isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)childOrgResp.getData()))) continue;
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("status", new Parameter("eq", (Object)0));
            param.getParams().put("rotatableNums", new Parameter("gt", (Object)0));
            param.getParams().put("distance", new Parameter("le", (Object)100000));
            Calendar calendar = Calendar.getInstance();
            calendar.set(6, calendar.get(6) - 1);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            param.getParams().put("shelf_time", new Parameter("ge", (Object)df.format(calendar.getTime())));
            ArrayList childIds = new ArrayList();
            childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            param.getParams().put("org_id", new Parameter("in", childIds));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<GoodsEntity> list = this.goodsService.queryGoods(new Page(), wrapper, Double.toString(addressEntity.getLon()), Double.toString(addressEntity.getLat()));
            if (!CollectionUtils.isNotEmpty(list)) continue;
            userSet.add(addressEntity.getUserId());
        }
        for (Long key : userSet) {
            ArrayList<String> messageType = new ArrayList<String>();
            messageType.add("sys");
            messageType.add("wjy");
            ArrayList<String> sender = new ArrayList<String>();
            sender.add(key + "");
            this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u53d1\u5e03\u4eba:>----------" + sender + this.baseHost);
            String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/assetMarket";
            String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/marketIndex";
            String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9644\u8fd1\u7684\u9879\u76ee\u6628\u65e5\u6709\u65b0\u7269\u8d44\u4e0a\u67b6\uff0c\u6709\u9700\u8981\u8bf7\u53ca\u65f6\u67e5\u770b\uff01";
            String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u9644\u8fd1\u7684\u9879\u76ee\u6628\u65e5\u6709\u65b0\u7269\u8d44\u4e0a\u67b6\uff0c\u6709\u9700\u8981\u8bf7\u53ca\u65f6\u67e5\u770b\uff01<a href=\"" + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
            this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        }
        return CommonResponse.success((String)"\u4e0a\u65b0\u63d0\u9192\u9884\u8b66\u6210\u529f\uff01");
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String mobileUrl) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4e94\u5c40\u8f7b\u91cf\u5316\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)mobileUrl);
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

