/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.panhuo.bean.AllotDetailEntity;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.bean.ConfigEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.AllotMapper;
import com.ejianc.business.panhuo.service.IAllotDetailService;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotService")
public class AllotServiceImpl
extends BaseServiceImpl<AllotMapper, AllotEntity>
implements IAllotService {
    private static final String CSCEC5B_PANHUO_DBD = "CSCEC5B_PANHUO_DBD";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IAllotDetailService allotDetailService;
    @Autowired
    private IAllotService service;
    @Autowired
    private IProjectApi projectApi;

    @Override
    public AllotVO saveAllot(AllotVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AllotEntity entity = (AllotEntity)((Object)BeanMapper.map((Object)vo, AllotEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        AllotVO resvo = (AllotVO)BeanMapper.map((Object)((Object)entity), AllotVO.class);
        return resvo;
    }

    @Override
    public void generation(String allotDateStr) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgAllotStatus", new Parameter("eq", (Object)1));
        List<ConfigEntity> configEntityList = this.configService.queryList(queryParam);
        HashMap<Long, String> configMap = new HashMap<Long, String>();
        for (ConfigEntity configEntity : configEntityList) {
            configMap.put(configEntity.getOrgId(), StringUtils.isBlank((CharSequence)configEntity.getOrgCreateDate()) ? "21" : configEntity.getOrgCreateDate());
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(1);
        typeList.add(2);
        CommonResponse listCommonResponse = this.orgApi.findOrgByType(tenantId, typeList, "");
        if (!listCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgList = ResultAsTree.createTreeData((List)BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), Map.class));
        configEntityList = AllotServiceImpl.getConfigTree(orgList, configMap);
        String maxMonthDay = null;
        if (allotDateStr != null) {
            Date date = null;
            try {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(allotDateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            maxMonthDay = DateFormatUtils.format((Date)DateUtils.setDays((Date)date, (int)calendar.getActualMaximum(5)), (String)"dd");
        } else {
            maxMonthDay = DateFormatUtils.format((Date)DateUtils.setDays((Date)new Date(), (int)Calendar.getInstance().getActualMaximum(5)), (String)"dd");
        }
        Date allotDate = null;
        try {
            allotDate = StringUtils.isEmpty((CharSequence)allotDateStr) ? new Date() : DateUtils.parseDate((String)allotDateStr, (String[])new String[]{"yyyy-MM-dd"});
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String beginDate = DateFormatUtils.format((Date)DateUtils.addMonths(allotDate, (int)-1), (String)"yyyy-MM-dd");
        String endDate = DateFormatUtils.format((Date)DateUtils.addDays((Date)allotDate, (int)-1), (String)"yyyy-MM-dd");
        for (ConfigEntity configEntity : configEntityList) {
            List<String> createDateList;
            if (StringUtils.isEmpty((CharSequence)configEntity.getOrgCreateDate())) continue;
            if (configEntity.getOrgCreateDate().equals("\u6700\u540e\u4e00\u5929")) {
                configEntity.setOrgCreateDate(maxMonthDay);
            }
            if (!(createDateList = Arrays.asList(configEntity.getOrgCreateDate().split(","))).contains(DateFormatUtils.format((Date)allotDate, (String)"dd"))) continue;
            String orgId = String.valueOf(configEntity.getOrgId());
            String maxDate = this.orderService.getAllotMaxDate(orgId);
            this.logger.info("------orgId:" + orgId);
            this.logger.info("------maxDate:" + maxDate);
            this.logger.info("------allotDateStr:" + allotDateStr);
            if (StringUtils.isEmpty((CharSequence)allotDateStr) && StringUtils.isNotEmpty((CharSequence)maxDate)) {
                beginDate = maxDate;
            }
            List<OrderVO> orderVOList = this.orderService.getAllots(orgId, beginDate, endDate);
            for (OrderVO orderVO : orderVOList) {
                AllotEntity allotEntity = new AllotEntity();
                allotEntity.setBillState(1);
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD, tenantId);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                allotEntity.setBillCode((String)billCode.getData());
                allotEntity.setAllotMonth(DateFormatUtils.format((Date)allotDate, (String)"yyyy-MM"));
                allotEntity.setDealrTime(allotDate);
                allotEntity.setConfirmer(orderVO.getSeller());
                allotEntity.setConfirmerName(orderVO.getSellerName());
                allotEntity.setSellOrg(orderVO.getSellOrg());
                allotEntity.setParentSellOrg(orderVO.getParentSellOrg());
                allotEntity.setSellOrgName(orderVO.getSellOrgName());
                allotEntity.setSellProject(orderVO.getSellProject());
                allotEntity.setSellProjectName(orderVO.getSellProjectName());
                ArrayList<Long> sellIds = new ArrayList<Long>();
                sellIds.add(orderVO.getSellProject());
                CommonResponse sellRes = this.projectApi.queryProjectByIds(sellIds);
                if (!sellRes.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)sellRes.getData()))) {
                    this.logger.error(JSONObject.toJSONString((Object)orderVO));
                    this.logger.error("\u67e5\u8be2\u51fa\u552e\u9879\u76ee\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff01");
                    continue;
                }
                ProjectRegisterVO project = (ProjectRegisterVO)((List)sellRes.getData()).get(0);
                allotEntity.setParentSellRealCorpId(project.getId());
                allotEntity.setParentSellRealNcCorp(project.getSourceId());
                allotEntity.setParentSellRealCorpName(project.getName());
                ArrayList<Long> buyIds = new ArrayList<Long>();
                buyIds.add(orderVO.getBuyProject());
                CommonResponse buyRes = this.projectApi.queryProjectByIds(buyIds);
                if (!buyRes.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)buyRes.getData()))) {
                    this.logger.error(JSONObject.toJSONString((Object)orderVO));
                    this.logger.error("\u67e5\u8be2\u91c7\u8d2d\u9879\u76ee\u4fe1\u606f\u8be6\u60c5\u5931\u8d25\uff01");
                    continue;
                }
                ProjectRegisterVO project2 = (ProjectRegisterVO)((List)buyRes.getData()).get(0);
                allotEntity.setParentBuyRealCorpId(project2.getId());
                allotEntity.setParentBuyRealNcCorp(project2.getSourceId());
                allotEntity.setParentBuyRealCorpName(project2.getName());
                allotEntity.setOrderUserId(orderVO.getOrderUserId());
                allotEntity.setOrderUserName(orderVO.getOrderUserName());
                allotEntity.setBuyOrg(orderVO.getBuyOrg());
                allotEntity.setParentBuyOrg(orderVO.getParentBuyOrg());
                allotEntity.setBuyOrgName(orderVO.getBuyOrgName());
                allotEntity.setBuyProject(orderVO.getBuyProject());
                allotEntity.setBuyProjectName(orderVO.getBuyProjectName());
                allotEntity.setAmount(orderVO.getTotalMny());
                queryParam = new QueryParam();
                if (allotEntity.getConfirmer() != null) {
                    queryParam.getParams().put("seller", new Parameter("eq", (Object)allotEntity.getConfirmer()));
                }
                if (StringUtils.isNotEmpty((CharSequence)allotEntity.getConfirmerName())) {
                    queryParam.getParams().put("seller_name", new Parameter("eq", (Object)allotEntity.getConfirmerName()));
                }
                queryParam.getParams().put("on_shelf_type", new Parameter("eq", (Object)0));
                queryParam.getParams().put("sell_org", new Parameter("eq", (Object)allotEntity.getSellOrg()));
                queryParam.getParams().put("sell_project", new Parameter("eq", (Object)allotEntity.getSellProject()));
                if (allotEntity.getOrderUserId() != null) {
                    queryParam.getParams().put("order_user_id", new Parameter("eq", (Object)allotEntity.getOrderUserId()));
                }
                if (StringUtils.isNotEmpty((CharSequence)allotEntity.getOrderUserName())) {
                    queryParam.getParams().put("order_user_name", new Parameter("eq", (Object)allotEntity.getOrderUserName()));
                }
                queryParam.getParams().put("buy_org", new Parameter("eq", (Object)allotEntity.getBuyOrg()));
                queryParam.getParams().put("buy_project", new Parameter("eq", (Object)allotEntity.getBuyProject()));
                queryParam.getParams().put("dealr_time", new Parameter("between", (Object)(beginDate + "," + DateFormatUtils.format((Date)allotDate, (String)"yyyy-MM-dd"))));
                List orderEntityList = this.orderService.queryList(queryParam);
                ArrayList<AllotDetailEntity> allotDetailEntityList = new ArrayList<AllotDetailEntity>();
                for (OrderEntity orderEntity : orderEntityList) {
                    AllotDetailEntity allotDetailEntity = new AllotDetailEntity();
                    allotDetailEntity.setGoodsId(orderEntity.getGoodsId());
                    allotDetailEntity.setOrderId(orderEntity.getId());
                    allotDetailEntity.setMaterialId(orderEntity.getMaterialId());
                    allotDetailEntity.setMaterialCode(orderEntity.getMaterialCode());
                    allotDetailEntity.setMaterialName(orderEntity.getMaterialName());
                    allotDetailEntity.setMaterialTypeId(orderEntity.getMaterialTypeId());
                    allotDetailEntity.setMaterialTypeName(orderEntity.getMaterialTypeName());
                    allotDetailEntity.setSourceId(orderEntity.getSourceId());
                    allotDetailEntity.setSystemId(orderEntity.getSystemId());
                    allotDetailEntity.setSpec(orderEntity.getSpec());
                    allotDetailEntity.setMainimgPath(orderEntity.getMainimgPath());
                    allotDetailEntity.setUnit(orderEntity.getUnit());
                    allotDetailEntity.setDiscount(orderEntity.getDiscount());
                    allotDetailEntity.setPrice(orderEntity.getPrice());
                    allotDetailEntity.setNums(orderEntity.getNums());
                    allotDetailEntity.setAmount(orderEntity.getMny());
                    allotDetailEntity.setTax(orderEntity.getTax() == null ? BigDecimal.ZERO : orderEntity.getTax());
                    allotDetailEntity.setTaxMny(orderEntity.getTaxMny() == null ? BigDecimal.ZERO : orderEntity.getTaxMny());
                    allotDetailEntity.setTaxOrderMny(orderEntity.getTaxOrderMny() == null ? orderEntity.getMny() : orderEntity.getTaxOrderMny());
                    allotDetailEntity.setDealrTime(orderEntity.getDealrTime());
                    allotDetailEntity.setMemo(orderEntity.getMemo());
                    allotDetailEntityList.add(allotDetailEntity);
                }
                allotEntity.setAllotDetail(allotDetailEntityList);
                super.saveOrUpdate((Object)allotEntity, false);
            }
        }
    }

    public static List<ConfigEntity> getConfigTree(List<Map<String, Object>> list, Map<Long, String> configMap) {
        ArrayList<ConfigEntity> result = new ArrayList<ConfigEntity>();
        for (Map<String, Object> stringObjectMap : list) {
            ConfigEntity config = new ConfigEntity();
            config.setOrgId(Long.valueOf(String.valueOf(stringObjectMap.get("id"))));
            config.setOrgName(String.valueOf(stringObjectMap.get("name")));
            if (stringObjectMap.get("parentId") != null) {
                config.setOrgParentId(Long.valueOf(String.valueOf(stringObjectMap.get("parentId"))));
            }
            String[] innerCode = String.valueOf(stringObjectMap.get("innerCode")).split("\\|");
            for (int i = innerCode.length - 1; i >= 0; --i) {
                if (configMap.get(Long.valueOf(innerCode[i])) == null) continue;
                config.setOrgCreateDate(configMap.get(Long.valueOf(innerCode[i])));
                break;
            }
            result.add(config);
            List child = (List)stringObjectMap.get("children");
            if (child == null) continue;
            result.addAll(AllotServiceImpl.getConfigTree(child, configMap));
        }
        return result;
    }

    @Override
    public void customerGeneration(String beginDate, String endDate, String orgId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orgAllotStatus", new Parameter("eq", (Object)1));
        List<ConfigEntity> configEntityList = this.configService.queryList(queryParam);
        HashMap<Long, String> configMap = new HashMap<Long, String>();
        for (ConfigEntity configEntity : configEntityList) {
            configMap.put(configEntity.getOrgId(), StringUtils.isBlank((CharSequence)configEntity.getOrgCreateDate()) ? "21" : configEntity.getOrgCreateDate());
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(1);
        typeList.add(2);
        CommonResponse listCommonResponse = this.orgApi.findOrgByType(tenantId, typeList, "");
        if (!listCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgList = ResultAsTree.createTreeData((List)BeanMapper.mapList((Iterable)((Iterable)listCommonResponse.getData()), Map.class));
        configEntityList = AllotServiceImpl.getConfigTree(orgList, configMap);
        String maxMonthDay = DateFormatUtils.format((Date)DateUtils.setDays((Date)new Date(), (int)Calendar.getInstance().getActualMaximum(5)), (String)"dd");
        Date allotDate = null;
        try {
            allotDate = StringUtils.isEmpty((CharSequence)endDate) ? new Date() : DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd"});
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        for (ConfigEntity configEntity : configEntityList) {
            this.logger.info("\u5f53\u524d\u7ec4\u7ec7ID\u5f00\u59cb\uff1a" + configEntity.getOrgId());
            this.logger.info("\u5f53\u524d\u7ec4\u7ec7\u8c03\u62e8\u65e5\u671f\u5f00\u59cb\uff1a" + configEntity.getOrgCreateDate());
            this.logger.info("\u5f53\u524dallotDate\u5f00\u59cb\uff1a" + allotDate);
            if (StringUtils.isEmpty((CharSequence)configEntity.getOrgCreateDate())) continue;
            if (configEntity.getOrgCreateDate().equals("\u6700\u540e\u4e00\u5929")) {
                configEntity.setOrgCreateDate(maxMonthDay);
            }
            if (!configEntity.getOrgCreateDate().equals(DateFormatUtils.format((Date)allotDate, (String)"dd")) || !configEntity.getOrgId().toString().equals(orgId)) continue;
            this.logger.info("\u5f53\u524d\u7ec4\u7ec7ID\u7ed3\u675f\uff1a" + configEntity.getOrgId());
            this.logger.info("\u5f53\u524dbeginDate\u7ed3\u675f\uff1a" + beginDate);
            this.logger.info("\u5f53\u524dendDate\u7ed3\u675f\uff1a" + endDate);
            List<OrderVO> orderVOList = this.orderService.getAllots(orgId, beginDate, endDate);
            for (OrderVO orderVO : orderVOList) {
                AllotEntity allotEntity = new AllotEntity();
                allotEntity.setBillState(1);
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DBD, tenantId);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                allotEntity.setBillCode((String)billCode.getData());
                allotEntity.setAllotMonth(DateFormatUtils.format((Date)allotDate, (String)"yyyy-MM"));
                allotEntity.setDealrTime(allotDate);
                allotEntity.setConfirmer(orderVO.getSeller());
                allotEntity.setConfirmerName(orderVO.getSellerName());
                allotEntity.setSellOrg(orderVO.getSellOrg());
                allotEntity.setParentSellOrg(orderVO.getParentSellOrg());
                allotEntity.setSellOrgName(orderVO.getSellOrgName());
                allotEntity.setSellProject(orderVO.getSellProject());
                allotEntity.setSellProjectName(orderVO.getSellProjectName());
                allotEntity.setOrderUserId(orderVO.getOrderUserId());
                allotEntity.setOrderUserName(orderVO.getOrderUserName());
                allotEntity.setBuyOrg(orderVO.getBuyOrg());
                allotEntity.setParentBuyOrg(orderVO.getParentBuyOrg());
                allotEntity.setBuyOrgName(orderVO.getBuyOrgName());
                allotEntity.setBuyProject(orderVO.getBuyProject());
                allotEntity.setBuyProjectName(orderVO.getBuyProjectName());
                allotEntity.setAmount(orderVO.getTotalMny());
                queryParam = new QueryParam();
                if (allotEntity.getConfirmer() != null) {
                    queryParam.getParams().put("seller", new Parameter("eq", (Object)allotEntity.getConfirmer()));
                }
                if (StringUtils.isNotEmpty((CharSequence)allotEntity.getConfirmerName())) {
                    queryParam.getParams().put("seller_name", new Parameter("eq", (Object)allotEntity.getConfirmerName()));
                }
                queryParam.getParams().put("on_shelf_type", new Parameter("eq", (Object)0));
                queryParam.getParams().put("sell_org", new Parameter("eq", (Object)allotEntity.getSellOrg()));
                queryParam.getParams().put("sell_project", new Parameter("eq", (Object)allotEntity.getSellProject()));
                if (allotEntity.getOrderUserId() != null) {
                    queryParam.getParams().put("order_user_id", new Parameter("eq", (Object)allotEntity.getOrderUserId()));
                }
                if (StringUtils.isNotEmpty((CharSequence)allotEntity.getOrderUserName())) {
                    queryParam.getParams().put("order_user_name", new Parameter("eq", (Object)allotEntity.getOrderUserName()));
                }
                queryParam.getParams().put("buy_org", new Parameter("eq", (Object)allotEntity.getBuyOrg()));
                queryParam.getParams().put("buy_project", new Parameter("eq", (Object)allotEntity.getBuyProject()));
                queryParam.getParams().put("dealr_time", new Parameter("between", (Object)(beginDate + "," + DateFormatUtils.format((Date)allotDate, (String)"yyyy-MM-dd"))));
                List orderEntityList = this.orderService.queryList(queryParam);
                ArrayList<AllotDetailEntity> allotDetailEntityList = new ArrayList<AllotDetailEntity>();
                for (OrderEntity orderEntity : orderEntityList) {
                    AllotDetailEntity allotDetailEntity = new AllotDetailEntity();
                    allotDetailEntity.setGoodsId(orderEntity.getGoodsId());
                    allotDetailEntity.setOrderId(orderEntity.getId());
                    allotDetailEntity.setMaterialId(orderEntity.getMaterialId());
                    allotDetailEntity.setMaterialCode(orderEntity.getMaterialCode());
                    allotDetailEntity.setMaterialName(orderEntity.getMaterialName());
                    allotDetailEntity.setMaterialTypeId(orderEntity.getMaterialTypeId());
                    allotDetailEntity.setMaterialTypeName(orderEntity.getMaterialTypeName());
                    allotDetailEntity.setSourceId(orderEntity.getSourceId());
                    allotDetailEntity.setSystemId(orderEntity.getSystemId());
                    allotDetailEntity.setSpec(orderEntity.getSpec());
                    allotDetailEntity.setMainimgPath(orderEntity.getMainimgPath());
                    allotDetailEntity.setUnit(orderEntity.getUnit());
                    allotDetailEntity.setPrice(orderEntity.getPrice());
                    allotDetailEntity.setNums(orderEntity.getNums());
                    allotDetailEntity.setAmount(orderEntity.getMny());
                    allotDetailEntity.setDealrTime(orderEntity.getDealrTime());
                    allotDetailEntity.setMemo(orderEntity.getMemo());
                    allotDetailEntityList.add(allotDetailEntity);
                }
                allotEntity.setAllotDetail(allotDetailEntityList);
                super.saveOrUpdate((Object)allotEntity, false);
            }
        }
    }
}

