/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderBatchDetailEntity;
import com.ejianc.business.panhuo.bean.OrderBatchEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderBatchService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.OrderBatchDetailVO;
import com.ejianc.business.panhuo.vo.OrderBatchVO;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderBatch")
public class OrderBatchBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderBatchService orderBatchService;
    @Autowired
    private IGoodsService goodsService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u63d0\u4ea4\u524d\u56de\u8c03====================================== state:" + state);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03====================================== state:" + state);
        OrderBatchEntity orderBatchEntity = (OrderBatchEntity)((Object)this.orderBatchService.selectById(billId));
        OrderBatchVO vo = (OrderBatchVO)((Object)BeanMapper.map((Object)((Object)orderBatchEntity), OrderBatchVO.class));
        List<OrderBatchDetailVO> orderBatchDetailVOList = vo.getOrderBatchDetailList();
        if (CollectionUtils.isNotEmpty(orderBatchDetailVOList)) {
            for (OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(OrderEntity::getBillCode, (Object)orderBatchDetailVO.getBillCode());
                this.orderService.remove((Wrapper)queryWrapper);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderBatchEntity orderBatchEntity;
        OrderBatchVO vo;
        List<OrderBatchDetailVO> orderBatchDetailVOList;
        this.logger.info("======================================\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03====================================== state:" + state);
        if ((state == 0 || state == 2) && CollectionUtils.isNotEmpty(orderBatchDetailVOList = (vo = (OrderBatchVO)((Object)BeanMapper.map((Object)((Object)(orderBatchEntity = (OrderBatchEntity)((Object)this.orderBatchService.selectById(billId)))), OrderBatchVO.class))).getOrderBatchDetailList())) {
            for (OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList) {
                BigDecimal ordernums;
                GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(orderBatchDetailVO.getGoodsId()));
                BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                BigDecimal bigDecimal = ordernums = orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums();
                if (ordernums.compareTo(rotatableNums) > 0) {
                    throw new BusinessException("\u8d2d\u7269\u8f66\u7f16\u53f7\uff1a" + orderBatchDetailVO.getBillCode() + ",\u4e0b\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u8d44\u4ea7\u53ef\u5468\u8f6c\u6570\u91cf!");
                }
                goodsEntity.setPreNums(ComputeUtil.safeAdd((BigDecimal)goodsEntity.getPreNums(), (BigDecimal)orderBatchDetailVO.getOrdernums()));
                goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getRotatableNums(), (BigDecimal)orderBatchDetailVO.getOrdernums()));
                this.goodsService.saveOrUpdate((Object)goodsEntity, false);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderBatchEntity orderBatchEntity = (OrderBatchEntity)((Object)this.orderBatchService.selectById(billId));
        List<OrderBatchDetailEntity> orderBatchDetailEntityList = orderBatchEntity.getOrderBatchDetailList();
        if (CollectionUtils.isNotEmpty(orderBatchDetailEntityList)) {
            for (OrderBatchDetailEntity orderBatchDetailEntity : orderBatchDetailEntityList) {
                this.logger.info(orderBatchDetailEntity.getBillState().toString() + "============================================================================");
                orderBatchDetailEntity.setBillState(1);
                OrderEntity orderEntity = (OrderEntity)((Object)BeanMapper.map((Object)((Object)orderBatchDetailEntity), OrderEntity.class));
                orderEntity.setId(null);
                OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
                this.orderService.saveBatchOrder(orderVO);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        throw new BusinessException("\u5f03\u5ba1\u5931\u8d25\uff01\u5ba1\u6279\u901a\u8fc7\u540e\u65e0\u6cd5\u5f03\u5ba1\uff0c\u8bf7\u5728\u8ba2\u5355\u4e2d\u53d6\u6d88\u8ba2\u5355");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("======================================\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03====================================== state:" + state);
        OrderBatchEntity orderBatchEntity = (OrderBatchEntity)((Object)this.orderBatchService.selectById(billId));
        OrderBatchVO vo = (OrderBatchVO)((Object)BeanMapper.map((Object)((Object)orderBatchEntity), OrderBatchVO.class));
        List<OrderBatchDetailVO> orderBatchDetailVOList = vo.getOrderBatchDetailList();
        if (CollectionUtils.isNotEmpty(orderBatchDetailVOList)) {
            for (OrderBatchDetailVO orderBatchDetailVO : orderBatchDetailVOList) {
                GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(orderBatchDetailVO.getGoodsId()));
                BigDecimal rotatableNums = goodsEntity.getRotatableNums() == null ? BigDecimal.ZERO : goodsEntity.getRotatableNums();
                BigDecimal preNums = goodsEntity.getPreNums() == null ? BigDecimal.ZERO : goodsEntity.getPreNums();
                goodsEntity.setPreNums(preNums.subtract(orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums()));
                goodsEntity.setRotatableNums(rotatableNums.add(orderBatchDetailVO.getOrdernums() == null ? BigDecimal.ZERO : orderBatchDetailVO.getOrdernums()));
                this.goodsService.saveOrUpdate((Object)goodsEntity, false);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(OrderEntity::getBillCode, (Object)orderBatchDetailVO.getBillCode());
                this.orderService.remove((Wrapper)queryWrapper);
            }
        }
        return CommonResponse.success();
    }
}

