/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.ejianc.business.panhuo.bean.OrderBatchEntity;
import com.ejianc.business.panhuo.bean.ShoppingCartEntity;
import com.ejianc.business.panhuo.mapper.OrderBatchMapper;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderBatchService;
import com.ejianc.business.panhuo.service.IShoppingCartService;
import com.ejianc.business.panhuo.vo.OrderBatchDetailVO;
import com.ejianc.business.panhuo.vo.OrderBatchVO;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderBatchService")
public class OrderBatchServiceImpl
extends BaseServiceImpl<OrderBatchMapper, OrderBatchEntity>
implements IOrderBatchService {
    private static final String BILL_CODE = "CSCEC5B_PANHUO_BO";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IShoppingCartService shoppingCartService;

    @Override
    public OrderBatchVO saveOrderBatch(OrderBatchVO vo) {
        OrderBatchEntity entity = (OrderBatchEntity)((Object)BeanMapper.map((Object)((Object)vo), OrderBatchEntity.class));
        this.saveOrUpdate((Object)entity, false);
        OrderBatchVO orderBatchVO = (OrderBatchVO)((Object)BeanMapper.map((Object)((Object)entity), OrderBatchVO.class));
        return orderBatchVO;
    }

    @Override
    public OrderBatchVO saveFromCart(List<ShoppingCartVO> vos) {
        OrderBatchVO orderBatchVO = new OrderBatchVO();
        ArrayList<OrderBatchDetailVO> orderBatchDetailVOLists = new ArrayList<OrderBatchDetailVO>();
        BigDecimal totalMny = BigDecimal.ZERO;
        Boolean isFirst = Boolean.TRUE;
        for (ShoppingCartVO vo : vos) {
            ShoppingCartEntity cartEntity = (ShoppingCartEntity)((Object)this.shoppingCartService.selectById(vo.getId()));
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)cartEntity.getOrdermny());
            if (isFirst.booleanValue()) {
                orderBatchVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                orderBatchVO.setOrgId(cartEntity.getBuyOrg());
                orderBatchVO.setProjectId(cartEntity.getBuyProject());
                orderBatchVO.setProjectName(cartEntity.getBuyProjectName());
                orderBatchVO.setUserName(cartEntity.getOrderUserName());
                orderBatchVO.setUserPhone(cartEntity.getBuyPhone());
                isFirst = false;
            }
            OrderBatchDetailVO detailVO = (OrderBatchDetailVO)((Object)BeanMapper.map((Object)((Object)cartEntity), OrderBatchDetailVO.class));
            orderBatchDetailVOLists.add(detailVO);
        }
        orderBatchVO.setSumMny(totalMny);
        orderBatchVO.setOrderBatchDetailList(orderBatchDetailVOLists);
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        orderBatchVO.setBillCode((String)billCode.getData());
        OrderBatchEntity entity = (OrderBatchEntity)((Object)BeanMapper.map((Object)((Object)orderBatchVO), OrderBatchEntity.class));
        this.saveOrUpdate((Object)entity, false);
        this.shoppingCartService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return (OrderBatchVO)((Object)BeanMapper.map((Object)this.selectById(entity.getId()), OrderBatchVO.class));
    }
}

