/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.op.api.IApplyApi;
import com.ejianc.business.op.vo.ApplyDetailVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.InstoreEntity;
import com.ejianc.business.panhuo.bean.InstoreHzEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.mapper.OrderMapper;
import com.ejianc.business.panhuo.mapper.SyncInstoreMapper;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IInstoreHzService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.service.ISyncInstoreService;
import com.ejianc.business.panhuo.vo.OrderVO;
import com.ejianc.business.warn.api.IWarningApi;
import com.ejianc.business.warn.vo.WarningParameterVO;
import com.ejianc.business.warn.vo.WarningVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CSCEC5B_PANHUO_DD = "CSCEC5B_PANHUO_DD";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IAllotService allotService;
    @Autowired
    private IConfigService configService;
    @Autowired
    private ISyncInstoreService syncInstoreService;
    @Autowired
    private SyncInstoreMapper syncInstoreMapper;
    @Autowired
    private IInstoreHzService instoreHzService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWarningApi warningApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${wjy.path}")
    private String wjyPath;
    @Value(value="${wjy.appid}")
    private String appid;
    @Value(value="${sync.address}")
    private String syncAddr;
    @Autowired
    private IApplyApi applyApi;

    @Override
    public OrderVO saveOrder(OrderVO vo) {
        String sellConfigOrgId;
        OrgVO orgVO;
        CommonResponse commonResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(vo.getGoodsId()));
        if (goodsEntity.getVersion() != vo.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        if (ComputeUtil.isGreaterThan((BigDecimal)vo.getOrdernums(), (BigDecimal)goodsEntity.getRotatableNums())) {
            throw new BusinessException("\u4e0b\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u8d44\u4ea7\u53ef\u5468\u8f6c\u6570\u91cf!");
        }
        OrderEntity orderEntity = (OrderEntity)((Object)BeanMapper.map((Object)vo, OrderEntity.class));
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setShelfType(goodsEntity.getShelfType());
        orderEntity.setShelfTime(goodsEntity.getShelfTime());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialCode(goodsEntity.getMaterialCode());
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        orderEntity.setMny(vo.getOrdermny() == null ? BigDecimal.ZERO : vo.getOrdermny());
        orderEntity.setPrice(vo.getOrderprice() == null ? BigDecimal.ZERO : vo.getOrderprice());
        orderEntity.setNums(vo.getOrdernums() == null ? BigDecimal.ZERO : vo.getOrdernums());
        orderEntity.setOriginalprice(goodsEntity.getOriginalprice());
        orderEntity.setDiscount(goodsEntity.getDiscount());
        orderEntity.setPreSaleDate(goodsEntity.getPreSaleDate());
        orderEntity.setPreSaleFlag(goodsEntity.getPreSaleFlag());
        orderEntity.setOnShelfType(goodsEntity.getOnShelfType() == null ? 0 : goodsEntity.getOnShelfType());
        if (null != orderEntity.getSellOrg() && orderEntity.getSellOrg() > 0L && (commonResponse = this.orgApi.getOneById(orderEntity.getSellOrg())).isSuccess()) {
            orgVO = (OrgVO)commonResponse.getData();
            orderEntity.setParentSellOrg(orgVO.getParentId());
        }
        if (null != orderEntity.getBuyOrg() && orderEntity.getBuyOrg() > 0L) {
            commonResponse = this.orgApi.getOneById(orderEntity.getBuyOrg());
            if (commonResponse.isSuccess()) {
                orgVO = (OrgVO)commonResponse.getData();
                orderEntity.setParentBuyOrg(orgVO.getParentId());
            } else {
                throw new BusinessException("\u83b7\u53d6\u8d2d\u4e70\u7ec4\u7ec7\u4e0a\u7ea7\u7ec4\u7ec7\u5f02\u5e38!");
            }
        }
        if (StringUtils.isEmpty((CharSequence)(sellConfigOrgId = this.configService.queryConfigOrgByOrgId(orderEntity.getSellOrg())))) {
            throw new BusinessException("\u51fa\u552e\u65b9\u672a\u8bbe\u7f6e\u8c03\u62e8\u7ba1\u7406\u7ec4\u7ec7!");
        }
        String buyConfigOrgId = this.configService.queryConfigOrgByOrgId(orderEntity.getBuyOrg());
        if (StringUtils.isEmpty((CharSequence)buyConfigOrgId)) {
            throw new BusinessException("\u8d2d\u4e70\u65b9\u672a\u8bbe\u7f6e\u8c03\u62e8\u7ba1\u7406\u7ec4\u7ec7!");
        }
        if (!sellConfigOrgId.equals(buyConfigOrgId)) {
            throw new BusinessException("\u8c03\u62e8\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5339\u914d!");
        }
        if (null != vo && StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_DD, tenantId);
            if (billCode.isSuccess()) {
                orderEntity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        goodsEntity.setPreNums(ComputeUtil.safeAdd((BigDecimal)goodsEntity.getPreNums(), (BigDecimal)vo.getOrdernums()));
        goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getRotatableNums(), (BigDecimal)vo.getOrdernums()));
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        super.saveOrUpdate((Object)orderEntity, false);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(goodsEntity.getSeller() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u63d0\u4ea4\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + orderEntity.getId() + "&type=1";
        String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/sellerManage/card?id=" + orderEntity.getId() + "&userid={userid}";
        String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u4e00\u4e2a\u65b0\u8ba2\u5355\u3010" + orderEntity.getBillCode() + "\u3011\u9700\u8981\u5904\u7406";
        String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u4e00\u4e2a\u65b0\u8ba2\u5355\u3010" + orderEntity.getBillCode() + "\u3011\u9700\u8981\u5904\u7406\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        OrderVO resvo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        return resvo;
    }

    @Override
    public OrderVO saveBatchOrder(OrderVO vo) {
        OrgVO orgVO;
        CommonResponse commonResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(vo.getGoodsId()));
        OrderEntity orderEntity = (OrderEntity)((Object)BeanMapper.map((Object)vo, OrderEntity.class));
        orderEntity.setToolId(goodsEntity.getToolId());
        orderEntity.setShelfType(goodsEntity.getShelfType());
        orderEntity.setShelfTime(goodsEntity.getShelfTime());
        orderEntity.setTenantId(tenantId);
        orderEntity.setMaterialCode(goodsEntity.getMaterialCode());
        orderEntity.setMaterialId(goodsEntity.getMaterialId());
        orderEntity.setMaterialName(goodsEntity.getMaterialName());
        orderEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        orderEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        orderEntity.setSystemId(goodsEntity.getSystemId());
        orderEntity.setSourceId(goodsEntity.getSourceId());
        orderEntity.setSpec(goodsEntity.getSpec());
        orderEntity.setMainimgPath(goodsEntity.getMainimgPath());
        orderEntity.setUnit(goodsEntity.getUnit());
        orderEntity.setType(0);
        orderEntity.setIsPack(goodsEntity.getIsPack());
        orderEntity.setSeller(goodsEntity.getSeller());
        orderEntity.setSellerName(goodsEntity.getSellerName());
        orderEntity.setSellAddress(goodsEntity.getAddress());
        orderEntity.setSellAddressId(goodsEntity.getAddressId());
        orderEntity.setSellOrg(goodsEntity.getOrgId());
        orderEntity.setSellOrgName(goodsEntity.getOrgName());
        orderEntity.setSellProject(goodsEntity.getProjectId());
        orderEntity.setSellProjectName(goodsEntity.getProjectName());
        orderEntity.setSellPhone(goodsEntity.getPhone());
        orderEntity.setSellUserName(goodsEntity.getName());
        orderEntity.setBuyTime(DateFormater.getCurrentDate());
        orderEntity.setMny(vo.getOrdermny() == null ? BigDecimal.ZERO : vo.getOrdermny());
        orderEntity.setPrice(vo.getOrderprice() == null ? BigDecimal.ZERO : vo.getOrderprice());
        orderEntity.setNums(vo.getOrdernums() == null ? BigDecimal.ZERO : vo.getOrdernums());
        orderEntity.setOriginalprice(goodsEntity.getOriginalprice());
        orderEntity.setDiscount(goodsEntity.getDiscount());
        orderEntity.setPreSaleDate(goodsEntity.getPreSaleDate());
        orderEntity.setPreSaleFlag(goodsEntity.getPreSaleFlag());
        orderEntity.setOnShelfType(goodsEntity.getOnShelfType() == null ? 0 : goodsEntity.getOnShelfType());
        if (null != orderEntity.getSellOrg() && orderEntity.getSellOrg() > 0L && (commonResponse = this.orgApi.getOneById(orderEntity.getSellOrg())).isSuccess()) {
            orgVO = (OrgVO)commonResponse.getData();
            orderEntity.setParentSellOrg(orgVO.getParentId());
        }
        if (null != orderEntity.getBuyOrg() && orderEntity.getBuyOrg() > 0L && (commonResponse = this.orgApi.getOneById(orderEntity.getBuyOrg())).isSuccess()) {
            orgVO = (OrgVO)commonResponse.getData();
            orderEntity.setParentBuyOrg(orgVO.getParentId());
        }
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        super.saveOrUpdate((Object)orderEntity, false);
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(goodsEntity.getSeller() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u63d0\u4ea4\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + orderEntity.getId() + "&type=1";
        String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/sellerManage/card?id=" + orderEntity.getId() + "&userid={userid}";
        String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u4e00\u4e2a\u65b0\u8ba2\u5355\u3010" + orderEntity.getBillCode() + "\u3011\u9700\u8981\u5904\u7406";
        String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u6709\u4e00\u4e2a\u65b0\u8ba2\u5355\u3010" + orderEntity.getBillCode() + "\u3011\u9700\u8981\u5904\u7406\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        OrderVO resvo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        return resvo;
    }

    @Override
    public String confirmerOrder(OrderVO vo) {
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(vo.getGoodsId()));
        OrderEntity orderEntity = (OrderEntity)((Object)super.getById((Serializable)vo.getId()));
        if (orderEntity.getVersion() != vo.getVersion()) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        if (ComputeUtil.isGreaterThan((BigDecimal)ComputeUtil.safeSub((BigDecimal)vo.getNums(), (BigDecimal)orderEntity.getOrdernums()), (BigDecimal)goodsEntity.getRotatableNums())) {
            throw new BusinessException("\u4e0b\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u8d44\u4ea7\u53ef\u5468\u8f6c\u6570\u91cf!");
        }
        goodsEntity.setSellNums(ComputeUtil.safeAdd((BigDecimal)goodsEntity.getSellNums(), (BigDecimal)vo.getNums()));
        goodsEntity.setPreNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getPreNums(), (BigDecimal)orderEntity.getOrdernums()));
        goodsEntity.setRotatableNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal[])new BigDecimal[]{goodsEntity.getSellNums(), goodsEntity.getPreNums()}));
        goodsEntity.setRemainingNums(ComputeUtil.safeSub((BigDecimal)goodsEntity.getNums(), (BigDecimal)goodsEntity.getSellNums()));
        if (BigDecimal.ZERO.compareTo(goodsEntity.getRemainingNums()) >= 0) {
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambdachange.eq(OrderEntity::getGoodsId, (Object)vo.getGoodsId());
            lambdachange.eq(OrderEntity::getType, (Object)0);
            lambdachange.ne(BaseEntity::getId, (Object)vo.getId());
            int num = super.count((Wrapper)lambdachange);
            if (num <= 0) {
                ArrayList<String> messageType = new ArrayList<String>();
                messageType.add("sys");
                messageType.add("wjy");
                ArrayList<String> sender = new ArrayList<String>();
                sender.add(goodsEntity.getSeller() + "");
                this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u63d0\u4ea4\u4eba:>----------" + sender);
                String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=1&lowerTime=" + DateFormater.getInstance().format("yyyy-MM-dd");
                String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/goodsManage/card?id=" + goodsEntity.getId() + "&userid={userid}";
                String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u3010" + goodsEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u552e\u7f44\u5e76\u4e0b\u67b6";
                String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u4e0a\u67b6\u7684\u7269\u8d44\u3010" + goodsEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u552e\u7f44\u5e76\u4e0b\u67b6\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
                this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
                goodsEntity.setStatus(1);
                goodsEntity.setLowerType(1);
                goodsEntity.setLower(InvocationInfoProxy.getUserid());
                goodsEntity.setLowerTime(DateFormater.getCurrentDate());
            }
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("wjy");
        ArrayList<String> sender = new ArrayList<String>();
        sender.add(orderEntity.getOrderUserId() + "");
        this.logger.info("\u53d1\u9001\u4fe1\u606f\u7ed9\u63d0\u4ea4\u4eba:>----------" + sender);
        String formurl = this.baseHost + "cscec5b-panhuo-frontend/#/sellOrder/details?id=" + orderEntity.getId() + "&type=2";
        String mobileUrl = this.wjyPath + "cscec5b-panhuo-mobile/#/buyOrder/card?id=" + orderEntity.getId() + "&userid={userid}";
        String subject = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getBillCode() + "\u3011\u5356\u5bb6\u5df2\u786e\u8ba4\uff0c\u4ea4\u6613\u5b8c\u6210";
        String content = "\u3010\u8d44\u4ea7\u76d8\u6d3b\u3011\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getBillCode() + "\u3011\u5356\u5bb6\u5df2\u786e\u8ba4\uff0c\u4ea4\u6613\u5b8c\u6210\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        this.sendMsg(messageType, sender, "notice", subject, content, mobileUrl);
        this.goodsService.saveOrUpdate((Object)goodsEntity, false);
        orderEntity.setConfirmer(vo.getConfirmer());
        orderEntity.setConfirmName(vo.getConfirmName());
        orderEntity.setPrice(vo.getPrice());
        orderEntity.setNums(vo.getNums());
        orderEntity.setMny(vo.getMny());
        orderEntity.setTaxMny(vo.getTaxMny());
        orderEntity.setTaxOrderMny(vo.getTaxOrderMny());
        orderEntity.setMemo(vo.getMemo());
        orderEntity.setDealrTime(DateFormater.getCurrentDate());
        orderEntity.setType(1);
        super.saveOrUpdate((Object)orderEntity, false);
        return "success";
    }

    @Override
    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String url) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("wjy")) {
            channel.add("wjy");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("wjy")) {
            JSONObject wjyMsgParams = new JSONObject();
            wjyMsgParams.put("appid", (Object)this.appid);
            wjyMsgParams.put("from", (Object)"\u4e94\u5c40\u8f7b\u91cf\u5316\u5e73\u53f0");
            wjyMsgParams.put("msg", (Object)subject);
            wjyMsgParams.put("url", (Object)url);
            parameter.setWjyMsgParams(wjyMsgParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @Override
    public List<OrderVO> getAllots(String orgId, String beginDate, String endDate) {
        return ((OrderMapper)this.baseMapper).getAllots(orgId, beginDate, endDate);
    }

    @Override
    public String getAllotMaxDate(String orgId) {
        return ((OrderMapper)this.baseMapper).getAllotMaxDate(orgId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean syncInstore(String lastUpdateTime) {
        this.logger.info("\u540c\u6b65NC\u5165\u5e93\u5355\u5f00\u59cb=====");
        if (StringUtils.isEmpty((CharSequence)lastUpdateTime)) {
            lastUpdateTime = DateUtil.format((Date)DateUtils.addDays((Date)new Date(), (int)-1), (String)"yyyy-MM-dd");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(1);
        typeList.add(2);
        CommonResponse listCommonResponse = this.orgApi.findOrgByType(tenantId, typeList, "");
        if (!listCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)listCommonResponse.getData();
        if (orgVOList != null && orgVOList.size() > 0) {
            for (OrgVO orgVO : orgVOList) {
                String url1 = this.syncAddr + "/grn/list?ts=" + lastUpdateTime + "&pk_corp=" + orgVO.getSourceId();
                String strResult = HttpClientUtils.getInstance().getSync(url1);
                this.logger.info(strResult);
                if (StringUtils.isEmpty((CharSequence)strResult)) {
                    return false;
                }
                JSONArray jsonArray = (JSONArray)JSONObject.parseObject((String)strResult).get((Object)"body");
                List syncList = null;
                if (jsonArray != null && jsonArray.size() > 0) {
                    syncList = jsonArray.toJavaList(InstoreEntity.class);
                }
                if (syncList == null || syncList.size() <= 0) {
                    this.logger.info(orgVO.getId() + orgVO.getName() + "\u672c\u6b21\u540c\u6b65\u5165\u5e93\u5355\u4e2a\u6570\u4e3a0\uff0c\u540c\u6b65\u7ed3\u675f");
                    continue;
                }
                for (InstoreEntity instoreEntity : syncList) {
                    instoreEntity.setPkOrg(String.valueOf(orgVO.getId()));
                }
                boolean flag = this.syncInstoreService.saveOrUpdateBatch(syncList);
                this.logger.info(orgVO.getId() + orgVO.getName() + "\u672c\u6b21\u540c\u6b65\u5165\u5e93\u5355\u4e2a\u6570\u4e3a" + syncList.size() + "\uff0c\u6570\u636e\u540c\u6b65\u7ed3\u675f\uff0c\u6570\u636e\u540c\u6b65\u7ed3\u679c\uff1a" + (flag ? "\u6210\u529f" : "\u5931\u8d25"));
            }
        }
        this.syncInstoreMapper.truncateInstoreHZ();
        this.syncInstoreMapper.insertInstoreHZ();
        this.logger.info("\u540c\u6b65NC\u5165\u5e93\u5355\u7ed3\u675f=====");
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateSyncInstore() {
        this.logger.info("\u66f4\u65b0\u540c\u6b65NC\u5165\u5e93\u5355\u5f00\u59cb=====");
        QueryParam queryParam = new QueryParam();
        List instoreHzEntityList = this.instoreHzService.queryList(queryParam);
        for (InstoreHzEntity instoreHzEntity : instoreHzEntityList) {
            CommonResponse res;
            CommonResponse orgVOCommonResponse;
            instoreHzEntity.setTenantId(999999L);
            instoreHzEntity.setCreateTime(new Date());
            String orgId = instoreHzEntity.getPkOrg();
            String projectId = instoreHzEntity.getPkProject();
            String materialId = instoreHzEntity.getPkMaterial();
            CommonResponse matRes = this.materialApi.queryMaterialBySourceId(materialId);
            if (matRes.isSuccess()) {
                MaterialVO materialVO = (MaterialVO)matRes.getData();
                instoreHzEntity.setCode(materialVO.getCode());
                instoreHzEntity.setName(materialVO.getName());
                instoreHzEntity.setTypeId(String.valueOf(materialVO.getCategoryId()));
                instoreHzEntity.setType(materialVO.getCategoryName());
                instoreHzEntity.setUnitName(materialVO.getUnitName());
                instoreHzEntity.setSpec(materialVO.getSpec());
                instoreHzEntity.setMeasname(materialVO.getCategoryName());
                instoreHzEntity.setPkMaterial(String.valueOf(materialVO.getId()));
            }
            if ((orgVOCommonResponse = this.orgApi.getOneById(Long.valueOf(orgId))).isSuccess()) {
                OrgVO orgVO = (OrgVO)orgVOCommonResponse.getData();
                instoreHzEntity.setOrgName(orgVO.getName());
            }
            if (StringUtils.isEmpty((CharSequence)projectId) || !(res = this.projectApi.queryProjectBySourceId(projectId)).isSuccess()) continue;
            instoreHzEntity.setPkProject(String.valueOf(((ProjectRegisterVO)res.getData()).getId()));
            instoreHzEntity.setVprojectname(((ProjectRegisterVO)res.getData()).getName());
        }
        if (CollectionUtils.isNotEmpty((Collection)instoreHzEntityList)) {
            this.instoreHzService.saveOrUpdateBatch(instoreHzEntityList);
        }
        this.logger.info("\u66f4\u65b0\u540c\u6b65NC\u5165\u5e93\u5355\u7ed3\u675f=====");
        return true;
    }

    @Override
    public Integer closeOrderDate() {
        Map warningParameterVOMap;
        int hour = 0;
        CommonResponse warningVOCommonResponse = this.warningApi.getWarningByCode("WARNING000044");
        if (warningVOCommonResponse.getCode() == 0 && null != warningVOCommonResponse.getData() && CollectionUtils.isNotEmpty((Collection)((WarningVO)warningVOCommonResponse.getData()).getWarningParameterList()) && (warningParameterVOMap = ((WarningVO)warningVOCommonResponse.getData()).getWarningParameterList().stream().collect(Collectors.toMap(x -> x.getParameterName(), Function.identity(), (k1, k2) -> k2))).containsKey("parameters")) {
            WarningParameterVO warningParameterVO = (WarningParameterVO)warningParameterVOMap.get("parameters");
            hour = Integer.parseInt(warningParameterVO.getParameterValue() == null ? "0" : warningParameterVO.getParameterValue());
        }
        return hour;
    }

    @Override
    public ApplyVO pushOpApply(List<Long> ids) {
        List entities = (List)this.listByIds(ids);
        OrderEntity orderEntity = (OrderEntity)((Object)entities.get(0));
        Long projectId = orderEntity.getSellProject();
        ApplyVO applyVO = new ApplyVO();
        applyVO.setProjectId(projectId);
        applyVO.setOrgId(orderEntity.getSellOrg());
        applyVO.setOrgName(orderEntity.getSellOrgName());
        applyVO.setParentOrgId(orderEntity.getParentSellOrg());
        applyVO.setProjectName(orderEntity.getSellProjectName());
        applyVO.setOutDate(new Date());
        applyVO.setTel(orderEntity.getSellPhone());
        applyVO.setLinkUrlPc("http://wei.cscec5b.com.cn:9080/cscec5b-panhuo-frontend/#/sellOrder");
        applyVO.setLinkUrlMobile("https://wjqlh.17elian.com/cscec5b-panhuo-mobile/#/sellerManage");
        ArrayList<ApplyDetailVO> detailList = new ArrayList<ApplyDetailVO>();
        ArrayList<String> result = new ArrayList<String>();
        for (OrderEntity order : entities) {
            if (!projectId.equals(order.getSellProject())) {
                throw new BusinessException("\u4e0d\u540c\u9879\u76ee\u4e0d\u5141\u8bb8\u540c\u65f6\u751f\u6210\u51fa\u95e8\u8bc1");
            }
            ApplyDetailVO detailVO = new ApplyDetailVO();
            detailVO.setCode(order.getMaterialCode());
            detailVO.setName(order.getMaterialName());
            detailVO.setSpec(order.getSpec());
            detailVO.setUnit(order.getUnit());
            detailVO.setNum(order.getNums());
            detailVO.setReason("\u8d44\u4ea7\u76d8\u6d3b\u8ba2\u5355");
            detailList.add(detailVO);
            result.add(String.valueOf(order.getId()));
        }
        applyVO.setSourceId(StringUtils.join(result, (String)"@"));
        applyVO.setSourceType("BT211111000000003");
        applyVO.setSourceTypeName("\u8d44\u4ea7\u76d8\u6d3b\u8ba2\u5355");
        applyVO.setDetailList(detailList);
        CommonResponse response = this.applyApi.push(applyVO);
        if (response.isSuccess() && null != response.getData()) {
            return (ApplyVO)response.getData();
        }
        this.logger.error(JSONObject.toJSONString((Object)response));
        throw new BusinessException(response.getMsg());
    }
}

