/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.mapper.RecommendAnaMapper;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IRecommendAnaService;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="recommendAnaService")
public class RecommendAnaServiceImpl
extends BaseServiceImpl<RecommendAnaMapper, GoodsEntity>
implements IRecommendAnaService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ILabeldetailService labeldetailService;
    @Autowired
    private ICollectService collectService;
    @Autowired
    private IProjectApi projectApi;

    @Override
    public ReportVO recommendAnaIndex(Long orgId, String startTime, String endTime) {
        CommonResponse orgListResp;
        ArrayList<Long> commonOrgIds = new ArrayList<Long>();
        if (null == orgId || orgId <= 0L) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (!(orgListResp = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ReportVO resVO = new ReportVO();
        ReportVO pronumsVo = ((RecommendAnaMapper)this.baseMapper).getPronums(InvocationInfoProxy.getTenantid(), commonOrgIds, startTime, endTime);
        if (null != pronumsVo) {
            resVO.setProNums(pronumsVo.getProNums() == null ? BigDecimal.ZERO : pronumsVo.getProNums());
        } else {
            resVO.setProNums(BigDecimal.ZERO);
        }
        return this.goodsIndex(resVO, commonOrgIds, startTime, endTime);
    }

    public ReportVO goodsIndex(ReportVO resVO, List<Long> commonOrgIds, String startTime, String endTime) {
        ReportVO goodsNumsIngVo;
        ReportVO goodsNumsVo = ((RecommendAnaMapper)this.baseMapper).getGoodsnums(InvocationInfoProxy.getTenantid(), commonOrgIds, startTime, endTime);
        if (null != goodsNumsVo) {
            resVO.setGoodsNums(goodsNumsVo.getGoodsNums() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsNums());
            resVO.setGoodsAmount(goodsNumsVo.getGoodsAmount() == null ? BigDecimal.ZERO : goodsNumsVo.getGoodsAmount());
            if (null != goodsNumsVo.getShelfTime()) {
                int days = (int)((new Date().getTime() - goodsNumsVo.getShelfTime().getTime()) / 86400000L);
                resVO.setDays(days);
            }
        } else {
            resVO.setGoodsNums(BigDecimal.ZERO);
            resVO.setGoodsAmount(BigDecimal.ZERO);
            resVO.setDays(0);
        }
        if (null != (goodsNumsIngVo = ((RecommendAnaMapper)this.baseMapper).getGoodsnumsIng(InvocationInfoProxy.getTenantid(), commonOrgIds, startTime, endTime))) {
            resVO.setShelfNums(goodsNumsIngVo.getShelfNums() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfNums());
            resVO.setShelfAmount(goodsNumsIngVo.getShelfAmount() == null ? BigDecimal.ZERO : goodsNumsIngVo.getShelfAmount());
        } else {
            resVO.setShelfNums(BigDecimal.ZERO);
            resVO.setShelfAmount(BigDecimal.ZERO);
        }
        ReportVO OrdernumsVo = ((RecommendAnaMapper)this.baseMapper).getOrdernums(InvocationInfoProxy.getTenantid(), commonOrgIds, startTime, endTime);
        if (null != OrdernumsVo) {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        } else {
            resVO.setOrderNums(OrdernumsVo.getOrderNums() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderNums());
            resVO.setOrderAmount(OrdernumsVo.getOrderAmount() == null ? BigDecimal.ZERO : OrdernumsVo.getOrderAmount());
        }
        return resVO;
    }

    @Override
    public List<ReportVO> recommendAnaProj(Page<ReportVO> page, QueryWrapper queryWrapper, String startTime, String endTime) {
        ArrayList<ReportVO> res = new ArrayList<ReportVO>();
        List<ReportVO> projIndexs = ((RecommendAnaMapper)this.baseMapper).getProjProdNums(page, queryWrapper, startTime, endTime);
        if (CollectionUtils.isNotEmpty(projIndexs)) {
            projIndexs.forEach(e -> {
                ArrayList<Long> commonOrgIds = new ArrayList<Long>();
                commonOrgIds.add(e.getBuyOrg());
                ReportVO vo = this.goodsIndex((ReportVO)e, (List<Long>)commonOrgIds, startTime, endTime);
                res.add(vo);
            });
        }
        return res;
    }
}

