/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.ShoppingCartEntity;
import com.ejianc.business.panhuo.mapper.ShoppingCartMapper;
import com.ejianc.business.panhuo.service.IConfigService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IShoppingCartService;
import com.ejianc.business.panhuo.vo.ShoppingCartVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shoppingCartService")
public class ShoppingCartServiceImpl
extends BaseServiceImpl<ShoppingCartMapper, ShoppingCartEntity>
implements IShoppingCartService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "CSCEC5B_PANHUO_DD";
    @Autowired
    private IConfigService configService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IGoodsService goodsService;

    @Override
    public ShoppingCartVO saveShoppingCart(ShoppingCartVO vo) {
        String sellConfigOrgId;
        OrgVO orgVO;
        CommonResponse commonResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        GoodsEntity goodsEntity = (GoodsEntity)((Object)this.goodsService.selectById(vo.getGoodsId()));
        if (!goodsEntity.getVersion().equals(vo.getVersion())) {
            throw new BusinessException("\u60a8\u64cd\u4f5c\u7684\u9875\u9762\u5df2\u88ab\u5176\u4ed6\u540c\u4e8b\u4fee\u6539,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5!");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ShoppingCartEntity::getUserId, (Object)InvocationInfoProxy.getUserid());
        queryWrapper.eq(ShoppingCartEntity::getBuyOrg, (Object)vo.getBuyOrg());
        queryWrapper.eq(ShoppingCartEntity::getGoodsId, (Object)vo.getGoodsId());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u5546\u54c1\u5df2\u6dfb\u52a0\u8fc7\u8d2d\u7269\u8f66\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0!");
        }
        ShoppingCartEntity cartEntity = (ShoppingCartEntity)((Object)BeanMapper.map((Object)((Object)vo), ShoppingCartEntity.class));
        cartEntity.setToolId(goodsEntity.getToolId());
        cartEntity.setShelfType(goodsEntity.getShelfType());
        cartEntity.setShelfTime(goodsEntity.getShelfTime());
        cartEntity.setTenantId(tenantId);
        cartEntity.setMaterialCode(goodsEntity.getMaterialCode());
        cartEntity.setMaterialId(goodsEntity.getMaterialId());
        cartEntity.setMaterialName(goodsEntity.getMaterialName());
        cartEntity.setMaterialTypeId(goodsEntity.getMaterialTypeId());
        cartEntity.setMaterialTypeName(goodsEntity.getMaterialTypeName());
        cartEntity.setSystemId(goodsEntity.getSystemId());
        cartEntity.setSourceId(goodsEntity.getSourceId());
        cartEntity.setSpec(goodsEntity.getSpec());
        cartEntity.setMainimgPath(goodsEntity.getMainimgPath());
        cartEntity.setUnit(goodsEntity.getUnit());
        cartEntity.setType(0);
        cartEntity.setIsPack(goodsEntity.getIsPack());
        cartEntity.setSeller(goodsEntity.getSeller());
        cartEntity.setSellerName(goodsEntity.getSellerName());
        cartEntity.setSellAddress(goodsEntity.getAddress());
        cartEntity.setSellAddressId(goodsEntity.getAddressId());
        cartEntity.setSellOrg(goodsEntity.getOrgId());
        cartEntity.setSellOrgName(goodsEntity.getOrgName());
        cartEntity.setSellProject(goodsEntity.getProjectId());
        cartEntity.setSellProjectName(goodsEntity.getProjectName());
        cartEntity.setSellPhone(goodsEntity.getPhone());
        cartEntity.setSellUserName(goodsEntity.getName());
        cartEntity.setBuyTime(DateFormater.getCurrentDate());
        cartEntity.setMny(vo.getOrdermny() == null ? BigDecimal.ZERO : vo.getOrdermny());
        cartEntity.setPrice(vo.getOrderprice() == null ? BigDecimal.ZERO : vo.getOrderprice());
        cartEntity.setNums(vo.getOrdernums() == null ? BigDecimal.ZERO : vo.getOrdernums());
        cartEntity.setOriginalprice(goodsEntity.getOriginalprice());
        cartEntity.setDiscount(goodsEntity.getDiscount());
        cartEntity.setUserId(InvocationInfoProxy.getUserid());
        if (null != cartEntity.getSellOrg() && cartEntity.getSellOrg() > 0L && (commonResponse = this.orgApi.getOneById(cartEntity.getSellOrg())).isSuccess()) {
            orgVO = (OrgVO)commonResponse.getData();
            cartEntity.setParentSellOrg(orgVO.getParentId());
        }
        if (null != cartEntity.getBuyOrg() && cartEntity.getBuyOrg() > 0L && (commonResponse = this.orgApi.getOneById(cartEntity.getBuyOrg())).isSuccess()) {
            orgVO = (OrgVO)commonResponse.getData();
            cartEntity.setParentBuyOrg(orgVO.getParentId());
        }
        if (StringUtils.isEmpty((CharSequence)(sellConfigOrgId = this.configService.queryConfigOrgByOrgId(cartEntity.getSellOrg())))) {
            throw new BusinessException("\u51fa\u552e\u65b9\u672a\u8bbe\u7f6e\u8c03\u62e8\u7ba1\u7406\u7ec4\u7ec7!");
        }
        String buyConfigOrgId = this.configService.queryConfigOrgByOrgId(cartEntity.getBuyOrg());
        if (StringUtils.isEmpty((CharSequence)buyConfigOrgId)) {
            throw new BusinessException("\u8d2d\u4e70\u65b9\u672a\u8bbe\u7f6e\u8c03\u62e8\u7ba1\u7406\u7ec4\u7ec7!");
        }
        if (!sellConfigOrgId.equals(buyConfigOrgId)) {
            throw new BusinessException("\u8c03\u62e8\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5339\u914d!");
        }
        if (null != vo && StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                cartEntity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)cartEntity, false);
        return (ShoppingCartVO)((Object)BeanMapper.map((Object)((Object)cartEntity), ShoppingCartVO.class));
    }
}

