/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CategoryEntity;
import com.ejianc.business.panhuo.bean.LabeldetailEntity;
import com.ejianc.business.panhuo.bean.WbuyEntity;
import com.ejianc.business.panhuo.mapper.WbuyMapper;
import com.ejianc.business.panhuo.service.ICategoryService;
import com.ejianc.business.panhuo.service.ILabeldetailService;
import com.ejianc.business.panhuo.service.IWbuyService;
import com.ejianc.business.panhuo.vo.WbuyVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wbuyService")
public class WbuyServiceImpl
extends BaseServiceImpl<WbuyMapper, WbuyEntity>
implements IWbuyService {
    private static final String CSCEC5B_PANHUO_QG = "CSCEC5B_PANHUO_QG";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICategoryService categoryService;
    @Autowired
    private ILabeldetailService labeldetailService;

    @Override
    public WbuyVO saveWbuy(WbuyVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        WbuyEntity entity = (WbuyEntity)((Object)BeanMapper.map((Object)vo, WbuyEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(CSCEC5B_PANHUO_QG, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != vo.getId() && vo.getId() > 0L) {
            List<LabeldetailEntity> listlb = entity.getLabels();
            QueryWrapper labekWrapper = new QueryWrapper();
            labekWrapper.eq((Object)"source_id", (Object)vo.getId());
            this.labeldetailService.remove((Wrapper)labekWrapper);
            if (CollectionUtils.isNotEmpty(listlb)) {
                listlb.forEach(e -> e.setId(null));
            }
        }
        entity.setBuyTime(DateFormater.getCurrentDate());
        super.saveOrUpdate((Object)entity, false);
        WbuyVO resvo = (WbuyVO)BeanMapper.map((Object)((Object)entity), WbuyVO.class);
        return resvo;
    }

    @Override
    public List<WbuyEntity> queryWbuy(Page pages, QueryWrapper queryWrapper, String lon, String lat) {
        return ((WbuyMapper)this.baseMapper).getWbuy(pages, queryWrapper, lon, lat);
    }

    @Override
    public List<Long> queryCtyIdsByOrgs(List<Long> orgIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WbuyEntity::getBuyer, (Object)InvocationInfoProxy.getUserid());
        queryWrapper.eq(WbuyEntity::getStatus, (Object)0);
        queryWrapper.in(WbuyEntity::getOrgId, orgIds);
        List wbuyEntities = this.list((Wrapper)queryWrapper);
        List idList = wbuyEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper ctyQuery = new LambdaQueryWrapper();
        ctyQuery.in(CategoryEntity::getWbuyId, idList);
        List categoryEntities = this.categoryService.list((Wrapper)ctyQuery);
        List<Long> categoryList = categoryEntities.stream().map(CategoryEntity::getMaterialTypeId).collect(Collectors.toList());
        return categoryList;
    }
}

