package com.ejianc.business.storecloud.api;

import com.ejianc.business.storecloud.hystrix.WarehousFlowHystrix;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 推送流水表的rpc服务
 *
 */
@FeignClient(name= "cscec5b-storecloud-web", url="${common.env.feign-client-url}", path="cscec5b-storecloud-web", fallback = WarehousFlowHystrix.class)
public interface IWarehouseFlowApi {


	/**
	 * 推送
	 *
	 * @param flowVOList
	 * @return
	 */
	@PostMapping(value = "api/warehouseFlow/push")
	CommonResponse<String> push(@RequestBody List<WarehouseFlowVO> flowVOList);

	/**
	 * 回退
	 *
	 * @param sourceDetailIds
	 * @return
	 */
	@PostMapping(value = "api/warehouseFlow/rollBack")
	CommonResponse<String> rollBack(@RequestBody List<Long> sourceDetailIds);
}
