package com.ejianc.business.storecloud.api;

import com.ejianc.business.storecloud.hystrix.CloudMeterialHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 查询是否云库存材料服务
 *
 */
@FeignClient(name= "cscec5b-storecloud-web", url="${common.env.feign-client-url}", path="cscec5b-storecloud-web", fallback = CloudMeterialHystrix.class)
public interface ICloudMeterialApi {


	/**
	 * 查询是否是云库存材料
	 *
	 * @param
	 * @return
	 */
	@GetMapping(value = "api/cloudMeterial/queryCloudMeterial")
	CommonResponse<List<Long>> queryCloudMeterial(@RequestParam(value = "materialIds", required = false) List<Long> materialIds, @RequestParam(value = "orgId", required = false) Long orgId);

}
