package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.storecloud.mapper.ConfigProjectMapper;
import com.ejianc.business.storecloud.bean.ConfigProjectEntity;
import com.ejianc.business.storecloud.service.IConfigProjectService;

import java.util.List;

/**
 * 设置表
 * 
 * @author generator
 * 
 */
@Service("configProjectService")
public class ConfigProjectServiceImpl extends BaseServiceImpl<ConfigProjectMapper, ConfigProjectEntity> implements IConfigProjectService{

    @Override
    public ConfigProjectEntity queryConfig(Long orgId) {
        LambdaQueryWrapper<ConfigProjectEntity> queryWrapper = new LambdaQueryWrapper<ConfigProjectEntity>();
        queryWrapper.eq(ConfigProjectEntity::getOrgId, orgId);
        List<ConfigProjectEntity> list = list(queryWrapper);
        if (list.size() >0){
            return list.get(0);
        }else{
            ConfigProjectEntity configProjectEntity = new ConfigProjectEntity();
            configProjectEntity.setParentName("失败");
            return configProjectEntity;
        }
    }
}
