package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.bean.ConfigProjectEntity;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.service.IConfigProjectService;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.vo.MaterialOrgVO;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.storecloud.mapper.MaterialProjectMapper;
import com.ejianc.business.storecloud.bean.MaterialProjectEntity;
import com.ejianc.business.storecloud.service.IMaterialProjectService;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目领料设置-项目(材料表)
 * 
 * @author generator
 * 
 */
@Service("materialProjectService")
public class MaterialProjectServiceImpl extends BaseServiceImpl<MaterialProjectMapper, MaterialProjectEntity> implements IMaterialProjectService{

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConfigProjectService configProjectService;

    @Autowired
    private IMaterialOrgService materialOrgService;



    @Override
    public List<MaterialProjectVO> saveOrUpdate(List<MaterialProjectVO> saveOrUpdateVO) {
        List<MaterialProjectVO> vo = new ArrayList<>();
        for (MaterialProjectVO materialProjectVO : saveOrUpdateVO){
            if (materialProjectVO.getId()!=null){
                LambdaQueryWrapper<MaterialProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(MaterialProjectEntity::getMaterialId,materialProjectVO.getId());
                queryWrapper.eq(MaterialProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
                queryWrapper.eq(MaterialProjectEntity::getDr,0);
                List<MaterialProjectEntity> materialProjectEntityList = super.list(queryWrapper);
                if (CollectionUtils.isNotEmpty(materialProjectEntityList)){
                    throw  new BusinessException("编号为"+materialProjectVO.getCode()+"的"+materialProjectVO.getName()+"已被引用！");
                }
            }
            materialProjectVO.setMaterialId(materialProjectVO.getId());
            materialProjectVO.setMaterialCode(materialProjectVO.getCode());
            materialProjectVO.setMaterialName(materialProjectVO.getName());
            materialProjectVO.setMaterialUnitName(materialProjectVO.getUnitName());
            materialProjectVO.setMaterialSpec(materialProjectVO.getSpec());
            materialProjectVO.setMaterialCategoryId(materialProjectVO.getCategoryId());
            materialProjectVO.setMaterialCategoryName(materialProjectVO.getCategoryName());
            materialProjectVO.setMaterialCategoryCode(materialProjectVO.getCategoryCode());
            materialProjectVO.setOrgId(InvocationInfoProxy.getOrgId());

            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(materialProjectVO.getOrgId());
            materialProjectVO.setOrgCode(orgVo.getData().getCode());
            materialProjectVO.setOrgName(orgVo.getData().getName());
            MaterialProjectEntity entity = BeanMapper.map(materialProjectVO, MaterialProjectEntity.class);
            entity.setId(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setTenantId(null);
            super.saveOrUpdate(entity, false);
            vo.add(BeanMapper.map(entity, MaterialProjectVO.class));
        }
        return vo;
    }

    @Override
    public int synchronization() {
        //查询配置表信息
        ConfigProjectEntity configProjectEntity = configProjectService.queryConfig(InvocationInfoProxy.getOrgId());
        String innerCode = configProjectEntity.getParentInnerCode();
        String[] strs = innerCode.split("\\|");
        List<Long> childIds = new ArrayList<>();
        for(String id:strs){
            childIds.add(Long.parseLong(id));
        }
        //根据orgId查询公司设置云库存材料
        LambdaQueryWrapper<MaterialOrgEntity> queryWrapper = new LambdaQueryWrapper<MaterialOrgEntity>();
        queryWrapper.in(MaterialOrgEntity::getOrgId,childIds);
        List<MaterialOrgEntity> materialOrgEntityList = materialOrgService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(materialOrgEntityList)) {
           for(MaterialOrgEntity materialOrgEntity:materialOrgEntityList){
               MaterialProjectEntity materialProjectEntity = new MaterialProjectEntity();
               materialProjectEntity.setMaterialId(materialOrgEntity.getMaterialId());
               materialProjectEntity.setMaterialCode(materialOrgEntity.getMaterialCode());
               materialProjectEntity.setMaterialName(materialOrgEntity.getMaterialName());
               materialProjectEntity.setMaterialSpec(materialOrgEntity.getSpec());
               materialProjectEntity.setMaterialUnitName(materialOrgEntity.getUnit());
               materialProjectEntity.setMaterialCategoryId(materialOrgEntity.getCategoryId());
               materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
               materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
               materialProjectEntity.setOrgId(InvocationInfoProxy.getOrgId());//存当前组织id
               CommonResponse<List<OrgVO>> parentOrgList =iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
               materialProjectEntity.setOrgCode(parentOrgList.getData().get(0).getCode());
               materialProjectEntity.setParentId(parentOrgList.getData().get(0).getParentId());
               if (materialOrgEntity.getMaterialId()!=null){
                   LambdaQueryWrapper<MaterialProjectEntity> queryWrappers = new LambdaQueryWrapper<>();
                   queryWrappers.eq(MaterialProjectEntity::getMaterialId,materialOrgEntity.getMaterialId());
                   queryWrappers.eq(MaterialProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
                   queryWrappers.eq(MaterialProjectEntity::getDr,0);
                   List<MaterialProjectEntity> materialProjectEntityList = super.list(queryWrappers);
                   if (CollectionUtils.isNotEmpty(materialProjectEntityList)){
                       //如果引入过了 直接跳过
                       continue;
                   }
               }
               saveOrUpdate(materialProjectEntity);
           }
           //同步成功修改配置表，已经同步
            LambdaUpdateWrapper<ConfigProjectEntity> updateWrapper=new LambdaUpdateWrapper<ConfigProjectEntity>();
            updateWrapper.set(ConfigProjectEntity::getInitializeEnabled,1);
            updateWrapper.eq(ConfigProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
            boolean flag = configProjectService.update(updateWrapper);
            if(!flag){
                throw new BusinessException("设置状态更新失败！");
            }
        }else{
            return 1;//失败
        }
        return 0;//成功
    }
}
