package com.ejianc.business.sync.api;

import com.ejianc.business.sync.hystrix.GrapSyncHystrix;
import com.ejianc.business.sync.vo.SumGrapVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "cscec5b-sync-web", url="${common.env.feign-client-url}", path="cscec5b-sync-web", fallback = GrapSyncHystrix.class)
public interface IGrapSyncApi {

	/**
	 * 进度计量同步至nc中间表
	 * @param sumGrapVO	进度台账VO
	 * @return
	 */
	@PostMapping(value = "/api/grapsync/syncImg")
	public CommonResponse<String> syncImg(@RequestBody SumGrapVO sumGrapVO);

	/**
	 * 删除NC中间表
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/grapsync/delSyncImg")
	public CommonResponse<String> delSyncImg(@RequestParam("id") Long id);

	/**
	 * 查看数据有没有被同步
	 * @param id
	 * @return
	 */
	@GetMapping(value = "/api/grapsync/getSyncImg")
	public CommonResponse<Integer> getSyncImg(@RequestParam("id") Long id);

	/**
	 * 查询所有形象进度
	 * @param
	 * @return
	 */
	@GetMapping(value = "/api/grapsync/getSyncImgList")
	public CommonResponse<List> getSyncImgList();

	/**
	 * 查询进度计量对应NC结算状态
	 * @param	day
	 * @return
	 */
	@GetMapping(value = "/api/grapsync/selectStatus")
	public CommonResponse<List> selectStatus(@RequestParam("day") Integer day);

}
