package com.ejianc.business.sync.controller.api;

import com.ejianc.business.sync.service.ICalculateService;
import com.ejianc.business.sync.vo.CalculateVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping("/api/calcsync")
public class CalculateSyncController implements Serializable {
    private static final long serialVersionUID = 1L;

    @Autowired
    private ICalculateService calculateService;

    /**
     * 同步至nc中间表
     * @param calculateVOList
     * @return
     */
    @RequestMapping(value = "/sync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> sync(@RequestBody List<CalculateVO> calculateVOList) {
        return calculateService.sync(calculateVOList);
    }

    /**
     * 删除NC中间表
     * @param id
     * @return
     */
    @RequestMapping(value = "/delSync", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delSync(@RequestParam("id") Long id) {
        return calculateService.delSync(id);
    }

    /**
     * 结算标识查询
     * @param ts
     * @return
     */
    @RequestMapping(value = "/settleFlagSync", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CalculateVO>> settleFlagSync(@RequestParam(value = "ts", required = false) String ts, @RequestParam(value = "id", required = false) Long id) {
        return calculateService.settleFlagSync(ts, id);
    }
}
