package com.ejianc.business.sync.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sync.bean.Calculate;
import com.ejianc.business.sync.bean.CalculateDetail;
import com.ejianc.business.sync.bean.CalculateSettle;
import com.ejianc.business.sync.mapper.CalculateMapper;
import com.ejianc.business.sync.service.ICalculateDetailService;
import com.ejianc.business.sync.service.ICalculateService;
import com.ejianc.business.sync.service.ICalculateSettleService;
import com.ejianc.business.sync.vo.CalculateDetailVO;
import com.ejianc.business.sync.vo.CalculateSettleVO;
import com.ejianc.business.sync.vo.CalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Service("calculateService")
public class CalculateService extends BaseServiceImpl<CalculateMapper, Calculate> implements ICalculateService {
    private Logger logger = LoggerFactory.getLogger(CalculateService.class);

    @Autowired
    private ICalculateSettleService calculateSettleService;
    @Autowired
    private ICalculateDetailService calculateDetailService;


    @Override
    public CommonResponse<String> sync(List<CalculateVO> calculateVOList) {
        saveBatch(BeanMapper.mapList(calculateVOList, Calculate.class));
        List<CalculateSettleVO> settleList = new ArrayList<>();
        List<CalculateDetailVO> detailList = new ArrayList<>();
        for(CalculateVO calculateVO : calculateVOList){
            settleList.addAll(calculateVO.getSettleList());
            detailList.addAll(calculateVO.getDetailList());
        }
        calculateSettleService.saveBatch(BeanMapper.mapList(settleList, CalculateSettle.class));
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.sort(Comparator.comparingInt(CalculateDetailVO::getSequence));
        }
        calculateDetailService.saveBatch(BeanMapper.mapList(detailList, CalculateDetail.class));
        return CommonResponse.success("同步成功！");
    }

    @Override
    public CommonResponse<String> delSync(Long id) {
        LambdaQueryWrapper<Calculate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(Calculate::getNflag, 1);
        queryWrapper.likeRight(Calculate::getPkId, id);
        if(count(queryWrapper) > 0){
           return CommonResponse.error("该单据被NC引用，不能撤回！");
        }

        LambdaUpdateWrapper<Calculate> deleteWrapper = new LambdaUpdateWrapper<>();
        deleteWrapper.likeRight(Calculate::getPkId, id);
        remove(deleteWrapper);

        LambdaUpdateWrapper<CalculateSettle> settleDeleteWrapper = new LambdaUpdateWrapper<>();
        settleDeleteWrapper.likeRight(CalculateSettle::getPkId, id);
        calculateSettleService.remove(settleDeleteWrapper);

        LambdaUpdateWrapper<CalculateDetail> detailDeleteWrapper = new LambdaUpdateWrapper<>();
        detailDeleteWrapper.likeRight(CalculateDetail::getPkId, id);
        calculateDetailService.remove(detailDeleteWrapper);

        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<List<CalculateVO>> settleFlagSync(String ts, Long id) {
        LambdaQueryWrapper<Calculate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.ge(StringUtils.isNotBlank(ts), Calculate::getTs, ts);
        queryWrapper.likeRight(null != id, Calculate::getPkId, id);
        List<Calculate> list = list(queryWrapper);
        return CommonResponse.success("结算标识查询！", CollectionUtils.isNotEmpty(list) ? BeanMapper.mapList(list, CalculateVO.class) : null);
    }

}
