package com.ejianc.business.sync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.sync.bean.GrapCut;
import com.ejianc.business.sync.bean.Imgprog;
import com.ejianc.business.sync.bean.Imgprogb;
import com.ejianc.business.sync.cons.ModelCodeCons;
import com.ejianc.business.sync.mapper.ImgprogMapper;
import com.ejianc.business.sync.service.IGrapCutService;
import com.ejianc.business.sync.service.IImgprogService;
import com.ejianc.business.sync.service.IImgprogbService;
import com.ejianc.business.sync.vo.GrapCutVO;
import com.ejianc.business.sync.vo.SumGrapDetailVO;
import com.ejianc.business.sync.vo.SumGrapVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("imgprogService")
public class ImgprogService extends BaseServiceImpl<ImgprogMapper, Imgprog> implements IImgprogService {
    private Logger logger = LoggerFactory.getLogger(ImgprogService.class);

    @Autowired
    private IImgprogbService imgprogbService;
    @Autowired
    private IGrapCutService grapCutService;

    @Autowired
    private IUserApi userApi;

    @Override
    public CommonResponse<String> syncImg(SumGrapVO sumGrapVO) {
        Long id = sumGrapVO.getId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String ts = sdf.format(new Date());
        // 形象进度主表
        Imgprog entity = new Imgprog();
        entity.setPkImgprog(ModelCodeCons.NC_JD + id);
        entity.setCsrcId(ModelCodeCons.NC_JD + id);
        entity.setvBillCode(sumGrapVO.getBillCode());
        entity.setPkProject(sumGrapVO.getProjectSourceId());
        entity.setPkCorp(sumGrapVO.getCropSourceId());
        entity.setPkContract(sumGrapVO.getContractId());
        entity.setPeriod(sumGrapVO.getSumMonth());
        entity.setReportPerson(this.getUserSourceId());// 用户来源ID;
        entity.setnConfirmMny(sumGrapVO.getSumApproveMny());
        entity.setBisSettle("N");
        entity.setCsrcbId("");
        entity.setTs(ts);
        // 形象进度子表
        List<SumGrapDetailVO> detailList = sumGrapVO.getDetailList();
        List<Imgprogb> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            for(SumGrapDetailVO detai : detailList){
                if(detai.getLeafFlag() == 0){
                    Imgprogb vo = new Imgprogb();
                    vo.setPkImgprogb(ModelCodeCons.NC_JD + detai.getId());
                    vo.setCsrcbId(ModelCodeCons.NC_JD + detai.getId());
                    vo.setPkImgprog(ModelCodeCons.NC_JD + id);
                    vo.setCsrcId(ModelCodeCons.NC_JD + id);
                    vo.setPkSublist(detai.getInfoId());
                    vo.setNthisfinishnum(detai.getApproveNum());
                    vo.setNthisfinishoriginmny(detai.getApproveMny());
                    vo.setNprice(detai.getPrice());
                    vo.setConstruction(detai.getConstruction());
                    vo.setBisSettle("N");
                    vo.setTs(ts);
                    list.add(vo);
                }
            }
        }
        // 扣款子表
        List<GrapCutVO> cutDetailList = sumGrapVO.getCutDetailList();
        List<GrapCut> grapCuts = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(cutDetailList)) {
            for (GrapCutVO detail : cutDetailList) {
                GrapCut vo = new GrapCut();
                vo.setPkGratCutB(ModelCodeCons.NC_JD + detail.getId());
                vo.setCsrcbId(ModelCodeCons.NC_JD + detail.getId());
                vo.setPkImgprog(ModelCodeCons.NC_JD + id);
                vo.setCsrcId(ModelCodeCons.NC_JD + id);
                vo.setPkFee(detail.getFeeId());
                vo.setFeeCode(detail.getFeeCode());
                vo.setFeeName(detail.getFeeName());
                vo.setCutDate(new SimpleDateFormat("yyyy-MM-dd").format(detail.getCutDate()));
                vo.setCutMny(detail.getCutMny());
                if(StringUtils.isNotEmpty(detail.getMemo())){
                    vo.setMemo(detail.getMemo());
                }
                vo.setTs(ts);
                vo.setBisSettle("N");
                grapCuts.add(vo);
            }
        }
        entity.setDetailList(list);
        entity.setCutDetailList(grapCuts);
        try {
            logger.info("imgprog插入准备数据:" + JSONObject.toJSONString(entity));
            baseMapper.insertImgprog(entity);
            logger.info("imgprog插入完毕:" + JSONObject.toJSONString(list));
            if(CollectionUtils.isNotEmpty(list)){
                for(Imgprogb imgprogb : list){
                    imgprogbService.batchInsert(imgprogb);
                }
            }
            logger.info("grapCut插入完毕:" + JSONObject.toJSONString(grapCuts));
            if(CollectionUtils.isNotEmpty(grapCuts)){
                for(GrapCut grapCut : grapCuts){
                    grapCutService.batchInsert(grapCut);
                }
            }
        } catch (Exception e) {
            logger.error(e.toString());
            return CommonResponse.error("形象进度、扣款项插入NC库失败");
        }
        return CommonResponse.success("同步成功！");
    }

    @Override
    public CommonResponse<String> delSyncImg(Long id) {
        baseMapper.delSyncImg(ModelCodeCons.NC_JD + id);
        baseMapper.delSyncImgB(ModelCodeCons.NC_JD + id);
        baseMapper.delSyncGrapCut(ModelCodeCons.NC_JD + id);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public List selectStatus(Integer day) {
        return baseMapper.selectStatus(day);
    }

    @Override
    public List getSyncImgList() {
        return baseMapper.getSyncImgList();
    }

    /**
     * 查看数据有没有被同步
     * @param id
     * @return
     */
    @Override
    public Integer getSyncImg(Long id) {
        return baseMapper.getSyncImg(ModelCodeCons.NC_JD + id);
    }

    /**
     * 获取登录用户sourceId
     * @return
     */
    private String getUserSourceId() {
        CommonResponse<List<UserVO>> res = userApi.queryListByIds(new String[]{String.valueOf(InvocationInfoProxy.getUserid())});
        if(!res.isSuccess()){
            throw new BusinessException("查询用户失败！");
        }
        if(CollectionUtils.isNotEmpty(res.getData())){
            UserVO vo = res.getData().get(0);// 获取登录用户VO
            if(vo != null && StringUtils.isNotEmpty(vo.getSourceId())){
                return vo.getSourceId();// 来源ID
            }
        }
        return null;
    }

}
