/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sync.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sync.bean.Calculate;
import com.ejianc.business.sync.bean.CalculateDetail;
import com.ejianc.business.sync.bean.CalculateSettle;
import com.ejianc.business.sync.mapper.CalculateMapper;
import com.ejianc.business.sync.service.ICalculateDetailService;
import com.ejianc.business.sync.service.ICalculateService;
import com.ejianc.business.sync.service.ICalculateSettleService;
import com.ejianc.business.sync.vo.CalculateDetailVO;
import com.ejianc.business.sync.vo.CalculateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="calculateService")
public class CalculateService
extends BaseServiceImpl<CalculateMapper, Calculate>
implements ICalculateService {
    private Logger logger = LoggerFactory.getLogger(CalculateService.class);
    @Autowired
    private ICalculateSettleService calculateSettleService;
    @Autowired
    private ICalculateDetailService calculateDetailService;

    @Override
    public CommonResponse<String> sync(List<CalculateVO> calculateVOList) {
        this.saveBatch(BeanMapper.mapList(calculateVOList, Calculate.class));
        ArrayList settleList = new ArrayList();
        ArrayList<CalculateDetailVO> detailList = new ArrayList<CalculateDetailVO>();
        for (CalculateVO calculateVO : calculateVOList) {
            settleList.addAll(calculateVO.getSettleList());
            detailList.addAll(calculateVO.getDetailList());
        }
        if (CollectionUtils.isNotEmpty(settleList)) {
            this.calculateSettleService.saveBatch(BeanMapper.mapList(settleList, CalculateSettle.class));
        }
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.sort(Comparator.comparingInt(CalculateDetailVO::getSequence));
            this.calculateDetailService.saveBatch(BeanMapper.mapList(detailList, CalculateDetail.class));
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> delSync(Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Calculate::getNflag, (Object)1);
        queryWrapper.likeRight(Calculate::getPkId, (Object)id);
        if (this.count((Wrapper)queryWrapper) > 0) {
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u88abNC\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        LambdaUpdateWrapper deleteWrapper = new LambdaUpdateWrapper();
        deleteWrapper.likeRight(Calculate::getPkId, (Object)id);
        this.remove((Wrapper)deleteWrapper);
        LambdaUpdateWrapper settleDeleteWrapper = new LambdaUpdateWrapper();
        settleDeleteWrapper.likeRight(CalculateSettle::getPkId, (Object)id);
        this.calculateSettleService.remove((Wrapper)settleDeleteWrapper);
        LambdaUpdateWrapper detailDeleteWrapper = new LambdaUpdateWrapper();
        detailDeleteWrapper.likeRight(CalculateDetail::getPkId, (Object)id);
        this.calculateDetailService.remove((Wrapper)detailDeleteWrapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<List<CalculateVO>> settleFlagSync(String ts, Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ge(StringUtils.isNotBlank((CharSequence)ts), Calculate::getTs, (Object)ts);
        queryWrapper.likeRight(null != id, Calculate::getPkId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u7ed3\u7b97\u6807\u8bc6\u67e5\u8be2\uff01", CollectionUtils.isNotEmpty((Collection)list) ? BeanMapper.mapList((Iterable)list, CalculateVO.class) : null);
    }
}

