package com.ejianc.business.wzxt.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;


/**
 * 发货实体
 * 
 * @author generator
 * 
 */
public class DeliveryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long orderId; // 订单主键
    private String billCode; // 单据编号
    private String billStateName; // 单据名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String contractId; // 合同主键
    private String contractName; // 合同名称
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private Long customTenantId; // 客户租户ID
    private String materialName; // 物资名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long linkId; // 送货人
    private String linkName; // 送货人名称
    private String deliveryCarNumber; // 车牌号
    private String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date deliveryDate; // 送货日期
    private String deliveryNote; // 送货要求
    private String deliveryAddress; // 送货地址
    private Integer deliverState; // 发货状态（0-自由态，1-已发货，2-已验收）
    private String deliverStateName; // 发货状态（0-自由态，1-已发货，2-已验收）
    private Integer billState; // 单据状态（审批必须字段）
    private String projectSourceId; // 项目来源id
    private String orderBillCode; // 订单单据编号
    private Long parentOrgId; // 上级组织id
    private String parentOrgSourceId; // 上级组织来源id
    private String orgSourceId; // 组织来源ID
    private String supplierSourceId; // 供应商来源id
    private String smartStatus; // 智能称重标识
    private String closeStatus; // 关闭标识
    private String platformType; // 磅点类型
    private String platformCode; // 磅点编号
    private Boolean historyFlag; // 是否历史数据
    private String historyId; // 来源主键
    private String historySystem; // 来源系统
    private String checker; // 验收人
    private java.lang.String def1; // 自定义字段
    private java.lang.String def2; // 自定义字段
    private java.lang.String def3; // 自定义字段
    private java.lang.String def4; // 自定义字段
    private java.lang.String def5; // 自定义字段
    private List<String> pkWeighBillList;
    private List<DeliveryDetailVO> deliveryDetailVOList;
    private String checkprocess;
    /**
     * 总数量
     */
    private Integer totalNum;

    /**
     * 已验收数量
     */
    private Integer checkNum;

    /**
     * 未验收数量
     */
    private Integer unCheckNum;
    private String sceneurl;
    private List<AttachmentVO> attachmentVOList;

    public List<AttachmentVO> getAttachmentVOList() {
        return attachmentVOList;
    }

    public void setAttachmentVOList(List<AttachmentVO> attachmentVOList) {
        this.attachmentVOList = attachmentVOList;
    }

    public String getSceneurl() {
        return sceneurl;
    }

    public void setSceneurl(String sceneurl) {
        this.sceneurl = sceneurl;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Integer getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(Integer checkNum) {
        this.checkNum = checkNum;
    }

    public Integer getUnCheckNum() {
        return unCheckNum;
    }

    public void setUnCheckNum(Integer unCheckNum) {
        this.unCheckNum = unCheckNum;
    }

    public List<DeliveryDetailVO> getDeliveryDetailVOList() {
        return deliveryDetailVOList;
    }

    public void setDeliveryDetailVOList(List<DeliveryDetailVO> deliveryDetailVOList) {
        this.deliveryDetailVOList = deliveryDetailVOList;
    }

    public String getCheckprocess() {
        return checkprocess;
    }

    public void setCheckprocess(String checkprocess) {
        this.checkprocess = checkprocess;
    }

    public List<String> getPkWeighBillList() {
        return pkWeighBillList;
    }

    public void setPkWeighBillList(List<String> pkWeighBillList) {
        this.pkWeighBillList = pkWeighBillList;
    }

    public String getChecker() {
        return checker;
    }

    public void setChecker(String checker) {
        this.checker = checker;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public String getSmartStatus() {
        return smartStatus;
    }

    public void setSmartStatus(String smartStatus) {
        this.smartStatus = smartStatus;
    }

    public String getCloseStatus() {
        return closeStatus;
    }

    public void setCloseStatus(String closeStatus) {
        this.closeStatus = closeStatus;
    }

    public String getPlatformType() {
        return platformType;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public String getPlatformCode() {
        return platformCode;
    }

    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    public Boolean getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Boolean historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    // 设备明细子表
    private List<DeliveryDetailVO> deliveryDetail = new ArrayList<>();

    public List<DeliveryDetailVO> getDeliveryDetail() {
        return deliveryDetail;
    }

    public void setDeliveryDetail(List<DeliveryDetailVO> deliveryDetail) {
        this.deliveryDetail = deliveryDetail;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDeliverStateName() {
        return deliverStateName;
    }

    public void setDeliverStateName(String deliverStateName) {
        this.deliverStateName = deliverStateName;
    }

    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 客户租户ID
     */
    public Long getCustomTenantId() {
        return customTenantId;
    }

    /**
     * 客户租户ID
     */
    public void setCustomTenantId(Long customTenantId) {
        this.customTenantId = customTenantId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 送货人名称
     */
    public String getLinkName() {
        return linkName;
    }

    /**
     * 送货人名称
     */
    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    /**
     * 车牌号
     */
    public String getDeliveryCarNumber() {
        return deliveryCarNumber;
    }

    /**
     * 车牌号
     */
    public void setDeliveryCarNumber(String deliveryCarNumber) {
        this.deliveryCarNumber = deliveryCarNumber;
    }
    /**
     * 联系人电话
     */
    public String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 送货日期
     */
    public java.util.Date getDeliveryDate() {
        return deliveryDate;
    }

    /**
     * 送货日期
     */
    public void setDeliveryDate(java.util.Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    /**
     * 送货要求
     */
    public String getDeliveryNote() {
        return deliveryNote;
    }

    /**
     * 送货要求
     */
    public void setDeliveryNote(String deliveryNote) {
        this.deliveryNote = deliveryNote;
    }
    /**
     * 送货地址
     */
    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * 送货地址
     */
    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 设备供应商
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
}
