package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.ZjwjSyncHystrix;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-wzxt-web", url="${common.env.feign-client-url}", path="ejc-wzxt-web", fallback = ZjwjSyncHystrix.class)
public interface IZjwjSyncApi {


	/**
	 * 总控计划表头
	 *
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanList")
	CommonResponse<String> syncControlPlanList(List<SyncControlPlanVO> controlPlanVOS);


	/**
	 * 总控计划表体
	 *
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanDetailList")
	CommonResponse<String> syncControlPlanDetailList(List<SyncControlPlanDetailVO> controlPlanDetailVOS);

}
