package com.ejianc.business.wzxt.api;


import com.ejianc.business.wzxt.hystrix.CheckHystrix;
import com.ejianc.business.wzxt.vo.ExitApplyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 退场申请单
 *
 * @Author songlx
 * @Date 2021-03-18
 **/
@FeignClient(name = "ejc-wzxt-web", url = "${common.env.feign-client-url}", path = "ejc-wzxt-web", fallback = CheckHystrix.class)
public interface IExitApplyApi {


    @PostMapping(value = "/api/exitApply/confirmResult")
    public CommonResponse<Boolean> confirmResult(@RequestBody List<ExitApplyVO> instoreVOList);

}
