package com.ejianc.business.wzxt.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
public class PlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String planName; // 使用计划名称
    private String billCode; // 计划编码
    private String billStateName; // 单据名称
    private Long projectId; // 项目
    private Long materialId; // 物资主键
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date planDate; // 计划使用日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date createDate; // 创建日期
    private String construction; // 施工部位
    private String memo; // 备注
    private String materialName; // 物资名称
    private Integer billState; // 单据状态（审批必须字段）
    private java.lang.String projectSourceId; // 项目来源id
    private java.lang.String planFlag; // 是否开启计划
    private java.lang.String planFlagName; // 是否开启计划名称
    private java.lang.String orgSourceId; // 组织来源ID
    private java.lang.Long employeeTelephone; // 经办人电话
    private java.lang.Long parentOrgId; // 上级组织id
    private java.lang.String parentOrgSourceId; // 上级组织来源id
    private java.lang.Boolean historyFlag; // 是否历史数据
    private java.lang.String historyId; // 来源主键
    private java.lang.String historySystem; // 来源系统
    private java.lang.String def1; // 自定义字段
    private java.lang.String def2; // 自定义字段
    private java.lang.String def3; // 自定义字段
    private java.lang.String def4; // 自定义字段
    private java.lang.String def5; // 自定义字段
    private java.lang.Integer materialType; //
    private java.lang.String materialTypeName; //

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public String getPlanFlagName() {
        return planFlagName;
    }

    public void setPlanFlagName(String planFlagName) {
        this.planFlagName = planFlagName;
    }

    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }

    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }

    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }

    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }

    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public String getPlanFlag() {
        return planFlag;
    }

    public void setPlanFlag(String planFlag) {
        this.planFlag = planFlag;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    public Long getEmployeeTelephone() {
        return employeeTelephone;
    }

    public void setEmployeeTelephone(Long employeeTelephone) {
        this.employeeTelephone = employeeTelephone;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    public Boolean getHistoryFlag() {
        return historyFlag;
    }

    public void setHistoryFlag(Boolean historyFlag) {
        this.historyFlag = historyFlag;
    }

    public String getHistoryId() {
        return historyId;
    }

    public void setHistoryId(String historyId) {
        this.historyId = historyId;
    }

    public String getHistorySystem() {
        return historySystem;
    }

    public void setHistorySystem(String historySystem) {
        this.historySystem = historySystem;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    // 设备明细子表
    private List<PlanDetailVO> planDetail = new ArrayList<>();

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 使用计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 计划编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 计划使用日期
     */
    public java.util.Date getPlanDate() {
        return planDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanDate(java.util.Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public List<PlanDetailVO> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<PlanDetailVO> planDetail) {
        this.planDetail = planDetail;
    }
}
