package com.ejianc.business.wzxt.api;

import com.ejianc.business.wzxt.hystrix.ZjwjWzxtSyncHystrix;
import com.ejianc.business.wzxt.vo.SyncControlPlanDetailVO;
import com.ejianc.business.wzxt.vo.SyncControlPlanVO;
import com.ejianc.business.wzxt.vo.sync.SyncMroProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "cscec5b-wzxt-web", url="${common.env.feign-client-url}", path="cscec5b-wzxt-web", fallback = ZjwjWzxtSyncHystrix.class)
public interface IZjwjWzxtSyncApi {


	/**
	 * 总控计划表头
	 *
	 * @param controlPlanVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanList")
	CommonResponse<String> syncControlPlanList(@RequestBody  List<SyncControlPlanVO> controlPlanVOS);


	/**
	 * 总控计划表体
	 *
	 * @param controlPlanDetailVOS
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncControlPlanDetailList")
	CommonResponse<String> syncControlPlanDetailList(@RequestBody List<SyncControlPlanDetailVO> controlPlanDetailVOS);

	/**
	 * 同步MRO项目
	 *
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/syncMroProjectList")
	CommonResponse<String> syncMroProjectList();

}
