package com.ejianc.business.wzxt.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.List;


/**
 * 物资验收模板实体
 * 
 * @author generator
 * 
 */
public class TemplateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 模板编码
    private String templateName; // 模板名称
    private Long materialId; // 物资主键
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    private Long materialTypeId; // 物资类别ID
    private String materialTypeCode; // 物资分类编码
    private String materialTypeName; // 物资分类名称
    private String spec; // 规格型号
    private String memo; // 说明
    private Long orgId; // 组织ID
    private String orgSourceId; // 组织来源ID
    private Long parentOrgId; // 上级组织id
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long employeeTelephone; // 经办人电话
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private java.util.Date createDate; // 编制日期
    
    private List<TemplateContentVO> templateContentEntityList = new ArrayList<>(); // 物资验收模板子表


    public List<TemplateContentVO> getTemplateContentEntityList() {
        return templateContentEntityList;
    }

    public void setTemplateContentEntityList(List<TemplateContentVO> templateContentEntityList) {
        this.templateContentEntityList = templateContentEntityList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 模板名称
     */
    public String getTemplateName() {
        return templateName;
    }

    /**
     * 模板名称
     */
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
    /**
     * 物资主键
     */
    @ReferSerialTransfer(referCode="Material001")
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */

    public String getMaterialName() {
        return materialName;
   }

    /**
     * 物资名称
     */
   public void setMaterialName(String materialName) {
       this.materialName = materialName;
   }
    /**
     * 物资类别ID
     */
    @ReferSerialTransfer(referCode="MaterialCategory001")
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别ID
     */
    @ReferDeserialTransfer
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }



    /**
     * 物资分类编码
     */
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    /**
     * 物资分类编码
     */
    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 说明
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 说明
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 组织ID
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织ID
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织来源ID
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源ID
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    /**
     * 上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人电话
     */
    public Long getEmployeeTelephone() {
        return employeeTelephone;
    }

    /**
     * 经办人电话
     */
    public void setEmployeeTelephone(Long employeeTelephone) {
        this.employeeTelephone = employeeTelephone;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 编制日期
     */
    public java.util.Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(java.util.Date createDate) {
        this.createDate = createDate;
    }
    

}
