package com.ejianc.business.wzxt.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 退场申请单
 *
 * @author generator
 */
public class ExitApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long orgId; // 组织ID
    private String orgSourceId; // 组织来源ID
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织ID
    private String parentOrgSourceId; // 上级组织来源ID
    private String billCode; // 单据编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billDate; // 单据日期
    private Integer billState; // 单据状态
    private Integer applyState; // 关闭状态(1已关闭/0未关闭)
    private Long projectId; // 项目ID
    private String projectSourceId; // 项目来源ID
    private String projectName; // 项目名称
    private String contractId; // 合同ID
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private String supplierSourceId; // 供应商来源ID
    private String materialName; // 物资名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date exitDate; // 预计退场日期
    private String exitDesc; // 退场说明
    private Integer confirmFlag; // 确认状态0-未确认1-已确认2-已拒绝
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long confirmerId; // 确认人ID
    private Long confirmerCode; // 确认人编码
    private String confirmerName; // 确认人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date confirmDate; // 确认日期
    private String confirmDesc; // 确认说明

    private Long linkId; // 联系人
    private String linkName; // 联系人名称
    private String linkTelephone; // 联系人电话

    private String def1; //
    private String def2; //
    private String def3; //
    private String def4; //
    private String def5; //
    private List<ExitApplyDetailVO> exitApplyDetail = new ArrayList<>();

    private String billStateName;

    private String confirmFlagName;

    private static Map<Integer, String> confirmFlagMap = new HashMap<>();

    static {
        confirmFlagMap.put(0, "未确认");
        confirmFlagMap.put(1, "已确认");
        confirmFlagMap.put(2, "已拒绝");
    }

    public static String getConfirmFlagTxt(Integer confirmFlag) {
        return confirmFlagMap.get(confirmFlag);
    }


    /**
     * 联系人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    @ReferDeserialTransfer
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }

    public String getConfirmFlagName() {
        return confirmFlagName;
    }

    public void setConfirmFlagName(String confirmFlagName) {
        this.confirmFlagName = confirmFlagName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织来源ID
     */
    public String getOrgSourceId() {
        return orgSourceId;
    }

    /**
     * 组织来源ID
     */
    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }

    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 上级组织ID
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织ID
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    /**
     * 上级组织来源ID
     */
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    /**
     * 上级组织来源ID
     */
    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据日期
     */
    public java.util.Date getBillDate() {
        return billDate;
    }

    /**
     * 单据日期
     */
    public void setBillDate(java.util.Date billDate) {
        this.billDate = billDate;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    /**
     * 关闭状态(1已关闭/0未关闭)
     */
    public Integer getApplyState() {
        return applyState;
    }

    /**
     * 关闭状态(1已关闭/0未关闭)
     */
    public void setApplyState(Integer applyState) {
        this.applyState = applyState;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目来源ID
     */
    public String getProjectSourceId() {
        return projectSourceId;
    }

    /**
     * 项目来源ID
     */
    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 合同ID
     */
    public String getContractId() {
        return contractId;
    }

    /**
     * 合同ID
     */
    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 设备供应商
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 供应商来源ID
     */
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    /**
     * 供应商来源ID
     */
    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    /**
     * 预计退场日期
     */
    public java.util.Date getExitDate() {
        return exitDate;
    }

    /**
     * 预计退场日期
     */
    public void setExitDate(java.util.Date exitDate) {
        this.exitDate = exitDate;
    }

    /**
     * 退场说明
     */
    public String getExitDesc() {
        return exitDesc;
    }

    /**
     * 退场说明
     */
    public void setExitDesc(String exitDesc) {
        this.exitDesc = exitDesc;
    }

    /**
     * 确认状态0-未确认1-已确认2-已拒绝
     */
    public Integer getConfirmFlag() {
        return confirmFlag;
    }

    /**
     * 确认状态0-未确认1-已确认2-已拒绝
     */
    public void setConfirmFlag(Integer confirmFlag) {
        this.confirmFlag = confirmFlag;
    }


    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /**
     * 确认人ID
     */
    public Long getConfirmerId() {
        return confirmerId;
    }

    /**
     * 确认人ID
     */
    public void setConfirmerId(Long confirmerId) {
        this.confirmerId = confirmerId;
    }

    /**
     * 确认人编码
     */
    public Long getConfirmerCode() {
        return confirmerCode;
    }

    /**
     * 确认人编码
     */
    public void setConfirmerCode(Long confirmerCode) {
        this.confirmerCode = confirmerCode;
    }

    /**
     * 确认人名称
     */
    public String getConfirmerName() {
        return confirmerName;
    }

    /**
     * 确认人名称
     */
    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }

    /**
     * 确认日期
     */
    public java.util.Date getConfirmDate() {
        return confirmDate;
    }

    /**
     * 确认日期
     */
    public void setConfirmDate(java.util.Date confirmtDate) {
        this.confirmDate = confirmtDate;
    }

    /**
     * 确认说明
     */
    public String getConfirmDesc() {
        return confirmDesc;
    }

    /**
     * 确认说明
     */
    public void setConfirmDesc(String confirmDesc) {
        this.confirmDesc = confirmDesc;
    }

    /**
     *
     */
    public String getDef1() {
        return def1;
    }

    /**
     *
     */
    public void setDef1(String def1) {
        this.def1 = def1;
    }

    /**
     *
     */
    public String getDef2() {
        return def2;
    }

    /**
     *
     */
    public void setDef2(String def2) {
        this.def2 = def2;
    }

    /**
     *
     */
    public String getDef3() {
        return def3;
    }

    /**
     *
     */
    public void setDef3(String def3) {
        this.def3 = def3;
    }

    /**
     *
     */
    public String getDef4() {
        return def4;
    }

    /**
     *
     */
    public void setDef4(String def4) {
        this.def4 = def4;
    }

    /**
     *
     */
    public String getDef5() {
        return def5;
    }

    /**
     *
     */
    public void setDef5(String def5) {
        this.def5 = def5;
    }

    public List<ExitApplyDetailVO> getExitApplyDetail() {
        return exitApplyDetail;
    }

    public void setExitApplyDetail(List<ExitApplyDetailVO> exitApplyDetail) {
        this.exitApplyDetail = exitApplyDetail;
    }
}
