package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.mapper.OrderMapper;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPlanDetailService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
@Service("orderService")
public class OrderServiceImpl extends BaseServiceImpl<OrderMapper, OrderEntity> implements IOrderService{

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weChat.cgdd-agentid}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret}")
    private String cgddSecret;

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String WZXT_PURCHASE_BILL_CODE = "WZXT_PURCHASE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public OrderVO saveOrUpdate(OrderVO orderVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(orderVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PURCHASE_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                orderVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        StringBuffer materialName = new StringBuffer();

        List<PlanDetailEntity> listedit = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(null!=vo.getLeafFlag()&&!vo.getLeafFlag()){
                    materialName.append(vo.getMaterialName()+",");
                }
                if(null==vo.getLeafFlag()||vo.getLeafFlag()){
                    //说明是子集
                    vo.setLeafFlag(true);
                    if(null!=vo.getId()){
                        if("del".equals(vo.getRowState())){
                            //说明是子集删除
                            PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                            BigDecimal nums = entity.getNums()==null?BigDecimal.ZERO:entity.getNums();// 数量
                            BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                            BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();
                            BigDecimal stockAmountSum = vo.getStockAmountSum()==null?BigDecimal.ZERO:vo.getStockAmountSum();//库存量
                            entity.setOccupyNums(occupyNums.subtract(orderNums).subtract(stockAmountSum));
                            entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                            listedit.add(entity);
                        }else{
                            OrderDetailEntity detailEntity = orderDetailService.getById(vo.getId());
                            BigDecimal orderNumsDb = detailEntity.getOrderNumsSum()==null?BigDecimal.ZERO:detailEntity.getOrderNumsSum();// 数据库的订单数量
                            BigDecimal stockAmountSumDb = detailEntity.getStockAmountSum()==null?BigDecimal.ZERO:detailEntity.getStockAmountSum();// 数据库的库存量
                            BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();//前端传的数量
                            BigDecimal stockAmountSum = vo.getStockAmountSum()==null?BigDecimal.ZERO:vo.getStockAmountSum();//前端传的库存量
                            if(orderNums.compareTo(orderNumsDb)!=0){
                                BigDecimal subtractNum = orderNumsDb.subtract(orderNums);//例子  前端传80，数据库为100  则差值为20
                                BigDecimal stockAmountSumNum = stockAmountSumDb.subtract(stockAmountSum);
                                //说明订单数量有修改
                                PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                                BigDecimal nums = entity.getNums()==null?BigDecimal.ZERO:entity.getNums();// 数量
                                BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                                BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();//剩余
                                if(surplusNums.compareTo(subtractNum.add(stockAmountSumNum))<0){
                                    throw new BusinessException("【订单数量+库存量】不能超过计划剩余量，该材料明细实际剩余量为【"+surplusNums+"】!");
                                }
                                entity.setOccupyNums(occupyNums.subtract(subtractNum).subtract(stockAmountSumNum));
                                entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                                listedit.add(entity);

                            }
                        }
                    }else{
                        //说明是子集新增
                        PlanDetailEntity entity = planDetailService.getById(vo.getPlanDetailId());
                        BigDecimal nums = entity.getNums()==null?BigDecimal.ZERO:entity.getNums();// 数量
                        BigDecimal occupyNums = entity.getOccupyNums()==null?BigDecimal.ZERO:entity.getOccupyNums();// 占用数量
                        BigDecimal surplusNums = entity.getSurplusNums()==null?BigDecimal.ZERO:entity.getSurplusNums();// 剩余
                        BigDecimal orderNums = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();
                        BigDecimal stockAmountSum = vo.getStockAmountSum()==null?BigDecimal.ZERO:vo.getStockAmountSum();//库存量
                        if(surplusNums.compareTo(orderNums.add(stockAmountSum))<0){
                            throw new BusinessException("【订单数量+库存量】不能超过计划剩余量，该材料明细实际剩余量为【"+surplusNums+"】!");
                        }
                        entity.setOccupyNums(occupyNums.add(orderNums).add(stockAmountSum));
                        entity.setSurplusNums(nums.subtract(entity.getOccupyNums()));
                        listedit.add(entity);
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(listedit)){
                planDetailService.updateBatchById(listedit);
            }
            String materialNames = materialName.substring(0, materialName.length() - 1);
            orderVO.setMaterialName(materialNames);
        }
        OrderEntity entity = BeanMapper.map(orderVO, OrderEntity.class);
//        entity.setReceiveState(0);
        super.saveOrUpdate(entity, false);
        return queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(OrderVO orderVO) {
        OrderEntity orderEntity = super.selectById(orderVO.getId());
        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>=0){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 定时到期下架消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"ejc-wzxt-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderEntity.setReceiveState(1);//全部接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),1);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    if(false == vo.getLeafFlag()){
                        vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                        vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    }
                });
            }
        }else if(3==orderVO.getReceiveState()){
          //已拒绝
            orderEntity.setReceiveState(3);//拒绝
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
                //拆分接收数量
                OrderDetailBack(orderVO.getPurchaseOrderDetail(),3);
                orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                    // to do
                    if(false == vo.getLeafFlag()) {
                        vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                        vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                    }
                });
            }
        }
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()));
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }

    @Override
    public CommonResponse<OrderVO> updateReceivedPart(OrderVO orderVO) {
        OrderEntity orderEntity = super.selectById(orderVO.getId());
        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>=0){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }
        orderEntity.setReceiveState(2);//部分接收
        orderEntity.setDeliverState(0);//待发货
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            //拆分接收数量
            OrderDetailBack(orderVO.getPurchaseOrderDetail(),2);
            orderEntity.getPurchaseOrderDetail().forEach(vo -> {
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }

        // TO DO 定时到期下架消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
//        messageType.add("weChat");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        logger.info("发送信息给发布人:>----------" + sender+baseHost);
        String formurl = baseHost+"ejc-wzxt-frontend/#/purchaseOrder/card?id="+orderEntity.getId();
        String subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
        String content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()));
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }
    //1-全部接收，2-部分接收，3-全部拒绝
    public void OrderDetailBack(List<OrderDetailVO> detailList,int type){
        List<OrderDetailEntity> entityList = new ArrayList<>();
        List<PlanDetailEntity> planDetailList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                //查询订单数量>接收数量的明细  根据主键正序排
                LambdaQueryWrapper<OrderDetailEntity> lambda = Wrappers.<OrderDetailEntity>lambdaQuery();
                lambda.eq(OrderDetailEntity::getParentId,vo.getTid());
                lambda.eq(OrderDetailEntity::getOrderId,vo.getOrderId());
                lambda.eq(OrderDetailEntity::getLeafFlag,true);
                lambda.orderByAsc(OrderDetailEntity::getId);
                List<OrderDetailEntity> details  = orderDetailService.list(lambda);
                if(CollectionUtils.isNotEmpty(details)){
                    BigDecimal receiveNumsSum = BigDecimal.ZERO;//汇总的接收数量
                    if(1==type){
                        receiveNumsSum = vo.getOrderNumsSum()==null?BigDecimal.ZERO:vo.getOrderNumsSum();//全部接收默认等于订单量
                    }else if(2==type){
                        receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();
                    }
                    //forEach  不能这样用    xx = xx.subtract(xx);
                    for(int i=0;i<details.size();i++){

                        BigDecimal orderNumsSum = details.get(i).getOrderNumsSum()==null?BigDecimal.ZERO:details.get(i).getOrderNumsSum();//订单量
                        if(receiveNumsSum.compareTo(BigDecimal.ZERO)>0){
                            if(receiveNumsSum.compareTo(orderNumsSum)>=0){
                                //接收数量  大于该行  剩余可接收数量，则直接将该行  接收数量=订单数量即可
                                details.get(i).setReceiveNumsSum(orderNumsSum);
                                receiveNumsSum = receiveNumsSum.subtract(orderNumsSum);
                            }else{
                                //接收数量  小于该行  剩余可接收数量，则直接将该行  接收数量=原来订单数量+行汇总后的剩余接收数量
                                details.get(i).setReceiveNumsSum(receiveNumsSum);
                                //此时需要回写计划订单明细对应的占用金额
                                PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                                BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                                BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                                planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum).add(receiveNumsSum));//占用量
                                planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                                receiveNumsSum = receiveNumsSum.subtract(receiveNumsSum);
                                planDetailList.add(planDetailEntity);
                            }
                            entityList.add(details.get(i));//后续批量更新
                        }else {
                            PlanDetailEntity planDetailEntity = planDetailService.selectById(details.get(i).getPlanDetailId());
                            BigDecimal occupyNums = planDetailEntity.getOccupyNums()==null?BigDecimal.ZERO:planDetailEntity.getOccupyNums();
                            BigDecimal nums = planDetailEntity.getNums()==null?BigDecimal.ZERO:planDetailEntity.getNums();

                            planDetailEntity.setOccupyNums(occupyNums.subtract(orderNumsSum));//占用量
                            planDetailEntity.setSurplusNums(nums.subtract(planDetailEntity.getOccupyNums()));//剩余量
                            planDetailList.add(planDetailEntity);
                        }
                    }
                    //批量更新订单明细
                    if(CollectionUtils.isNotEmpty(entityList)){
                        orderDetailService.updateBatchById(entityList);
                    }
                    //批量更新计划明细
                    if(CollectionUtils.isNotEmpty(planDetailList)){
                        planDetailService.updateBatchById(planDetailList);
                    }
                }
            });
        }
    }


    @Override
    public OrderVO queryDetail(Long id) {
        OrderEntity entity = super.selectById(id);
        OrderVO orderVO = BeanMapper.map(entity, OrderVO.class);

        List<OrderDetailVO> listres = new ArrayList<>();
        List<OrderDetailVO> list = orderVO.getPurchaseOrderDetail();
        if(CollectionUtils.isNotEmpty(orderVO.getPurchaseOrderDetail())){
            orderVO.getPurchaseOrderDetail().forEach(vo -> {
                if(vo.getParentId().equals(999L)){
                    listres.add(vo);
                }
                // to do
//                BigDecimal receiveNumsSum = vo.getReceiveNumsSum()==null?BigDecimal.ZERO:vo.getReceiveNumsSum();//接收数量
//                BigDecimal deliverNumsSum = vo.getDeliverNumsSum()==null?BigDecimal.ZERO:vo.getDeliverNumsSum();//发货数量
//                vo.setUnDeliverNumsSum(receiveNumsSum.subtract(deliverNumsSum));//未发货数量
            });

            listres.forEach(vo -> {
                List<OrderDetailVO> listd = new ArrayList<>();
                list.forEach(e -> {
                    if(vo.getTid().equals(e.getParentId())){
                        listd.add(e);
                    }
                });
                vo.setChildren(listd);
            });
            orderVO.setPurchaseOrderDetail(listres);
        }
        return orderVO;
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
//        if (messageType.contains("weChat")) {
//            // 系统消息
//            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
//        }

        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }
}
