package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.WeighEntity;
import com.ejianc.business.wzxt.vo.WeighDetailVO;
import com.ejianc.business.wzxt.vo.WeighVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.WeighDetailMapper;
import com.ejianc.business.wzxt.bean.WeighDetailEntity;
import com.ejianc.business.wzxt.service.IWeighDetailService;

/**
 * 智能称重实体明细表
 * 
 * @author generator
 * 
 */
@Service("weighDetailService")
public class WeighDetailServiceImpl extends BaseServiceImpl<WeighDetailMapper, WeighDetailEntity> implements IWeighDetailService{

    @Override
    public CommonResponse<WeighDetailVO> getdetailByOrgId(Long projectDepartmentId, Long materialId) {
        //查询此项目是否开启智能称重
        LambdaQueryWrapper<WeighDetailEntity> queryWrapper = Wrappers.<WeighDetailEntity>lambdaQuery();
        queryWrapper.eq(WeighDetailEntity::getOrgId, projectDepartmentId);
        queryWrapper.eq(WeighDetailEntity::getOrgId, projectDepartmentId);
        WeighDetailEntity weighDetailEntity = super.getOne(queryWrapper);
        if (weighDetailEntity != null) {
            WeighDetailVO vo = BeanMapper.map(weighDetailEntity, WeighDetailVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            return CommonResponse.success("查询详情数据成功！",null);
        }
    }
}
