package com.ejianc.business.wzxt.controller;

import com.ejianc.business.wzxt.service.IWeighReportService;
import com.ejianc.business.wzxt.vo.WeighReportSaveVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 智能称重台账实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("weighReport")
public class WeighReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWeighReportService weighReportService;

    /**
     * 推单
     *
     * @return
     */
    @PostMapping(value = "/push")
    @ResponseBody
    public Boolean push(@RequestBody WeighReportSaveVO weighReportVO) {
        return weighReportService.push(weighReportVO);
    }

}
