/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.service.IPurchaseOrderService;
import com.ejianc.business.wzxt.service.IPurchaseOrderServicePortType;
import com.ejianc.business.wzxt.util.HttpTookit;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckDetailsVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.business.wzxt.vo.PurchaseOrderBodyVO;
import com.ejianc.business.wzxt.vo.PurchaseOrderHeadVO;
import com.ejianc.business.wzxt.vo.PurchaseOrderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String WZXT_CHECK = "CSCEC5B_CWZXT_CHECK";
    private static final String SUPPLIER_HTTP = "http://47.94.227.96:9001/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        List detailList;
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() == null) {
            entity.setUseState(0);
            entity.setCheckState(1);
            if (entity.getCreateUserId() == null) {
                entity.setCreateUserId(InvocationInfoProxy.getUserid());
                entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(detailList = saveorUpdateVO.getDetailList()))) {
            StringBuffer materialName = new StringBuffer();
            detailList.forEach(detail -> materialName.append(detail.getMaterialName() + ","));
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
        }
        super.saveOrUpdate((Object)entity, false);
        this.writeBackDelivery(saveorUpdateVO, true);
        this.writeBackOrder(saveorUpdateVO, true);
        return (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(deliveryId));
        vo.setProjectId(delivery.getProjectId());
        vo.setProjectSourceId(delivery.getProjectSourceId());
        vo.setProjectName(delivery.getProjectName());
        vo.setOrgId(delivery.getOrgId());
        vo.setOrgName(delivery.getOrgName());
        vo.setContractId(delivery.getContractId());
        vo.setContractName(delivery.getContractName());
        vo.setSupplierId(delivery.getSupplierId());
        vo.setSupplierName(delivery.getSupplierName());
        vo.setSupplierTenantId(delivery.getTenantId());
        vo.setLicensePlate(delivery.getDeliveryCarNumber());
        vo.setMaterialName(delivery.getMaterialName());
        vo.setOrderId(delivery.getOrderId());
        vo.setDeliveryId(deliveryId);
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)new LambdaQueryWrapper().eq(DeliveryDetailEntity::getDeliveryId, (Object)delivery.getId()));
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailList)) {
            ArrayList detailList = new ArrayList();
            deliveryDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);
                detail.setDeliveryDetailId(dd.getId());
                detail.setOrderId(dd.getOrderId());
                detail.setOrderDetailId(dd.getOrderDetailId());
                detail.setMaterialTypeId(dd.getMaterialTypeId());
                detail.setMaterialTypeName(dd.getMaterialTypeName());
                detail.setMaterialId(dd.getMaterialId());
                detail.setMaterialCode(dd.getMaterialCode());
                detail.setMaterialName(dd.getMaterialName());
                detail.setUnit(dd.getUnit());
                detail.setSpec(dd.getSpec());
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(detailList)) {
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List vos;
        List entityList = ((CheckMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"id", ids));
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                if (entity.getUseState() == 1) {
                    throw new BusinessException("\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(vos = BeanMapper.mapList((Iterable)entityList, CheckVO.class)))) {
            vos.forEach(vo -> {
                this.writeBackDelivery((CheckVO)vo, false);
                this.writeBackOrder((CheckVO)vo, false);
            });
        }
        return super.removeByIds(ids, true);
    }

    @Override
    public Boolean push2NC(Long id) {
        boolean drflag = this.sysdr(id);
        if (!drflag) {
            throw new BusinessException("NC\u7aef\u5df2\u5b58\u5728\u4e14\u672a\u5220\u9664");
        }
        StringBuffer msg = new StringBuffer();
        String pkUser = String.valueOf(InvocationInfoProxy.getUserid());
        CheckEntity check = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(id));
        if (StringUtils.isEmpty((CharSequence)check.getContractId())) {
            msg.append("[\u5408\u540c]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCwarehouseid())) {
            msg.append("[\u4ed3\u5e93]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCkcorgid())) {
            msg.append("[\u5e93\u5b58\u7ec4\u7ec7]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCdispatcherid())) {
            msg.append("[\u6536\u53d1\u7c7b\u522b]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCpurorganization())) {
            msg.append("[\u91c7\u8d2d\u7ec4\u7ec7]");
        }
        if (StringUtils.isEmpty((CharSequence)check.getCdptid())) {
            msg.append("[\u91c7\u8d2d\u90e8\u95e8]");
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            throw new BusinessException(msg + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List checkBList = this.checkDetailService.list((Wrapper)Wrappers.lambdaQuery().eq(CheckDetailEntity::getCheckId, (Object)id));
        PurchaseOrderVO checkVO = this.changToNcVO(check, checkBList, pkUser);
        this.logger.debug(JSON.toJSONString((Object)checkVO));
        IPurchaseOrderService ncService = new IPurchaseOrderService();
        try {
            JSONObject valueMap;
            String code;
            IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
            String resulet = http.processData(checkVO);
            if (StringUtils.isNotEmpty((CharSequence)resulet) && !"WS000001".equals(code = (String)(valueMap = JSON.parseObject((String)resulet)).get("code"))) {
                msg.append((String)valueMap.get("msg"));
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u63a8\u9001NC\u51fa\u9519");
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            throw new BusinessException("\u63a8\u9001NC" + msg);
        }
        check.setUseState(1);
        check.setDrstatus(0);
        check.setPushUserId(InvocationInfoProxy.getUserid());
        check.setPushUserName(this.sessionManager.getUserContext().getUserName());
        ((CheckMapper)this.baseMapper).updateById((Object)check);
        return true;
    }

    @Override
    public Boolean sysdr(Long id) {
        boolean flag = true;
        Integer dr = 1;
        ArrayList<String> arrList = new ArrayList<String>();
        arrList.add(String.valueOf(id));
        IPurchaseOrderService ncService = new IPurchaseOrderService();
        StringBuffer msg = new StringBuffer();
        try {
            this.logger.info("getIPurchaseOrderServiceSOAP11PortHttp begin");
            IPurchaseOrderServicePortType http = ncService.getIPurchaseOrderServiceSOAP11PortHttp();
            this.logger.info("getIPurchaseOrderServiceSOAP11PortHttp end");
            String json = http.getBillsStatus(arrList);
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                JSONObject valueMap = JSON.parseObject((String)json);
                String code = (String)valueMap.get("code");
                if (!"WS000001".equals(code)) {
                    msg.append((String)valueMap.get("msg"));
                } else {
                    JSONObject map;
                    JSONArray jsarr = (JSONArray)valueMap.get("data");
                    if (jsarr != null && jsarr.size() > 0 && (dr = Integer.valueOf((map = (JSONObject)jsarr.get(0)).get("dr") != null ? Integer.parseInt((String)map.get("dr")) : dr)) != 1) {
                        flag = false;
                    }
                }
            } else {
                msg.append("\u7ed3\u679c\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65NC\u5220\u9664\u72b6\u6001\u51fa\u9519");
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            throw new BusinessException("\u540c\u6b65NC" + msg);
        }
        CheckEntity entity = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(id));
        entity.setDrstatus(dr);
        ((CheckMapper)this.baseMapper).updateById((Object)entity);
        return flag;
    }

    @Override
    public Boolean updatenums(List<Long> ids) {
        boolean res;
        List checks = new ArrayList();
        if (!ids.isEmpty()) {
            checks = ((CheckMapper)this.baseMapper).selectBatchIds(ids);
            if (checks.size() > 0 && checks.size() == ids.size()) {
                Iterator iterator = checks.iterator();
                while (iterator.hasNext()) {
                    CheckEntity check;
                    check.setPrintNum((check = (CheckEntity)((Object)iterator.next())).getPrintNum() == 0 ? 1 : check.getPrintNum() + 1);
                }
            } else {
                throw new BusinessException("\u6570\u636e\u53ef\u80fd\u88ab\u66f4\u6539,\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u64cd\u4f5c");
            }
        }
        if (!(res = super.saveOrUpdateBatch(checks))) {
            throw new BusinessException("\u6570\u636e\u53ef\u80fd\u88ab\u66f4\u6539,\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u64cd\u4f5c");
        }
        return res;
    }

    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        if (checkVO.getDeliveryId() != null) {
            DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(checkVO.getDeliveryId()));
            if (null == checkVO.getId()) {
                delivery.setDeliverState(2);
                this.writeBackCheckToSupplier(String.valueOf(checkVO.getDeliveryId()), true);
            }
            if (!flag.booleanValue()) {
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(CheckEntity::getDeliveryId, new Object[]{checkVO.getDeliveryId()});
                lambda.ne(BaseEntity::getId, (Object)checkVO.getId());
                List entityList = ((CheckMapper)this.baseMapper).selectList((Wrapper)lambda);
                if (entityList.size() == 0) {
                    delivery.setDeliverState(1);
                    this.writeBackCheckToSupplier(String.valueOf(checkVO.getDeliveryId()), false);
                }
                if (delivery.getCloseStatus().equals("1")) {
                    delivery.setCloseStatus("0");
                    this.writeBackOpenDelivery(String.valueOf(checkVO.getDeliveryId()), false);
                }
            }
            this.deliveryService.updateById((Object)delivery);
        }
        List detailList = checkVO.getDetailList();
        ArrayList ddEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue()) {
                        DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                        BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                        ddCheckNums = flag != false ? ddCheckNums.add(checkNums) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal2 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(ddEditList)) {
                this.deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        List detailList = checkVO.getDetailList();
        ArrayList odEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getOrderDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue()) {
                        OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                        BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                        odCheckNums = flag != false ? odCheckNums.add(checkNums) : odCheckNums.subtract(checkNums);
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal2 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(odEditList)) {
                this.orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    private PurchaseOrderVO changToNcVO(CheckEntity check, List<CheckDetailEntity> checkBList, String pkUser) {
        PurchaseOrderVO checkVO = new PurchaseOrderVO();
        PurchaseOrderHeadVO checkHVO = this.changeToNcHVO(check, pkUser);
        List<PurchaseOrderBodyVO> checkBVOList = this.changeToNcBVO(check, checkBList);
        checkVO.setPurchaseOrderHeadVO(checkHVO);
        checkVO.setPurchaseOrderBodyVO(checkBVOList.toArray(new PurchaseOrderBodyVO[0]));
        return checkVO;
    }

    private PurchaseOrderHeadVO changeToNcHVO(CheckEntity check, String pkUser) {
        PurchaseOrderHeadVO checkVO = new PurchaseOrderHeadVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        checkVO.setPk_corp(check.getOrgSourceId());
        checkVO.setNversion(1);
        checkVO.setDbilldate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));
        checkVO.setCbiztype("0001N510000000036VJ3");
        checkVO.setPk_project(check.getProjectSourceId());
        checkVO.setCwarehouseid(check.getCwarehouseid());
        checkVO.setCpurorganization(check.getCkcorgid());
        checkVO.setCvendormangid(check.getSupplierSourceId());
        checkVO.setCdispatcherid(check.getCdispatcherid());
        checkVO.setCpurorganization2(check.getCpurorganization());
        checkVO.setCdptid(check.getCdptid());
        checkVO.setVmemo(check.getBillCode());
        checkVO.setVbeizhu(check.getConstruction());
        checkVO.setNtaxrate(BigDecimal.valueOf(0L));
        checkVO.setPk_defdoc5(sdf.format(new Date()));
        checkVO.setFrom_source("qlhpt_00000001");
        checkVO.setWebsite("http://wei.cscec5b.com.cn:9000/pca/index.html#/pca/acptBook/detail2?pkCheck=" + check.getId());
        checkVO.setTmaketime(sdf.format(new Date()));
        checkVO.setCoperator(pkUser);
        checkVO.setDauditdate(sdf.format(new Date()));
        checkVO.setCauditpsn(pkUser);
        checkVO.setPk_transfer(String.valueOf(check.getId()));
        checkVO.setCwhsmanagerid(check.getCreateUserSourceId());
        return checkVO;
    }

    private List<PurchaseOrderBodyVO> changeToNcBVO(CheckEntity check, List<CheckDetailEntity> checkBList) {
        ArrayList<PurchaseOrderBodyVO> checkBVOList = new ArrayList<PurchaseOrderBodyVO>();
        if (checkBList != null && checkBList.size() > 0) {
            for (CheckDetailEntity checkB : checkBList) {
                PurchaseOrderBodyVO checkBVO = new PurchaseOrderBodyVO();
                checkBVO.setPk_contract(check.getContractId());
                checkBVO.setContract_name(check.getContractName());
                checkBVO.setPk_cinventory(checkB.getMaterialSourceId());
                checkBVO.setCinventorycode(checkB.getMaterialCode());
                checkBVO.setCinventoryname(checkB.getMaterialName());
                checkBVO.setInvspec(checkB.getSpec());
                checkBVO.setPk_measddoc(checkB.getDef1());
                BigDecimal number = checkB.getCheckNumsSum() == null ? BigDecimal.ZERO : checkB.getCheckNumsSum();
                checkBVO.setNinnum(number);
                BigDecimal nprice = checkB.getNprice() == null ? BigDecimal.ZERO : checkB.getNprice();
                checkBVO.setNprice(nprice);
                BigDecimal mny = number.multiply(nprice);
                checkBVO.setNmny(mny.setScale(2, 4));
                BigDecimal taxrate = checkB.getTax() == null ? BigDecimal.ZERO : checkB.getTax();
                checkBVO.setNtaxrate_b(taxrate);
                BigDecimal taxmny = number.multiply(nprice).multiply(taxrate).divide(new BigDecimal(100));
                checkBVO.setTaxmny(taxmny.setScale(2, 4));
                checkBVO.setNtaxmny(mny.add(taxmny).setScale(2, 4));
                checkBVO.setDbizdate(new SimpleDateFormat("yyyy-MM-dd").format(check.getCheckDate()));
                checkBVO.setVnotebody(checkB.getMemo());
                checkBVO.setVdef20(checkB.getMaterialManufacturer());
                checkBVOList.add(checkBVO);
            }
        }
        return checkBVOList;
    }

    @Override
    public CommonResponse<JSONObject> poundList(String id) {
        this.logger.info("------------  \u67e5\u8be2\u78c5\u5355\u5217\u8868  ------------");
        String url = "http://47.94.227.96:9001//el/sw/weigh/check/list";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkCheck", String.valueOf(id));
        return this.doGetHttp(url, params);
    }

    @Override
    public CommonResponse<JSONObject> poundDetail(String pkWeighBill) {
        this.logger.info("------------  \u67e5\u8be2\u78c5\u5355\u8be6\u60c5\uff0c\u8bf7\u6c42\u6210\u529f\uff01  ------------");
        String url = "http://47.94.227.96:9001//el/sw/weigh/detail";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkWeighBill", pkWeighBill);
        return this.doGetHttp(url, params);
    }

    private CommonResponse<JSONObject> writeBackCheckToSupplier(String deliveryId, Boolean isCheck) {
        this.logger.info("------------  \u56de\u5199\u4f9b\u65b9\u53d1\u8d27\u5355\u9a8c\u6536\u72b6\u6001  ------------");
        String url = "http://47.94.227.96:9001//el/delivery/delivery/check";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkDelivery", String.valueOf(deliveryId));
        params.put("isCheck", String.valueOf(isCheck));
        return this.doGetHttp(url, params);
    }

    private CommonResponse<JSONObject> writeBackOpenDelivery(String deliveryId, Boolean isClose) {
        this.logger.info("------------  \u56de\u5199\u4f9b\u65b9\u53d1\u8d27\u5355\u5f00\u542f  ------------");
        String url = "http://47.94.227.96:9001//el/delivery/delivery/close";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pkDelivery", String.valueOf(deliveryId));
        params.put("isClose", String.valueOf(isClose));
        return this.doGetHttp(url, params);
    }

    public CommonResponse<String> getAccessToken(Map<String, String> headers) {
        if (this.redisTemplate.opsForValue().get((Object)"X-Open-Token") != null) {
            headers.put("X-Open-Token", this.redisTemplate.opsForValue().get((Object)"X-Open-Token").toString());
        } else {
            String initContextUrl = "http://47.94.227.96:9001//el/sw/auth/v1/accessToken?appId=6de82f4q&secret=@zLc1HUc";
            String responseStr = null;
            try {
                responseStr = HttpTookit.get(initContextUrl, null);
                JSONObject json = JSONObject.parseObject((String)responseStr);
                if (!"200".equals(json.get((Object)"code").toString())) {
                    return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
                }
                JSONObject data = json.getJSONObject("body");
                String access_token = data.get((Object)"token").toString();
                headers.put("X-Open-Token", access_token);
                this.redisTemplate.opsForValue().set((Object)"X-Open-Token", (Object)access_token, 6000L, TimeUnit.SECONDS);
                this.logger.info("------------  \u83b7\u53d6access_token\u670d\u52a1\uff0c\u8bf7\u6c42\u6210\u529f\uff01data = " + data + "  ------------");
            }
            catch (GeneralSecurityException e) {
                this.logger.info("GeneralSecurityException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
            catch (IOException e) {
                this.logger.info("IOException \u5f02\u5e38" + e.getMessage());
                return CommonResponse.error((String)"\u83b7\u53d6\u4f9b\u65b9access_token\u5f02\u5e38");
            }
        }
        return CommonResponse.success();
    }

    private CommonResponse<JSONObject> doGetHttp(String url, Map<String, String> params) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.getAccessToken(headers);
        try {
            String back = HttpTookit.get(url, params, headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if ("200".equals(jsonBack.getString("code"))) {
                this.logger.info("------------  \u8bf7\u6c42\u6210\u529f\uff01data = " + jsonBack.getString("data") + "  ------------");
                return CommonResponse.success((Object)jsonBack.getJSONObject("data"));
            }
            this.logger.error("------------  \u8bf7\u6c42\u5931\u8d25\uff01message = " + jsonBack.getString("message") + "  ------------");
            return CommonResponse.error((String)jsonBack.getString("message"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25!");
        }
    }
}

